/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.radutil;

import com.axlradius.radclient4.ClientReceiveException;
import com.axlradius.radclient4.ClientSendException;
import com.axlradius.radclient4.PacketType;
import com.axlradius.radclient4.RADIUSClient;
import com.axlradius.radclient4.RADIUSException;
import com.axlradius.radclient4.TimeoutContext;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.auth.digest.client.ClientDigest;
import com.axlradius.radclient4.auth.eap.ClientLayer;
import com.axlradius.radclient4.auth.eap.EAPClientParameters;
import com.axlradius.radclient4.auth.eap.EAPTypeClientParameters;
import com.axlradius.radclient4.auth.eap.PublicState;
import com.axlradius.radclient4.auth.eap.gtc.client.GTCClientParameters;
import com.axlradius.radclient4.auth.eap.leap.client.LEAPClientParameters;
import com.axlradius.radclient4.auth.eap.md5.client.MD5ClientParameters;
import com.axlradius.radclient4.auth.eap.mschapv2.client.MSCHAPV2ClientParameters;
import com.axlradius.radclient4.auth.eap.tls.CertificateCallbackInfo;
import com.axlradius.radclient4.auth.eap.tls.ServerCertificateHandler;
import com.axlradius.radclient4.auth.eap.tls.TLSClientParameters;
import com.axlradius.radclient4.auth.eap.tls.TLSParameters;
import com.axlradius.radclient4.auth.eap.tls.client.TLSAuthClientParameters;
import com.axlradius.radclient4.auth.eap.tls.peap.client.PEAPClientParameters;
import com.axlradius.radclient4.auth.eap.tls.ttls.client.AuthType;
import com.axlradius.radclient4.auth.eap.tls.ttls.client.TTLSClientParameters;
import com.axlradius.radclient4.auth.mschap.MPPEClient;
import com.axlradius.radclient4.auth.mschap.MSChap;
import com.axlradius.radclient4.dictionary.DefaultDictionary;
import com.axlradius.radclient4.radutil.Rand;
import com.axlradius.radclient4.radutil.Util;
import java.io.File;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class radauth
implements ServerCertificateHandler {
    private String f;
    private byte[] ai;
    private String v;
    private String name;
    private String identity;
    private String y;
    private String password;
    private int aM;
    private int aN;
    private String z;
    private Map<String, String> j;
    private RADIUSClient a;
    private String A;
    private char[] f;
    private char[] g;

    public static final void main(String[] object) {
        try {
            Object object2;
            Object object3 = object;
            object = new radauth();
            Object object4 = object3;
            object3 = object;
            int n2 = 0;
            Object object5 = null;
            if (((String[])object4).length < 6) {
                super.d("Too few arguments");
            }
            ++n2;
            ((radauth)object3).name = object4[0];
            try {
                Object object6 = object3;
                ((radauth)object3).identity = null;
                ((radauth)object6).y = null;
                object2 = ((radauth)object6).name.split(":");
                switch (((String[])object2).length) {
                    case 1: {
                        ((radauth)object6).name = object2[0];
                        ((radauth)object6).identity = object2[0];
                        ((radauth)object6).y = object2[0];
                        break;
                    }
                    case 2: {
                        ((radauth)object6).name = object2[0];
                        ((radauth)object6).identity = object2[1];
                        ((radauth)object6).y = object2[1];
                        break;
                    }
                    case 3: {
                        ((radauth)object6).name = object2[0];
                        ((radauth)object6).identity = object2[1];
                        ((radauth)object6).y = object2[2];
                        break;
                    }
                    case 0: {
                        throw new IllegalArgumentException("Must have at least one name for authentication");
                    }
                    default: {
                        throw new IllegalArgumentException("Too many names");
                    }
                }
                if (((radauth)object6).identity == null || ((radauth)object6).identity.length() == 0) {
                    ((radauth)object6).identity = ((radauth)object6).name;
                }
                if (((radauth)object6).y == null || ((radauth)object6).y.length() == 0) {
                    ((radauth)object6).y = ((radauth)object6).identity;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                super.d("Malformed user_name");
            }
            ++n2;
            ((radauth)object3).password = object4[1];
            ++n2;
            ((radauth)object3).z = object4[2].toUpperCase();
            ++n2;
            object2 = object4[3];
            int n3 = ((String)object2).indexOf(58);
            if (n3 >= 0) {
                ((radauth)object3).f = ((String)object2).substring(0, n3);
                try {
                    object5 = ((String)object2).substring(n3 + 1);
                    ((radauth)object3).aN = Integer.parseInt((String)object5);
                }
                catch (NumberFormatException numberFormatException) {
                    super.d("Server port number [" + (String)object5 + "] not a number.");
                }
            } else {
                ((radauth)object3).f = object2;
                ((radauth)object3).aN = 1812;
            }
            ++n2;
            ((radauth)object3).ai = Util.toUTF8(object4[4]);
            try {
                ++n2;
                object5 = object4[5];
                ((radauth)object3).aM = Integer.parseInt((String)object5);
            }
            catch (NumberFormatException numberFormatException) {
                super.d("Nas-Port number [" + (String)object5 + "] not a number.");
            }
            if (((String[])object4).length == 8) {
                ((radauth)object3).v = object4[((String[])object4).length - 1];
            }
            super.a(((radauth)object3).z, (String[])object4, n2);
            int n4 = 0;
            object4 = null;
            Object object7 = Thread.currentThread();
            Object object8 = "radauth." + (System.currentTimeMillis() & 0xFFFL) + ": " + ((radauth)object).z;
            ((Thread)object7).setName((String)object8);
            System.out.println("Radtest running RADIUS client version 4.08b " + Rand.getVersion());
            try {
                ((radauth)object).a = new RADIUSClient(((radauth)object).f, ((radauth)object).aN, ((radauth)object).ai, TimeoutContext.AUTHENTICATION.getContext());
                ((radauth)object).a.setDebug(true);
                ((radauth)object).a.addDictionary(new DefaultDictionary());
                object4 = InetAddress.getLocalHost();
            }
            catch (SocketException socketException) {
                super.fatalError("Radius failed: " + socketException.getMessage());
            }
            catch (UnknownHostException unknownHostException) {
                super.fatalError("Radius failed: " + unknownHostException.getMessage());
            }
            System.out.println("\n-------------------------------- Authentication -------------------------------");
            System.out.println("Authenticating: " + ((radauth)object).name);
            System.out.println("Sending to server " + ((radauth)object).f + ":" + ((radauth)object).aN);
            object7 = Util.toUTF8(((radauth)object).name);
            object8 = Util.toUTF8(((radauth)object).password);
            try {
                object5 = new AttributeList();
                if (((radauth)object).v == null) {
                    ((AttributeList)object5).add(4, (InetAddress)object4);
                }
                if (((radauth)object).v != null) {
                    ((AttributeList)object5).add(32, ((radauth)object).v);
                }
                ((AttributeList)object5).add(5, ((radauth)object).aM);
                ((AttributeList)object5).add(1, (byte[])object7);
                ((AttributeList)object5).add(61, 15);
                System.out.println("Sending Attributes:\n" + object5);
                if (((radauth)object).z.equals("PAP")) {
                    object4 = new AttributeList((AttributeList)object5);
                    ((radauth)object).a.createPAP((byte[])object8, (AttributeList)object4);
                    n4 = ((radauth)object).a.authenticate((AttributeList)object4);
                } else if (((radauth)object).z.equals("CHAP")) {
                    object4 = new AttributeList((AttributeList)object5);
                    ((radauth)object).a.createCHAP((byte[])object8, (AttributeList)object4);
                    n4 = ((radauth)object).a.authenticate((AttributeList)object4);
                } else if (((radauth)object).z.equals("MSCHAP")) {
                    try {
                        ((radauth)object).a.createMSCHAP((byte[])object8, (AttributeList)object5);
                    }
                    catch (RADIUSException rADIUSException) {
                        super.fatalError("Can't access the DES encoding algorithm -:" + rADIUSException.getMessage());
                    }
                    n4 = ((radauth)object).a.authenticate((AttributeList)object5);
                    if (n4 == 2) {
                        object4 = new MPPEClient();
                        ((MPPEClient)object4).extract(((radauth)object).a.getAttributes(), ((radauth)object).a.getSecret(), ((radauth)object).a.getAuthenticator());
                        if (((MPPEClient)object4).hasV1Keys()) {
                            System.out.println("MPPE keys: " + Util.toHexString(((MPPEClient)object4).getMPPEKeys()));
                        }
                    }
                } else if (((radauth)object).z.equals("MSCHAPV2")) {
                    try {
                        ((radauth)object).a.createMSCHAP2((byte[])object7, (byte[])object8, (AttributeList)object5);
                        n4 = ((radauth)object).a.authenticate((AttributeList)object5);
                        if (!((radauth)object).a.cmpMSCHAP2((byte[])object7, (byte[])object8, ((radauth)object).a.getAttributes())) {
                            System.out.println("MS-CHAP V2: Failed to authenticate the server.");
                            n4 = 3;
                        }
                    }
                    catch (RADIUSException rADIUSException) {
                        super.fatalError("Can't access the DES encoding algorithm -:" + rADIUSException.getMessage());
                    }
                } else if (((radauth)object).z.equals("DIGEST")) {
                    try {
                        n4 = new ClientDigest(((radauth)object).a, (AttributeList)object5).authenticate();
                    }
                    catch (RADIUSException rADIUSException) {
                        super.fatalError("Error: performing digest authentication: " + rADIUSException.getMessage());
                        n4 = 0;
                    }
                } else if (((radauth)object).z.startsWith("EAP")) {
                    object4 = null;
                    try {
                        object4 = new ClientLayer(((radauth)object).a);
                    }
                    catch (Exception exception) {
                        super.fatalError("EAP: Unable to load the EAP ClientLayer: " + exception.getMessage());
                    }
                    super.logToDebug("radauth: Running EAP authentication.");
                    object2 = null;
                    if (((radauth)object).A != null) {
                        object2 = new TLSClientParameters();
                        ((TLSParameters)object2).setMaximumEAPDataSize(1024);
                        ((TLSClientParameters)object2).setCertificateHandler((ServerCertificateHandler)object);
                        try {
                            ((TLSParameters)object2).setKeyStore(((radauth)object).A, ((radauth)object).f, ((radauth)object).g);
                        }
                        catch (Exception exception) {
                            super.d("EAP: Failed to load key store - " + exception.getMessage());
                        }
                    }
                    byte[] byArray = Util.toUTF8("anonymous");
                    for (String string : ((radauth)object).j.keySet()) {
                        EAPClientParameters eAPClientParameters;
                        if (string.equals("EAP-MD5")) {
                            eAPClientParameters = new MD5ClientParameters((byte[])object7, (AttributeList)object5);
                            eAPClientParameters.setPassword((byte[])object8, MD5ClientParameters.PLAINTEXT);
                            ((ClientLayer)object4).add(eAPClientParameters);
                            continue;
                        }
                        if (string.equals("EAP-TLS")) {
                            eAPClientParameters = new TLSAuthClientParameters(byArray, (AttributeList)object5);
                            eAPClientParameters.setTLSParameters((TLSClientParameters)object2);
                            ((ClientLayer)object4).add(eAPClientParameters);
                            continue;
                        }
                        if (string.equals("EAP-TTLS")) {
                            eAPClientParameters = new TTLSClientParameters(byArray, (byte[])object7, (AttributeList)object5);
                            eAPClientParameters.setTLSParameters((TLSClientParameters)object2);
                            string = ((radauth)object).j.get(string);
                            AuthType authType = ((TTLSClientParameters)eAPClientParameters).nameToAuthType(string);
                            if (authType.equals((Object)AuthType.UNKNOWN)) {
                                super.d("TTLS authentication type of " + string + " is not available.");
                            }
                            ((TTLSClientParameters)eAPClientParameters).setAuthentication(authType, (byte[])object8, EAPClientParameters.PLAINTEXT);
                            ((ClientLayer)object4).add(eAPClientParameters);
                            continue;
                        }
                        if (string.equals("EAP-PEAP")) {
                            eAPClientParameters = new PEAPClientParameters(byArray, (byte[])object7, (AttributeList)object5);
                            eAPClientParameters.setPassword((byte[])object8, MSChap.PasswordType.PLAINTEXT);
                            eAPClientParameters.setTLSParameters((TLSClientParameters)object2);
                            ((ClientLayer)object4).add(eAPClientParameters);
                            continue;
                        }
                        if (string.equals("EAP-LEAP")) {
                            eAPClientParameters = new LEAPClientParameters((byte[])object7, (AttributeList)object5);
                            eAPClientParameters.setPassword((byte[])object8, MSChap.PasswordType.PLAINTEXT);
                            ((ClientLayer)object4).add(eAPClientParameters);
                            continue;
                        }
                        if (string.equals("EAP-GTC")) {
                            eAPClientParameters = new GTCClientParameters((byte[])object7, (AttributeList)object5);
                            eAPClientParameters.setPassword((byte[])object8, MSChap.PasswordType.PLAINTEXT);
                            ((ClientLayer)object4).add(eAPClientParameters);
                            continue;
                        }
                        if (string.equals("EAP-MSCHAPV2")) {
                            eAPClientParameters = new MSCHAPV2ClientParameters((byte[])object7, (AttributeList)object5);
                            eAPClientParameters.setPassword((byte[])object8, MSChap.PasswordType.PLAINTEXT);
                            ((ClientLayer)object4).add(eAPClientParameters);
                            continue;
                        }
                        super.d("EAP authentication type of " + string + " is not available.");
                    }
                    Object object9 = PublicState.NONE;
                    try {
                        object9 = ((ClientLayer)object4).authenticate();
                    }
                    catch (Exception exception) {
                        super.fatalError("EAP: Unable to authenticate: " + exception.getMessage());
                    }
                    if (((radauth)object).a.getPacketType() != 2) {
                        super.logToDebug("Error: Packet type " + PacketType.getName(((radauth)object).a.getPacketType()) + " received.");
                        super.logToDebug("PublicState is " + object9);
                        ((radauth)object).a.close();
                        System.exit(1);
                    }
                    System.out.print("EAP Authentication: ");
                    switch (1.f[((Enum)object9).ordinal()]) {
                        case 1: {
                            System.out.println("Succeeded.");
                            System.out.println(((radauth)object).a.getAttributes());
                            ((radauth)object).a.close();
                            System.exit(0);
                            break;
                        }
                        case 2: {
                            super.fatalError("Authentication Failed - " + ((PublicState)((Object)object9)).getMessage());
                            break;
                        }
                        case 3: {
                            super.fatalError("Error - " + ((PublicState)((Object)object9)).getMessage());
                            break;
                        }
                        default: {
                            super.fatalError("Error - unexpected state " + object9);
                        }
                    }
                    super.fatalError("Should not get here.");
                    System.exit(4);
                } else if (((radauth)object).z.equals("SHUTDOWN")) {
                    object4 = new AttributeList((AttributeList)object5);
                    ((AttributeList)object4).add(6, 66);
                    ((radauth)object).a.createPAP((byte[])object8, (AttributeList)object4);
                    n4 = ((radauth)object).a.authenticate((AttributeList)object4);
                } else {
                    System.out.println("Error: unknown authentication type: " + ((radauth)object).z);
                    System.exit(1);
                }
                switch (n4) {
                    case 3: {
                        super.fatalError("Failed to authenticate");
                        break;
                    }
                    case 0: {
                        super.fatalError("Error: " + ((radauth)object).a.getErrorString());
                        break;
                    }
                    case 11: {
                        System.out.println("Unexpected Access-Challenge.");
                        break;
                    }
                    case 2: {
                        System.out.println("Authenticated");
                        object5 = ((radauth)object).a.getAttributes();
                        System.out.println("Attributes returned from server:\n" + object5);
                        break;
                    }
                    default: {
                        super.fatalError("Unexpected packet type returned: " + n4);
                        break;
                    }
                }
            }
            catch (ClientReceiveException clientReceiveException) {
                super.fatalError("Radius authentication failed: " + clientReceiveException.getMessage());
            }
            catch (ClientSendException clientSendException) {
                super.fatalError("Radius authentication failed: " + clientSendException.getMessage());
            }
            System.exit(0);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public void certificateHandler(CertificateCallbackInfo x509CertificateArray) {
        x509CertificateArray = x509CertificateArray.getServerCertificates();
        this.logToDebug("Certificate Callback: there are " + x509CertificateArray.length + " server certificates.");
    }

    private void a(String stringArray, String[] object, int n2) {
        if (!stringArray.startsWith("EAP")) {
            return;
        }
        this.j = radauth.a((String)stringArray);
        System.out.println("Using EAP Types: " + this.j);
        stringArray = this.j.keySet().iterator();
        while (stringArray.hasNext()) {
            String string = (String)stringArray.next();
            if (!string.equals("EAP-TLS") && !string.startsWith("EAP-TTLS") && !string.equals("EAP-PEAP") && !string.equals("EAP-PEAPV1") && !string.equals("EAP-EXPR") && !string.equals("EAP-FAST") || n2 >= ((String[])object).length) continue;
            stringArray = object[n2];
            Object object2 = stringArray;
            object = this;
            boolean bl = false;
            if (((String)object2).charAt(1) == ':') {
                object2 = new StringBuilder((String)object2);
                ((StringBuilder)object2).setCharAt(1, '#');
                object2 = ((StringBuilder)object2).toString();
                bl = true;
            }
            object2 = ((String)object2).split(":");
            switch (((String[])object2).length) {
                case 1: {
                    ((radauth)object).A = object2[0];
                    ((radauth)object).f = new char[0];
                    ((radauth)object).g = new char[0];
                    break;
                }
                case 2: {
                    ((radauth)object).A = object2[0];
                    ((radauth)object).f = ((String)object2[1]).toCharArray();
                    ((radauth)object).g = new char[0];
                    break;
                }
                case 3: {
                    ((radauth)object).A = object2[0];
                    ((radauth)object).f = ((String)object2[1]).toCharArray();
                    ((radauth)object).g = ((String)object2[2]).toCharArray();
                    break;
                }
                case 0: {
                    throw new IllegalArgumentException("Must have at least the KeyStore path for TLS");
                }
                default: {
                    throw new IllegalArgumentException("Too many parts for the KeyStore argument");
                }
            }
            if (bl) {
                object2 = new StringBuilder(((radauth)object).A);
                ((StringBuilder)object2).setCharAt(1, ':');
                ((radauth)object).A = ((StringBuilder)object2).toString();
            }
            if (((File)(object = new File(this.A))).exists() && ((File)object).isFile()) break;
            this.d("TLS '" + object + "' store argument '" + (String)stringArray + "' is not a file.");
            return;
        }
    }

    private static Map<String, String> a(String string2) throws IllegalArgumentException {
        EAPTypeClientParameters eAPTypeClientParameters;
        String[] stringArray;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String[] stringArray2 = string2.split(":");
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            stringArray = stringArray2[i2].toUpperCase();
            if (stringArray.startsWith("EAP-TTLS")) {
                String[] stringArray3 = stringArray.split("\\.");
                if (stringArray3.length != 2) {
                    throw new IllegalArgumentException("TTLS authentication needs an authentication type in: " + (String)stringArray);
                }
                linkedHashMap.put("EAP-TTLS", (String)stringArray3[1]);
                continue;
            }
            if (!stringArray.startsWith("EAP")) {
                throw new IllegalArgumentException("Unknown EAPz type: " + (String)stringArray);
            }
            linkedHashMap.put((String)stringArray, (String)null);
        }
        switch (stringArray2.length) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                throw new IllegalArgumentException("Must have at least one name for authentication");
            }
            default: {
                throw new IllegalArgumentException("More than two parts in " + string2);
            }
        }
        try {
            eAPTypeClientParameters = new EAPTypeClientParameters();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error getting supported EAP types: " + exception.getMessage());
        }
        stringArray = eAPTypeClientParameters.getSupportedEAPTypeNames();
        for (String string2 : linkedHashMap.keySet()) {
            boolean bl = false;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray[i3].equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException("Unknown EAP type " + string2);
        }
        return linkedHashMap;
    }

    private void fatalError(String string) {
        string = "Exiting " + string;
        System.err.println(string);
        if (this.a != null) {
            this.logToDebug(string);
            this.a.close();
        }
        System.exit(1);
    }

    private void d(String string) {
        System.out.println("Usage Error: " + string);
        System.out.println();
        System.out.println("radauth User-Name password auth_type server[:port default is 1812] secretkey NAS-Port [NAS-Identifier]\n");
        System.out.println("Auth type may be PAP, CHAP, MSCHAP, MSCHAPV2,\n\tEAP-LEAP, EAP-MD5, EAP-MSCHAPV2, EAP-PEAP EAP-TLS,\n\tEAP-TTLS:[PAP, CHAP, MSCHAP, MSCHAPV2, EAP-MSCHAP]");
        System.out.println();
        System.out.println("E.g. radauth michael test PAP 192.168.1.1 123testsecret");
        System.out.println("The login_name may have two parts.\n The separator character is the ':' (colon). The first name will be the User-Name\n The second value is the EAP tunneled name. The authentication method will use the appropriate names.\n");
        System.out.println("TLS authentication one or two additional arguments are required:");
        System.out.println("<keystore path>  <keystore password>");
        System.out.println("E.g. radauth michael test PEAP 192.168.1.1 testsecret 123 /etc/cert/caStore:whatever:password");
        System.out.println("E.g. radauth michael test TTLS:CHAP 192.168.1.1 testsecret 123 /etc/cert/clientStore:whatever:password");
        if (this.a != null) {
            this.a.close();
        }
        System.exit(1);
    }

    private void logToDebug(String string) {
        if (this.a.getDebugIndicator()) {
            this.a.logToDebug(string);
        }
    }

    static final class 1 {
        static final /* synthetic */ int[] f;

        static {
            f = new int[PublicState.values().length];
            try {
                1.f[PublicState.COMPLETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.f[PublicState.FAIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.f[PublicState.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

