/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wifi;

import com.ubnt.A;
import com.ubnt.data.Site;
import com.ubnt.model.F.new;
import com.ubnt.model.api.wifi.ap.WifiApStatisticsDto;
import com.ubnt.model.api.wifi.client.WifiClientStatisticsDto;
import com.ubnt.model.api.wifi.radio.WifiChannelizationStatisticsDto;
import com.ubnt.model.api.wifi.radio.WifiChannelizationStatisticsRequestDto;
import com.ubnt.model.api.wifi.radio.WifiRadioStatisticsDto;
import com.ubnt.net.v2.ApiFilterUtils;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.RequireUCoreLocal;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.wifi.Object.F;
import com.ubnt.service.wifi.Object.J;
import com.ubnt.service.wifi.Object.OoOO;
import com.ubnt.service.wifi.Object.super;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="WiFi Statistics")
public class WifiStatisticsController {
    static final String \u00d400000 = "7.1.5";
    static final String \u00d200000 = "7.3.11";
    static final List<Integer> super = List.of(Integer.valueOf(25), Integer.valueOf(50), Integer.valueOf(75), Integer.valueOf(90), Integer.valueOf(95));
    private final Clock \u00d300000;
    private final OoOO \u00d800000;
    private final F class;
    private final super \u00d600000;

    public WifiStatisticsController(Clock clock, OoOO ooOO2, F f2, super super_) {
        this.\u00d300000 = clock;
        this.\u00d800000 = ooOO2;
        this.class = f2;
        this.\u00d600000 = super_;
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/details"})
    @Operation(summary="WiFi Client statistics", description="Since 7.1")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiClientStatisticsDto wifiClientStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @Parameter(name="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @Parameter(name="Filter end in unix epoch seconds") Long l3, @RequestParam(value="apMac", required=false) @MacAddress(allowAll=true) @MacAddress(allowAll=true) String string, @RequestParam(value="watchlistTableSize", required=false) @Min(value=1L) @Parameter(name="Size of top user list returned") @Min(value=1L) Integer n2) {
        J j2 = J.int().\u00d600000(site.getId()).\u00f500000(new.\u00d500000(l2, ApiFilterUtils.getEndTimestamp(this.\u00d300000, l3))).public(ApiFilterUtils.getMacFilter(string)).\u00d6O0000(Optional.ofNullable(n2)).void(\u00d400000).\u00f400000();
        return WifiClientStatisticsDto.builder().clientDetails(this.\u00d800000.\u00d800000(j2)).build();
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/aps"})
    @Operation(summary="WiFi Access Point statistics", description="Since 7.3")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiApStatisticsDto wifiApStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @Parameter(name="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @Parameter(name="Filter end in unix epoch seconds") Long l3, @RequestParam(value="watchlistTableSize", required=false) @Min(value=1L) @Parameter(name="Size of top APs list returned") @Min(value=1L) Integer n2) {
        J j2 = J.int().\u00d600000(site.getId()).\u00f500000(new.\u00d500000(l2, ApiFilterUtils.getEndTimestamp(this.\u00d300000, l3))).\u00d6O0000(Optional.ofNullable(n2)).void(\u00d200000).\u00f400000();
        return WifiApStatisticsDto.builder().apDetails(this.class.\u00d8O0000(j2)).build();
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/radios"})
    @Operation(summary="WiFi Radio statistics", description="Since 7.6.24")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiRadioStatisticsDto wifiRadioStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @Parameter(name="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @Parameter(name="Filter end in unix epoch seconds") Long l3) {
        J j2 = J.int().\u00d600000(site.getId()).\u00f500000(new.\u00d500000(l2, ApiFilterUtils.getEndTimestamp(this.\u00d300000, l3))).void(\u00d200000).\u00f400000();
        return WifiRadioStatisticsDto.builder().radioDetails(this.\u00d600000.\u00f8O0000(j2)).build();
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/channelization"})
    @Operation(summary="WiFi Radio statistics for channelization")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiChannelizationStatisticsDto wifiChannelizationStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @Parameter(name="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @Parameter(name="Filter end in unix epoch seconds") Long l3, @RequestParam(value="apMac", required=false) @MacAddress(allowAll=true) @MacAddress(allowAll=true) String string) {
        J j2 = J.int().\u00d600000(site.getId()).\u00f500000(new.\u00d500000(l2, ApiFilterUtils.getEndTimestamp(this.\u00d300000, l3))).public(ApiFilterUtils.getMacFilter(string)).void(\u00d200000).\u00f400000();
        return WifiChannelizationStatisticsDto.builder().details(this.\u00d600000.\u00d200000(j2)).build();
    }

    @RequireUCoreLocal
    @PostMapping(value={"/api/site/{siteName}/wifi-stats/channelization"})
    @Operation(summary="WiFi Radio statistics for channel efficiency optimization")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiChannelizationStatisticsDto wifiChannelizationStatistics(@PathVariable(value="siteName") Site site, @RequestBody @Valid WifiChannelizationStatisticsRequestDto wifiChannelizationStatisticsRequestDto) {
        J j2 = J.int().\u00d600000(site.getId()).\u00f500000(new.\u00d500000(wifiChannelizationStatisticsRequestDto.startTimestamp(), ApiFilterUtils.getEndTimestamp(this.\u00d300000, wifiChannelizationStatisticsRequestDto.endTimestamp()))).public(ApiFilterUtils.getMacFilter(wifiChannelizationStatisticsRequestDto.apMac())).\u00f4O0000((Iterable<Integer>)Optional.of(wifiChannelizationStatisticsRequestDto).map(WifiChannelizationStatisticsRequestDto::percentiles).filter(A::\u00d4O0000).orElse(super)).\u00d4O0000(Optional.of(wifiChannelizationStatisticsRequestDto).map(WifiChannelizationStatisticsRequestDto::statNames).orElse(List.of())).\u00f6O0000(Optional.of(wifiChannelizationStatisticsRequestDto).map(WifiChannelizationStatisticsRequestDto::scale)).void(\u00d200000).\u00f400000();
        return this.\u00d600000.oo0000(j2);
    }
}

