/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.exception;

import com.ubnt.service.orchestration.exception.OrchestrationFetchDataException;
import com.ubnt.service.orchestration.validator.OrchestrationFetchDataError;
import com.ubnt.service.system.jA;
import com.ubnt.service.ucore.intsuper;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class OrchestrationFetchDataExceptionResolver {
    private static final Logger LOGGER = jA.\u00f6\u00d20000;
    private static final String FETCH_ORCHESTRATION_DATA_FAILURE_GENERIC_MESSAGE = "Failed to fetch the Orchestration data";

    public OrchestrationFetchDataException resolve(intsuper intsuper2) {
        if (intsuper2.o00000() != null) {
            return this.\u00d200000(intsuper2.o00000());
        }
        LOGGER.warn("Orchestration data fetch failed without response: {}", (Object)intsuper2.getCause().getMessage(), (Object)intsuper2);
        return new OrchestrationFetchDataException(OrchestrationFetchDataError.ORCHESTRATION_DATA_FETCH_FAILURE, FETCH_ORCHESTRATION_DATA_FAILURE_GENERIC_MESSAGE);
    }

    private OrchestrationFetchDataException \u00d200000(ResponseEntity<String> responseEntity) {
        if (this.o00000(responseEntity)) {
            return new OrchestrationFetchDataException(OrchestrationFetchDataError.ORCHESTRATION_DATA_MISMATCHED_INPUT_TEMPLATE_DATA, (String)responseEntity.getBody());
        }
        if (HttpStatus.NOT_FOUND == responseEntity.getStatusCode()) {
            return new OrchestrationFetchDataException(OrchestrationFetchDataError.ORCHESTRATION_DATA_NOT_FOUND, "Orchestration data not found");
        }
        if (HttpStatus.BAD_REQUEST == responseEntity.getStatusCode()) {
            return new OrchestrationFetchDataException(OrchestrationFetchDataError.ORCHESTRATION_DATA_BAD_FETCH_REQUEST, "Bad request: " + (String)responseEntity.getBody());
        }
        if (HttpStatus.FORBIDDEN == responseEntity.getStatusCode()) {
            return new OrchestrationFetchDataException(OrchestrationFetchDataError.ORCHESTRATION_DATA_FETCH_FORBIDDEN, "Access forbidden");
        }
        if (HttpStatus.UNAUTHORIZED == responseEntity.getStatusCode()) {
            return new OrchestrationFetchDataException(OrchestrationFetchDataError.ORCHESTRATION_DATA_FETCH_NOT_AUTHORIZED, "Unauthorized access");
        }
        LOGGER.warn("Orchestration data fetch failed with http status: {}, body: {}", (Object)responseEntity.getStatusCode(), responseEntity.getBody());
        return new OrchestrationFetchDataException(OrchestrationFetchDataError.ORCHESTRATION_DATA_FETCH_FAILURE, FETCH_ORCHESTRATION_DATA_FAILURE_GENERIC_MESSAGE);
    }

    private boolean o00000(ResponseEntity<String> responseEntity) {
        return HttpStatus.BAD_REQUEST == responseEntity.getStatusCode() && responseEntity.getHeaders().containsKey((Object)"Error-Code") && Objects.requireNonNullElse(responseEntity.getHeaders().get((Object)"Error-Code"), List.of()).stream().anyMatch("Mismatched-Input-Data"::equals);
    }
}

