/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import io.jenetics.util.ISeq;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class Args {
    private final ISeq<String> _args;

    private Args(String[] args) {
        this._args = ISeq.of((Object[])Objects.requireNonNull(args));
    }

    public Optional<String> arg(String name) {
        int index = this._args.indexOf("--" + name);
        if (index == -1) {
            index = this._args.indexOf("-" + name);
        }
        return index >= 0 && index < this._args.length() - 1 ? Optional.of(this._args.get(index + 1)) : Optional.empty();
    }

    public Optional<Integer> intArg(String name) {
        return this.arg(name).flatMap(s -> Args.parse(s, Integer::valueOf));
    }

    public ISeq<Integer> intArgs(String name) {
        return this.arg(name).map(Stream::of).orElseGet(Stream::empty).flatMap(a -> Stream.of(a.split("@"))).flatMap(s -> Args.parse(s, Integer::valueOf).map(Stream::of).orElseGet(Stream::empty)).collect(ISeq.toISeq());
    }

    public Optional<Long> longArg(String name) {
        return this.arg(name).flatMap(s -> Args.parse(s, Long::valueOf));
    }

    public Optional<Double> doubleArg(String name) {
        return this.arg(name).flatMap(s -> Args.parse(s, Double::valueOf));
    }

    private static <T> Optional<T> parse(String string, Function<String, T> parser) {
        Optional value = Optional.empty();
        try {
            value = Optional.of(parser.apply(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public String toString() {
        return this._args.toString();
    }

    public static Args of(String[] args) {
        return new Args(args);
    }
}

