/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.ParameterTracingInvocationUnit;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.optimize.info.ReferenceEscapeChecker;

public class ParameterEscapedMarker
extends SimplifiedVisitor
implements ClassPoolVisitor,
ClassVisitor,
MemberVisitor,
AttributeVisitor,
InstructionVisitor,
ConstantVisitor {
    private static boolean DEBUG = System.getProperty("pem") != null;
    private final ClassVisitor parameterEscapedMarker = new AllMethodVisitor(new AllAttributeVisitor(this));
    private final ValueFactory valueFactory = new BasicValueFactory();
    private final ReferenceTracingValueFactory tracingValueFactory = new ReferenceTracingValueFactory(this.valueFactory);
    private final PartialEvaluator partialEvaluator = new PartialEvaluator(this.tracingValueFactory, new ParameterTracingInvocationUnit(new BasicInvocationUnit(this.tracingValueFactory)), true, this.tracingValueFactory);
    private final ReferenceEscapeChecker referenceEscapeChecker = new ReferenceEscapeChecker(this.partialEvaluator, false);
    private boolean newEscapes;
    private Method referencingMethod;
    private int referencingOffset;
    private int referencingPopCount;

    @Override
    public void visitClassPool(ClassPool classPool) {
        do {
            this.newEscapes = false;
            if (DEBUG) {
                System.out.println("ParameterEscapedMarker: new iteration");
            }
            classPool.classesAccept(this.parameterEscapedMarker);
        } while (this.newEscapes);
        if (DEBUG) {
            classPool.classesAccept(new AllMethodVisitor(this));
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (DEBUG) {
            System.out.println("ParameterEscapedMarker: [" + programClass.getName() + "." + programMethod.getName(programClass) + programMethod.getDescriptor(programClass) + "]");
            int parameterSize = ClassUtil.internalMethodParameterSize(programMethod.getDescriptor(programClass), programMethod.getAccessFlags());
            for (int index = 0; index < parameterSize; ++index) {
                System.out.println("  " + (ParameterEscapedMarker.hasParameterEscaped(programMethod, index) ? (char)'e' : '.') + " P" + index);
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        this.referenceEscapeChecker.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.instructionsAccept(clazz, method, this.partialEvaluator.tracedInstructionFilter(this));
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.referencingMethod = method;
                this.referencingOffset = offset;
                this.referencingPopCount = constantInstruction.stackPopCount(clazz);
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        Method referencedMethod = (Method)refConstant.referencedMember;
        if (referencedMethod != null && MethodOptimizationInfo.getMethodOptimizationInfo(referencedMethod) instanceof ProgramMethodOptimizationInfo) {
            for (int parameterIndex = 0; parameterIndex < this.referencingPopCount; ++parameterIndex) {
                int stackEntryIndex = this.referencingPopCount - parameterIndex - 1;
                TracedStack stackBefore = this.partialEvaluator.getStackBefore(this.referencingOffset);
                Value stackEntry = stackBefore.getTop(stackEntryIndex);
                if (stackEntry.computationalType() != 5 || !this.hasEscapedBefore(this.referencingOffset, stackEntryIndex)) continue;
                this.markParameterEscaped(referencedMethod, parameterIndex);
            }
        }
    }

    private boolean hasEscapedBefore(int instructionOffset, int stackEntryIndex) {
        ReferenceValue referenceValue;
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(instructionOffset);
        Value stackEntry = stackBefore.getTop(stackEntryIndex);
        return stackEntry.computationalType() == 5 && (referenceValue = stackEntry.referenceValue()).isNull() != 1 && this.hasEscaped(referenceValue);
    }

    private boolean hasEscaped(ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int count = instructionOffsetValue.instructionOffsetCount();
        for (int index = 0; index < count; ++index) {
            if (!(instructionOffsetValue.isMethodParameter(index) ? ParameterEscapedMarker.hasParameterEscaped(this.referencingMethod, instructionOffsetValue.methodParameter(index)) : this.referenceEscapeChecker.isInstanceEscaping(instructionOffsetValue.instructionOffset(index)))) continue;
            return true;
        }
        return false;
    }

    private void markParameterEscaped(Method method, int parameterIndex) {
        ProgramMethodOptimizationInfo info = ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method);
        if (!info.hasParameterEscaped(parameterIndex)) {
            info.setParameterEscaped(parameterIndex);
            this.newEscapes = true;
        }
    }

    private void markEscapedParameters(Method method, long escapedParameters) {
        ProgramMethodOptimizationInfo info = ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method);
        if (((info.getEscapedParameters() ^ 0xFFFFFFFFFFFFFFFFL) & escapedParameters) != 0L) {
            info.updateEscapedParameters(escapedParameters);
            this.newEscapes = true;
        }
    }

    public static boolean hasParameterEscaped(Method method, int parameterIndex) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).hasParameterEscaped(parameterIndex);
    }

    public static long getEscapedParameters(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getEscapedParameters();
    }
}

