/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ShiftedReference;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapAddressSetView;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.DBTraceOffsetReference;
import ghidra.trace.database.symbol.DBTraceReference;
import ghidra.trace.database.symbol.DBTraceReferenceManager;
import ghidra.trace.database.symbol.DBTraceShiftedReference;
import ghidra.trace.database.symbol.DBTraceStackReference;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceReferenceSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.LazyCollection;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Stream;

public class DBTraceReferenceSpace
implements DBTraceSpaceBased,
TraceReferenceSpace {
    protected final DBTraceReferenceManager manager;
    protected final DBHandle dbh;
    protected final AddressSpace space;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final DBTrace trace;
    protected final AddressRangeImpl fullSpace;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceReferenceEntry, DBTraceReferenceEntry> referenceMapSpace;
    protected final DBCachedObjectIndex<Long, DBTraceReferenceEntry> refsBySymbolId;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceXRefEntry, DBTraceXRefEntry> xrefMapSpace;
    protected final DBCachedObjectIndex<Long, DBTraceXRefEntry> xrefsByRefKey;

    public DBTraceReferenceSpace(DBTraceReferenceManager manager, DBHandle dbh, AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        this.manager = manager;
        this.dbh = dbh;
        this.space = space;
        this.lock = manager.getLock();
        this.baseLanguage = manager.getBaseLanguage();
        this.trace = manager.getTrace();
        this.fullSpace = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
        DBCachedObjectStoreFactory factory = this.trace.getStoreFactory();
        this.referenceMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceReferenceEntry.tableName(space), this.trace, factory, this.lock, space, DBTraceReferenceEntry.class, (t, s, r) -> new DBTraceReferenceEntry(this, t, s, r));
        this.refsBySymbolId = this.referenceMapSpace.getUserIndex(Long.TYPE, DBTraceReferenceEntry.SYMBOL_ID_COLUMN);
        this.xrefMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceXRefEntry.tableName(space), this.trace, factory, this.lock, space, DBTraceXRefEntry.class, (t, s, r) -> new DBTraceXRefEntry(this, t, s, r));
        this.xrefsByRefKey = this.xrefMapSpace.getUserIndex(Long.TYPE, DBTraceXRefEntry.REF_KEY_COLUMN);
    }

    protected void doAddXRef(DBTraceReferenceEntry refEnt) {
        DBTraceXRefEntry xrefEnt = (DBTraceXRefEntry)this.xrefMapSpace.put(refEnt.toRange, refEnt.getLifespan(), null);
        xrefEnt.set((short)refEnt.getRange().getAddressSpace().getSpaceID(), refEnt.getKey());
    }

    protected void doDelXRef(DBTraceReferenceEntry refEnt) {
        for (DBTraceXRefEntry xrefEnt : this.xrefsByRefKey.get((Object)refEnt.getKey())) {
            if (xrefEnt.refSpaceId != refEnt.getRange().getAddressSpace().getSpaceID()) continue;
            this.xrefMapSpace.deleteData(xrefEnt);
            return;
        }
        throw new AssertionError();
    }

    protected void doSetXRefLifespan(DBTraceReferenceEntry refEnt) {
        for (DBTraceXRefEntry xrefEnt : this.xrefsByRefKey.get((Object)refEnt.getKey())) {
            if (xrefEnt.refSpaceId != refEnt.getRange().getAddressSpace().getSpaceID()) continue;
            xrefEnt.setLifespan(refEnt.getLifespan());
            return;
        }
        throw new AssertionError();
    }

    @Override
    public DBTrace getTrace() {
        return this.trace;
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public DBTraceReference addReference(TraceReference reference) {
        return this.addReference(reference.getLifespan(), reference);
    }

    @Override
    public DBTraceReference addReference(Lifespan lifespan, Reference reference) {
        AddressRangeImpl addressRangeImpl;
        if (reference.isOffsetReference()) {
            OffsetReference oRef = (OffsetReference)reference;
            return this.addOffsetReference(lifespan, oRef.getFromAddress(), oRef.getBaseAddress(), true, oRef.getOffset(), oRef.getReferenceType(), oRef.getSource(), oRef.getOperandIndex());
        }
        if (reference.isShiftedReference()) {
            ShiftedReference sRef = (ShiftedReference)reference;
            return this.addShiftedReference(lifespan, sRef.getFromAddress(), sRef.getToAddress(), sRef.getShift(), sRef.getReferenceType(), sRef.getSource(), sRef.getOperandIndex());
        }
        if (reference instanceof TraceReference) {
            TraceReference tref = (TraceReference)reference;
            addressRangeImpl = tref.getToRange();
        } else {
            addressRangeImpl = new AddressRangeImpl(reference.getToAddress(), reference.getToAddress());
        }
        AddressRangeImpl toRange = addressRangeImpl;
        return this.addMemoryReference(lifespan, reference.getFromAddress(), (AddressRange)toRange, reference.getReferenceType(), reference.getSource(), reference.getOperandIndex());
    }

    protected void makeWay(Lifespan span, Address fromAddress, AddressRange toRange, int operandIndex) {
        for (DBTraceReferenceEntry ent : this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)new AddressRangeImpl(fromAddress, fromAddress), span)).values()) {
            if (!ent.toRange.equals((Object)toRange) || ent.opIndex != operandIndex) continue;
            DBTraceUtils.makeWay(ent, span, (e, s) -> e.setLifespan((Lifespan)s), e -> e.ref.delete());
        }
    }

    @Override
    public DBTraceReference addMemoryReference(Lifespan lifespan, Address fromAddress, AddressRange toRange, RefType refType, SourceType source, int operandIndex) {
        if (operandIndex < -1) {
            throw new IllegalArgumentException("operandIndex");
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceReference ref;
            this.makeWay(lifespan, fromAddress, toRange, operandIndex);
            DBTraceReferenceEntry entry = (DBTraceReferenceEntry)this.referenceMapSpace.put(fromAddress, lifespan, null);
            entry.set(toRange, -1L, refType, operandIndex, 0L, false, TypeEnum.MEMORY, source);
            entry.ref = ref = TypeEnum.MEMORY.construct(entry);
            this.manager.doAddXRef(entry);
            DBTraceReference dBTraceReference = ref;
            return dBTraceReference;
        }
    }

    private boolean isExternalBlockAddress(Lifespan lifespan, Address addr) {
        TraceMemoryRegion region = this.trace.getMemoryManager().getRegionContaining(lifespan.lmin(), addr);
        return region != null && "EXTERNAL".equals(region.getName(lifespan.lmin()));
    }

    @Override
    public DBTraceOffsetReference addOffsetReference(Lifespan lifespan, Address fromAddress, Address toAddress, boolean toAddrIsBase, long offset, RefType refType, SourceType source, int operandIndex) {
        if (operandIndex < -1) {
            throw new IllegalArgumentException("operandIndex");
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            TypeEnum type = TypeEnum.OFFSET;
            boolean isExternalBlockRef = this.isExternalBlockAddress(lifespan, toAddress);
            boolean badOffsetReference = false;
            if (isExternalBlockRef) {
                type = TypeEnum.OFFSET_EXTERNAL;
                if (!toAddrIsBase) {
                    Address baseAddr = toAddress.subtractWrap(offset);
                    if (this.isExternalBlockAddress(lifespan, baseAddr)) {
                        toAddress = baseAddr;
                        toAddrIsBase = true;
                    } else {
                        isExternalBlockRef = false;
                        type = TypeEnum.OFFSET;
                        badOffsetReference = true;
                    }
                }
            } else if (toAddrIsBase) {
                toAddress = toAddress.addWrap(offset);
                toAddrIsBase = false;
                if (this.isExternalBlockAddress(lifespan, toAddress)) {
                    badOffsetReference = true;
                }
            }
            if (badOffsetReference) {
                Msg.warn((Object)this, (Object)("Offset Reference from " + String.valueOf(fromAddress) + " produces bad Xref into EXTERNAL block"));
            }
            AddressRangeImpl toRange = new AddressRangeImpl(toAddress, toAddress);
            this.makeWay(lifespan, fromAddress, (AddressRange)toRange, operandIndex);
            DBTraceReferenceEntry entry = (DBTraceReferenceEntry)this.referenceMapSpace.put(fromAddress, lifespan, null);
            entry.set((AddressRange)toRange, -1L, refType, operandIndex, offset, false, type, source);
            DBTraceOffsetReference ref = new DBTraceOffsetReference(entry, isExternalBlockRef);
            entry.ref = ref;
            this.manager.doAddXRef(entry);
            DBTraceOffsetReference dBTraceOffsetReference = ref;
            return dBTraceOffsetReference;
        }
    }

    @Override
    public DBTraceShiftedReference addShiftedReference(Lifespan lifespan, Address fromAddress, Address toAddress, int shift, RefType refType, SourceType source, int operandIndex) {
        if (operandIndex < -1) {
            throw new IllegalArgumentException("operandIndex");
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            AddressRangeImpl toRange = new AddressRangeImpl(toAddress, toAddress);
            this.makeWay(lifespan, fromAddress, (AddressRange)toRange, operandIndex);
            DBTraceReferenceEntry entry = (DBTraceReferenceEntry)this.referenceMapSpace.put(fromAddress, lifespan, null);
            entry.set((AddressRange)toRange, -1L, refType, operandIndex, shift, false, TypeEnum.SHIFT, source);
            DBTraceShiftedReference ref = new DBTraceShiftedReference(entry);
            entry.ref = ref;
            this.manager.doAddXRef(entry);
            DBTraceShiftedReference dBTraceShiftedReference = ref;
            return dBTraceShiftedReference;
        }
    }

    @Override
    public DBTraceReference addRegisterReference(Lifespan lifespan, Address fromAddress, Register toRegister, RefType refType, SourceType source, int operandIndex) {
        return this.addMemoryReference(lifespan, fromAddress, TraceRegisterUtils.rangeForRegister(toRegister), refType, source, operandIndex);
    }

    @Override
    public DBTraceReference addStackReference(Lifespan lifespan, Address fromAddress, int toStackOffset, RefType refType, SourceType source, int operandIndex) {
        AddressSpace stack = this.baseLanguage.getDefaultCompilerSpec().getStackSpace();
        Address toAddress = stack.getAddress((long)toStackOffset);
        AddressRangeImpl toRange = new AddressRangeImpl(toAddress, toAddress);
        return this.addMemoryReference(lifespan, fromAddress, (AddressRange)toRange, refType, source, operandIndex);
    }

    @Override
    public DBTraceReference getReference(long snap, Address fromAddress, AddressRange toRange, int operandIndex) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (DBTraceReferenceEntry entry : this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(fromAddress, snap)).values()) {
                if (!entry.toRange.equals((Object)toRange) || entry.opIndex != operandIndex) continue;
                DBTraceReference dBTraceReference = entry.ref;
                return dBTraceReference;
            }
            Iterator iterator = null;
            return iterator;
        }
    }

    private Stream<? extends DBTraceReference> streamReferencesFrom(long snap, Address fromAddress) {
        return this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(fromAddress, snap)).values().stream().map(e -> e.ref);
    }

    public Collection<? extends DBTraceReference> getReferencesFrom(long snap, Address fromAddress) {
        return this.streamReferencesFrom(snap, fromAddress).toList();
    }

    public Collection<? extends DBTraceReference> getReferencesFrom(long snap, Address fromAddress, int operandIndex) {
        return this.streamReferencesFrom(snap, fromAddress).filter(r -> r.getOperandIndex() == operandIndex).toList();
    }

    public Collection<? extends DBTraceReference> getReferencesFromRange(Lifespan span, AddressRange range) {
        return new LazyCollection(() -> this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values().stream().map(e -> e.ref));
    }

    @Override
    public DBTraceReference getPrimaryReferenceFrom(long snap, Address fromAddress, int operandIndex) {
        return this.streamReferencesFrom(snap, fromAddress).filter(r -> r.isPrimary() && r.getOperandIndex() == operandIndex).findFirst().orElse(null);
    }

    public Collection<? extends DBTraceReference> getFlowReferencesFrom(long snap, Address fromAddress) {
        return this.streamReferencesFrom(snap, fromAddress).filter(r -> r.getReferenceType().isFlow()).toList();
    }

    @Override
    public void clearReferencesFrom(Lifespan span, AddressRange range) {
        try (LockHold hold = this.manager.getTrace().lockWrite();){
            long startSnap = span.lmin();
            for (DBTraceReferenceEntry ref : this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values()) {
                this.truncateOrDeleteEntry(ref, startSnap);
            }
        }
    }

    protected DBTraceReferenceEntry getRefEntryForXRefEntry(DBTraceXRefEntry e) {
        AddressSpace fromAddressSpace = this.baseLanguage.getAddressFactory().getAddressSpace((int)e.refSpaceId);
        DBTraceReferenceSpace fromSpace = this.manager.getForSpace(fromAddressSpace, false);
        assert (fromSpace != null);
        return fromSpace.referenceMapSpace.getDataByKey(e.refKey);
    }

    protected DBTraceReference getRefForXRefEntry(DBTraceXRefEntry e) {
        return this.getRefEntryForXRefEntry((DBTraceXRefEntry)e).ref;
    }

    public Collection<? extends DBTraceReference> getReferencesTo(long snap, Address toAddress) {
        return this.xrefMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(toAddress, snap)).values().stream().map(this::getRefForXRefEntry).toList();
    }

    public Collection<? extends DBTraceReference> getReferencesToRange(Lifespan span, AddressRange range, Rectangle2DDirection order) {
        return new LazyCollection(() -> this.xrefMapSpace.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span).starting(order)).values().stream().map(this::getRefForXRefEntry));
    }

    protected void truncateOrDeleteEntry(DBTraceReferenceEntry ref, long otherStartSnap) {
        if (ref.getLifespan().lmin() < otherStartSnap) {
            Lifespan oldSpan = ref.getLifespan();
            ref.setEndSnap(otherStartSnap - 1L);
            this.trace.setChanged(new TraceChangeRecord<DBTraceReference, Lifespan>(TraceEvents.REFERENCE_LIFESPAN_CHANGED, this.space, ref.ref, oldSpan, ref.getLifespan()));
        } else {
            ref.ref.delete();
        }
    }

    @Override
    public void clearReferencesTo(Lifespan span, AddressRange range) {
        try (LockHold hold = this.manager.getTrace().lockWrite();){
            long startSnap = span.lmin();
            for (DBTraceXRefEntry xref : this.xrefMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values()) {
                DBTraceReferenceEntry ref = this.getRefEntryForXRefEntry(xref);
                this.truncateOrDeleteEntry(ref, startSnap);
            }
        }
    }

    @Override
    public AddressSetView getReferenceSources(Lifespan span) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<DBTraceReferenceEntry>(this.space, this.lock, this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)this.fullSpace, span)), e -> true);
    }

    @Override
    public AddressSetView getReferenceDestinations(Lifespan span) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<DBTraceXRefEntry>(this.space, this.lock, this.xrefMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)this.fullSpace, span)), e -> true);
    }

    @Override
    public int getReferenceCountFrom(long snap, Address fromAddress) {
        return this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(fromAddress, snap)).size();
    }

    @Override
    public int getReferenceCountTo(long snap, Address toAddress) {
        return this.xrefMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(toAddress, snap)).size();
    }

    protected Collection<? extends DBTraceReference> getReferencesBySymbolId(long id) {
        return this.refsBySymbolId.get((Object)id).stream().map(e -> e.ref).toList();
    }

    @Override
    public void invalidateCache() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.referenceMapSpace.invalidateCache();
            this.xrefMapSpace.invalidateCache();
        }
    }

    @DBAnnotatedObjectInfo(version=2)
    protected static class DBTraceReferenceEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceReferenceEntry>
    implements DBTraceOverlaySpaceAdapter.DecodesAddresses {
        private static final String TABLE_NAME = "References";
        private static final byte SOURCE_MASK = 15;
        private static final byte SOURCE_SHIFT = 0;
        private static final byte PRIMARY_MASK = 16;
        private static final byte PRIMARY_CLEAR = -17;
        private static final byte TYPE_MASK = 3;
        private static final byte TYPE_SHIFT = 5;
        static final String TO_ADDR_MIN_COLUMN_NAME = "ToAddrMin";
        static final String TO_ADDR_MAX_COLUMN_NAME = "ToAddrMax";
        static final String SYMBOL_ID_COLUMN_NAME = "SymbolId";
        static final String REF_TYPE_COLUMN_NAME = "RefType";
        static final String OP_INDEX_COLUMN_NAME = "OpIndex";
        static final String EXT_COLUMN_NAME = "Ext";
        static final String FLAGS_COLUMN_NAME = "Flags";
        @DBAnnotatedColumn(value="ToAddrMin")
        static DBObjectColumn TO_ADDR_MIN_COLUMN;
        @DBAnnotatedColumn(value="ToAddrMax")
        static DBObjectColumn TO_ADDR_MAX_COLUMN;
        @DBAnnotatedColumn(value="SymbolId")
        static DBObjectColumn SYMBOL_ID_COLUMN;
        @DBAnnotatedColumn(value="RefType")
        static DBObjectColumn REF_TYPE_COLUMN;
        @DBAnnotatedColumn(value="OpIndex")
        static DBObjectColumn OP_INDEX_COLUMN;
        @DBAnnotatedColumn(value="Ext")
        static DBObjectColumn EXT_COLUMN;
        @DBAnnotatedColumn(value="Flags")
        static DBObjectColumn FLAGS_COLUMN;
        @DBAnnotatedField(column="ToAddrMin", indexed=true, codec=DBTraceOverlaySpaceAdapter.AddressDBFieldCodec.class)
        protected Address toAddrMin = Address.NO_ADDRESS;
        @DBAnnotatedField(column="ToAddrMax", indexed=true, codec=DBTraceOverlaySpaceAdapter.AddressDBFieldCodec.class)
        protected Address toAddrMax = Address.NO_ADDRESS;
        @DBAnnotatedField(column="SymbolId", indexed=true)
        protected long symbolId;
        @DBAnnotatedField(column="RefType", codec=DBTraceUtils.RefTypeDBFieldCodec.class)
        protected RefType refType;
        @DBAnnotatedField(column="OpIndex")
        protected byte opIndex;
        @DBAnnotatedField(column="Ext")
        protected long ext;
        @DBAnnotatedField(column="Flags")
        protected byte flags;
        protected final DBTraceReferenceSpace space;
        protected AddressRange toRange;
        protected DBTraceReference ref;

        public static String tableName(AddressSpace space) {
            return DBTraceUtils.tableName(TABLE_NAME, space);
        }

        public DBTraceReferenceEntry(DBTraceReferenceSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceReferenceEntry, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
            this.space = space;
        }

        @Override
        public DBTraceOverlaySpaceAdapter getOverlaySpaceAdapter() {
            return this.space.manager.overlayAdapter;
        }

        @Override
        protected void fresh(boolean created) throws IOException {
            super.fresh(created);
            if (created) {
                return;
            }
            this.toRange = new AddressRangeImpl(this.toAddrMin, this.toAddrMax);
            TypeEnum type = TypeEnum.values()[this.flags >> 5 & 3];
            this.ref = type.construct(this);
        }

        protected void setRecordValue(DBTraceReferenceEntry value) {
        }

        protected DBTraceReferenceEntry getRecordValue() {
            return this;
        }

        protected void set(AddressRange toRange, long symbolId, RefType refType, int opIndex, long ext, boolean isPrimary, TypeEnum type, SourceType sourceType) {
            this.toAddrMin = toRange.getMinAddress();
            this.toAddrMax = toRange.getMaxAddress();
            this.symbolId = symbolId;
            this.refType = refType;
            this.opIndex = (byte)opIndex;
            this.ext = ext;
            this.flags = (byte)((isPrimary ? 16 : 0) | sourceType.getStorageId() << 0 | type.ordinal() << 5);
            this.update(new DBObjectColumn[]{TO_ADDR_MIN_COLUMN, TO_ADDR_MAX_COLUMN, SYMBOL_ID_COLUMN, REF_TYPE_COLUMN, OP_INDEX_COLUMN, EXT_COLUMN, FLAGS_COLUMN});
            this.toRange = toRange;
        }

        protected void setLifespan(Lifespan lifespan) {
            super.doSetLifespan(lifespan);
            this.space.manager.doSetXRefLifespan(this);
        }

        public void setEndSnap(long endSnap) {
            this.setLifespan(this.lifespan.withMax(endSnap));
        }

        public void setSymbolId(long symbolId) {
            if (this.symbolId == symbolId) {
                return;
            }
            AbstractDBTraceSymbol oldSymbol = this.space.trace.getSymbolManager().getSymbolByID(this.symbolId);
            AbstractDBTraceSymbol newSymbol = this.space.trace.getSymbolManager().getSymbolByID(symbolId);
            this.symbolId = symbolId;
            this.update(SYMBOL_ID_COLUMN);
            if (oldSymbol != null) {
                this.space.trace.setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, DBTraceReference>(TraceEvents.SYMBOL_ASSOCIATION_REMOVED, this.space.space, oldSymbol, this.ref));
            }
            if (newSymbol != null) {
                this.space.trace.setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, DBTraceReference>(TraceEvents.SYMBOL_ASSOCIATION_ADDED, this.space.space, newSymbol, this.ref));
            }
        }

        public long getSymbolId() {
            return this.symbolId;
        }

        public void setRefType(RefType refType) {
            this.refType = refType;
            this.update(REF_TYPE_COLUMN);
        }

        public RefType getRefType() {
            return this.refType;
        }

        public void setPrimary(boolean b) {
            this.flags = b ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
            this.update(FLAGS_COLUMN);
        }

        public boolean isPrimary() {
            return (this.flags & 0x10) != 0;
        }

        public SourceType getSourceType() {
            return SourceType.getSourceType((int)(this.flags >> 0 & 0xF));
        }

        protected void doDelete() {
            try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
                this.space.referenceMapSpace.deleteData(this);
                this.space.manager.doDelXRef(this);
            }
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static class DBTraceXRefEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceXRefEntry> {
        private static final String TABLE_NAME = "XRefs";
        static final String REF_KEY_COLUMN_NAME = "RefKey";
        static final String REF_SPACE_COLUMN_NAME = "Space";
        @DBAnnotatedColumn(value="RefKey")
        static DBObjectColumn REF_KEY_COLUMN;
        @DBAnnotatedColumn(value="Space")
        static DBObjectColumn REF_SPACE_COLUMN;
        @DBAnnotatedField(column="Space")
        protected short refSpaceId;
        @DBAnnotatedField(column="RefKey", indexed=true)
        protected long refKey;
        protected final DBTraceReferenceSpace space;

        public static String tableName(AddressSpace space) {
            return DBTraceUtils.tableName(TABLE_NAME, space);
        }

        public DBTraceXRefEntry(DBTraceReferenceSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceXRefEntry, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
            this.space = space;
        }

        protected void setRecordValue(DBTraceXRefEntry value) {
        }

        protected DBTraceXRefEntry getRecordValue() {
            return this;
        }

        void set(short refSpaceId, long refKey) {
            this.refSpaceId = refSpaceId;
            this.refKey = refKey;
            this.update(REF_SPACE_COLUMN, REF_KEY_COLUMN);
        }

        protected void setLifespan(Lifespan lifespan) {
            super.doSetLifespan(lifespan);
        }
    }

    protected static enum TypeEnum {
        MEMORY{

            @Override
            protected DBTraceReference construct(DBTraceReferenceEntry ent) {
                if (ent.toAddrMin.isStackAddress()) {
                    return new DBTraceStackReference(ent);
                }
                return new DBTraceReference(ent);
            }
        }
        ,
        OFFSET{

            @Override
            protected DBTraceReference construct(DBTraceReferenceEntry ent) {
                return new DBTraceOffsetReference(ent, false);
            }
        }
        ,
        SHIFT{

            @Override
            protected DBTraceReference construct(DBTraceReferenceEntry ent) {
                return new DBTraceShiftedReference(ent);
            }
        }
        ,
        OFFSET_EXTERNAL{

            @Override
            protected DBTraceReference construct(DBTraceReferenceEntry ent) {
                return new DBTraceOffsetReference(ent, true);
            }
        };


        protected abstract DBTraceReference construct(DBTraceReferenceEntry var1);
    }
}

