/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote;

import ghidra.framework.store.FileSystem;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class RepositoryItem
implements Serializable {
    public static final long serialVersionUID = 2L;
    private static final byte SERIALIZATION_SCHEMA_VERSION = 1;
    public static final int FILE = 1;
    public static final int DATABASE = 2;
    public static final int TEXT_DATA_FILE = 3;
    private String folderPath;
    private String itemName;
    private String fileID;
    private int itemType;
    private String contentType;
    private int version;
    private long versionTime;
    private String textData;

    protected RepositoryItem() {
    }

    public RepositoryItem(String folderPath, String itemName, String fileID, int itemType, String contentType, int version, long versionTime, String textData) {
        this.folderPath = folderPath;
        this.itemName = itemName;
        this.fileID = fileID;
        this.itemType = itemType;
        this.contentType = contentType;
        this.version = version;
        this.versionTime = versionTime;
        this.textData = textData;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(2L);
        out.writeUTF(this.folderPath);
        out.writeUTF(this.itemName);
        out.writeUTF(this.fileID != null ? this.fileID : "");
        out.writeInt(this.itemType);
        out.writeUTF(this.contentType != null ? this.contentType : "");
        out.writeInt(this.version);
        out.writeLong(this.versionTime);
        out.writeByte(1);
        out.writeUTF(this.textData != null ? this.textData : "");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        long serialVersion = in.readLong();
        if (serialVersion != 2L) {
            throw new ClassNotFoundException("Unsupported version of RepositoryItem");
        }
        this.folderPath = in.readUTF();
        this.itemName = in.readUTF();
        this.fileID = in.readUTF();
        if (this.fileID.length() == 0) {
            this.fileID = null;
        }
        this.itemType = in.readInt();
        this.contentType = in.readUTF();
        if (this.contentType.length() == 0) {
            this.contentType = null;
        }
        this.version = in.readInt();
        this.versionTime = in.readLong();
        int available = in.available();
        if (available == 0) {
            return;
        }
        byte serializationSchemaVersion = in.readByte();
        if (serializationSchemaVersion < 1 || serializationSchemaVersion > 1) {
            throw new InvalidClassException("RepositoryItem", "RepositoryItem has incompatible serialization schema version: " + serializationSchemaVersion);
        }
        this.textData = in.readUTF();
        if (StringUtils.isBlank((CharSequence)this.textData)) {
            this.textData = null;
        }
    }

    public String getName() {
        return this.itemName;
    }

    public String getPathName() {
        return this.folderPath + FileSystem.SEPARATOR + this.itemName;
    }

    public String getParentPath() {
        return this.folderPath;
    }

    public int getItemType() {
        return this.itemType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileID() {
        return this.fileID;
    }

    public int getVersion() {
        return this.version;
    }

    public long getVersionTime() {
        return this.versionTime;
    }

    public String getTextData() {
        return this.textData;
    }
}

