/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.DBRecord;
import db.Field;
import db.FieldKeyNode;
import db.FieldKeyRecordNode;
import db.FixedKeyFixedRecNode;
import db.FixedKeyInteriorNode;
import db.FixedKeyNode;
import db.FixedKeyVarRecNode;
import db.NodeMgr;
import db.Schema;
import db.Table;
import db.buffers.DataBuffer;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class FixedKeyRecordNode
extends FixedKeyNode
implements FieldKeyRecordNode {
    private static final int ID_SIZE = 4;
    private static final int PREV_LEAF_ID_OFFSET = 5;
    private static final int NEXT_LEAF_ID_OFFSET = 9;
    static final int RECORD_LEAF_HEADER_SIZE = 13;

    FixedKeyRecordNode(NodeMgr nodeMgr, DataBuffer buf) throws IOException {
        super(nodeMgr, buf);
    }

    FixedKeyRecordNode(NodeMgr nodeMgr, byte nodeType, int prevLeafId, int nextLeafId) throws IOException {
        super(nodeMgr, nodeType);
        this.buffer.putInt(5, prevLeafId);
        this.buffer.putInt(9, nextLeafId);
    }

    void logConsistencyError(String tableName, String msg, Throwable t) {
        Msg.debug((Object)this, (Object)("Consistency Error (" + tableName + "): " + msg));
        Msg.debug((Object)this, (Object)("  bufferID=" + this.getBufferId() + " key[0]=" + BinaryField.getValueAsString(this.getKey(0))));
        if (t != null) {
            Msg.error((Object)this, (Object)("Consistency Error (" + tableName + ")"), (Throwable)t);
        }
    }

    @Override
    public boolean isConsistent(String tableName, TaskMonitor monitor) throws IOException, CancelledException {
        FixedKeyRecordNode node;
        boolean consistent = true;
        Field prevKey = null;
        for (int i = 0; i < this.keyCount; ++i) {
            Field key = this.getKeyField(i);
            if (prevKey != null && key.compareTo(prevKey) <= 0) {
                consistent = false;
                this.logConsistencyError(tableName, "key[" + i + "] <= key[" + (i - 1) + "]", null);
                Msg.debug((Object)this, (Object)("  key[" + i + "].minKey = " + key.getValueAsString()));
                Msg.debug((Object)this, (Object)("  key[" + (i - 1) + "].minKey = " + prevKey.getValueAsString()));
            }
            prevKey = key;
        }
        Field key0 = this.getKeyField(0);
        if ((this.parent == null || this.parent.isLeftmostKey(key0)) && this.getPreviousLeaf() != null) {
            consistent = false;
            this.logConsistencyError(tableName, "previous-leaf should not exist", null);
        }
        if ((node = this.getNextLeaf()) != null) {
            if (this.parent == null || this.parent.isRightmostKey(key0)) {
                consistent = false;
                this.logConsistencyError(tableName, "next-leaf should not exist", null);
            } else {
                FixedKeyRecordNode me = node.getPreviousLeaf();
                if (me != this) {
                    consistent = false;
                    this.logConsistencyError(tableName, "next-leaf is not linked to this leaf", null);
                }
            }
        } else if (this.parent != null && !this.parent.isRightmostKey(key0)) {
            consistent = false;
            this.logConsistencyError(tableName, "this leaf is not linked to next-leaf", null);
        }
        return consistent;
    }

    @Override
    byte[] getKey(int index) {
        byte[] key = new byte[this.keySize];
        this.buffer.get(this.getKeyOffset(index), key);
        return key;
    }

    @Override
    public int compareKeyField(Field k, int keyIndex) {
        return k.compareTo(this.buffer, this.getKeyOffset(keyIndex));
    }

    @Override
    public abstract int getKeyOffset(int var1);

    @Override
    public FixedKeyRecordNode getLeafNode(Field key) throws IOException {
        return this;
    }

    @Override
    public FixedKeyRecordNode getLeftmostLeafNode() throws IOException {
        FixedKeyRecordNode leaf = this.getPreviousLeaf();
        return leaf != null ? leaf.getLeftmostLeafNode() : this;
    }

    @Override
    public FixedKeyRecordNode getRightmostLeafNode() throws IOException {
        FixedKeyRecordNode leaf = this.getNextLeaf();
        return leaf != null ? leaf.getRightmostLeafNode() : this;
    }

    @Override
    public boolean hasNextLeaf() throws IOException {
        int nextLeafId = this.buffer.getInt(9);
        return nextLeafId >= 0;
    }

    @Override
    public FixedKeyRecordNode getNextLeaf() throws IOException {
        FixedKeyRecordNode leaf = null;
        int nextLeafId = this.buffer.getInt(9);
        if (nextLeafId >= 0) {
            leaf = (FixedKeyRecordNode)this.nodeMgr.getFixedKeyNode(nextLeafId);
        }
        return leaf;
    }

    @Override
    public boolean hasPreviousLeaf() throws IOException {
        int prevLeafId = this.buffer.getInt(5);
        return prevLeafId >= 0;
    }

    @Override
    public FixedKeyRecordNode getPreviousLeaf() throws IOException {
        FixedKeyRecordNode leaf = null;
        int prevLeafId = this.buffer.getInt(5);
        if (prevLeafId >= 0) {
            leaf = (FixedKeyRecordNode)this.nodeMgr.getFixedKeyNode(prevLeafId);
        }
        return leaf;
    }

    @Override
    public int getKeyIndex(Field key) {
        int min = 0;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            int rc = this.compareKeyField(key, i);
            if (rc == 0) {
                return i;
            }
            if (rc > 0) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return -(min + 1);
    }

    FixedKeyNode split() throws IOException {
        int oldSiblingId = this.buffer.getInt(9);
        FixedKeyRecordNode newLeaf = this.createNewLeaf(this.buffer.getId(), oldSiblingId);
        DataBuffer newBuf = newLeaf.buffer;
        int newBufId = newBuf.getId();
        this.buffer.putInt(9, newBufId);
        if (oldSiblingId >= 0) {
            FixedKeyRecordNode leaf = (FixedKeyRecordNode)this.nodeMgr.getFixedKeyNode(oldSiblingId);
            leaf.buffer.putInt(5, newBufId);
        }
        this.splitData(newLeaf);
        if (this.parent != null) {
            return this.parent.insert(newBufId, newLeaf.getKeyField(0));
        }
        return new FixedKeyInteriorNode(this.nodeMgr, this.keyType, this.getKey(0), this.buffer.getId(), newLeaf.getKey(0), newBufId);
    }

    FixedKeyNode appendLeaf(FixedKeyRecordNode leaf) throws IOException {
        leaf.buffer.putInt(5, this.buffer.getId());
        int rightLeafBufId = this.buffer.getInt(9);
        leaf.buffer.putInt(9, rightLeafBufId);
        int newBufId = leaf.buffer.getId();
        this.buffer.putInt(9, newBufId);
        if (rightLeafBufId >= 0) {
            FixedKeyNode rightLeaf = this.nodeMgr.getFixedKeyNode(rightLeafBufId);
            rightLeaf.buffer.putInt(5, newBufId);
        }
        if (this.parent != null) {
            return this.parent.insert(newBufId, leaf.getKeyField(0));
        }
        return new FixedKeyInteriorNode(this.nodeMgr, this.keyType, this.getKey(0), this.buffer.getId(), leaf.getKey(0), newBufId);
    }

    @Override
    public FixedKeyNode removeLeaf() throws IOException {
        Field key = this.getKeyField(0);
        int prevBufferId = this.buffer.getInt(5);
        int nextBufferId = this.buffer.getInt(9);
        if (prevBufferId >= 0) {
            FixedKeyRecordNode prevNode = (FixedKeyRecordNode)this.nodeMgr.getFixedKeyNode(prevBufferId);
            prevNode.getBuffer().putInt(9, nextBufferId);
        }
        if (nextBufferId >= 0) {
            FixedKeyRecordNode nextNode = (FixedKeyRecordNode)this.nodeMgr.getFixedKeyNode(nextBufferId);
            nextNode.getBuffer().putInt(5, prevBufferId);
        }
        this.nodeMgr.deleteNode(this);
        if (this.parent == null) {
            return null;
        }
        return this.parent.deleteChild(key);
    }

    abstract void splitData(FixedKeyRecordNode var1);

    abstract FixedKeyRecordNode createNewLeaf(int var1, int var2) throws IOException;

    @Override
    public FixedKeyNode putRecord(DBRecord record, Table table) throws IOException {
        Field key = record.getKeyField();
        int index = this.getKeyIndex(key);
        if (index >= 0) {
            if (table != null) {
                table.updatedRecord(this.getRecord(table.getSchema(), index), record);
            }
            FixedKeyNode newRoot = this.updateRecord(index, record);
            return newRoot;
        }
        if (this.insertRecord(index = -index - 1, record)) {
            if (index == 0 && this.parent != null) {
                this.parent.keyChanged(this.getKeyField(1), key, null);
            }
            if (table != null) {
                table.insertedRecord(record);
            }
            return this.getRoot();
        }
        if (index == this.keyCount) {
            FixedKeyNode newRoot = this.appendNewLeaf(record);
            if (table != null) {
                table.insertedRecord(record);
            }
            return newRoot;
        }
        FixedKeyRecordNode leaf = (FixedKeyRecordNode)this.split().getLeafNode(key);
        return leaf.putRecord(record, table);
    }

    FixedKeyNode appendNewLeaf(DBRecord record) throws IOException {
        FixedKeyRecordNode newLeaf = this.createNewLeaf(-1, -1);
        newLeaf.insertRecord(0, record);
        return this.appendLeaf(newLeaf);
    }

    @Override
    public FieldKeyNode deleteRecord(Field key, Table table) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            return this.getRoot();
        }
        if (table != null) {
            table.deletedRecord(this.getRecord(table.getSchema(), index));
        }
        if (this.keyCount == 1) {
            FixedKeyNode newRoot = this.removeLeaf();
            return newRoot;
        }
        this.remove(index);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(key, this.getKey(0));
        }
        return this.getRoot();
    }

    abstract boolean insertRecord(int var1, DBRecord var2) throws IOException;

    abstract FixedKeyNode updateRecord(int var1, DBRecord var2) throws IOException;

    @Override
    public DBRecord getRecordBefore(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        index = index < 0 ? -index - 2 : --index;
        if (index < 0) {
            FixedKeyRecordNode nextLeaf = this.getPreviousLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, nextLeaf.keyCount - 1) : null;
        }
        return this.getRecord(schema, index);
    }

    @Override
    public DBRecord getRecordAfter(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        index = index < 0 ? -(index + 1) : ++index;
        if (index == this.keyCount) {
            FixedKeyRecordNode nextLeaf = this.getNextLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, 0) : null;
        }
        return this.getRecord(schema, index);
    }

    @Override
    public DBRecord getRecordAtOrBefore(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            FixedKeyRecordNode nextLeaf = this.getPreviousLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, nextLeaf.keyCount - 1) : null;
        }
        return this.getRecord(schema, index);
    }

    @Override
    public DBRecord getRecordAtOrAfter(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            index = -(index + 1);
        }
        if (index == this.keyCount) {
            FixedKeyRecordNode nextLeaf = this.getNextLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, 0) : null;
        }
        return this.getRecord(schema, index);
    }

    static FixedKeyRecordNode createRecordNode(NodeMgr nodeMgr) throws IOException {
        Schema schema = nodeMgr.getTableSchema();
        FixedKeyRecordNode node = null;
        node = schema.isVariableLength() ? new FixedKeyVarRecNode(nodeMgr, -1, -1) : new FixedKeyFixedRecNode(nodeMgr, -1, -1);
        return node;
    }
}

