/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.ClosedException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;
import utilities.util.reflection.ReflectionUtilities;

public class SwingExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public void handle(Throwable t) throws Throwable {
        SwingExceptionHandler.handleUncaughtException(t);
    }

    public static void registerHandler() {
        SystemUtilities.runSwingLater(() -> Thread.setDefaultUncaughtExceptionHandler(new SwingExceptionHandler()));
    }

    public static void handleUncaughtException(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = t.getCause();
        }
        if (SwingExceptionHandler.shouldIgnore(t)) {
            return;
        }
        Object details = "";
        if (t instanceof OutOfMemoryError) {
            Runtime rt = Runtime.getRuntime();
            details = "\nMemory: free=" + rt.freeMemory() + " max=" + rt.maxMemory() + " total=" + rt.totalMemory();
        } else {
            String message = t.getMessage();
            if (message != null) {
                details = "\n" + t.getClass().getSimpleName() + " - " + message;
            }
        }
        Msg.showError(SwingExceptionHandler.class, null, (String)"Error", (Object)("Uncaught Exception! " + (String)details), (Throwable)t);
    }

    private static boolean shouldIgnore(Throwable t) {
        if (t instanceof ThreadDeath) {
            return true;
        }
        if (t instanceof ConnectException) {
            return true;
        }
        if (t instanceof ClosedException) {
            return true;
        }
        return SwingExceptionHandler.isKnownJavaHelpException(t);
    }

    private static boolean isKnownJavaHelpException(Throwable t) {
        String stackString = ReflectionUtilities.stackTraceToString((Throwable)t);
        if (stackString.contains("com.sun.java.help.impl.JHelpPrintHandler$JHFrame.validate")) {
            return true;
        }
        if (stackString.contains("javax.help.plaf.basic.BasicTOCNavigatorUI")) {
            return true;
        }
        if (stackString.contains("javax.swing.text.html.BlockView") && stackString.contains("javax.swing.text.html.HTMLDocument.fireChangedUpdate")) {
            Msg.debug(SwingExceptionHandler.class, (Object)"Squashed an assumed help exception");
            return true;
        }
        return false;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        SwingExceptionHandler.handleUncaughtException(e);
    }
}

