/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import generic.theme.GColor;
import generic.theme.Gui;
import generic.theme.ThemeManager;
import ghidra.framework.options.Option;
import ghidra.framework.options.OptionType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Color;

public class ThemeColorOption
extends Option {
    private String colorId;

    public ThemeColorOption(String optionName, String colorId, String description, HelpLocation help) {
        super(optionName, OptionType.COLOR_TYPE, description, help, null, true, null);
        this.colorId = colorId;
        if (!Gui.hasColor(colorId)) {
            Msg.warn((Object)this, (Object)("Registered a theme color option with a non-defined theme color id of \"" + colorId + "\""));
        }
    }

    @Override
    public Color getCurrentValue() {
        return new GColor(this.colorId);
    }

    @Override
    public Object getDefaultValue() {
        return this.getCurrentValue();
    }

    @Override
    public void doSetCurrentValue(Object value) {
        ThemeManager.getInstance().setColor(this.colorId, (Color)value);
    }

    @Override
    public boolean isDefault() {
        return !ThemeManager.getInstance().isChangedColor(this.colorId);
    }

    @Override
    public void restoreDefault() {
        ThemeManager.getInstance().restoreColor(this.colorId);
    }
}

