/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public class VertexLocationAnimator {
    public static <V, E> void jumpPointToCenter(VisualizationServer<V, E> vv, Point newCenter) {
        Point2D lvc = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(vv.getCenter());
        double dx = lvc.getX() - newCenter.x;
        double dy = lvc.getY() - newCenter.y;
        vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).translate(dx, dy);
    }

    public static <V, E> void scrollPointToCenter(VisualizationServer<V, E> vv, Point newCenter) {
        Point2D lvc = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(vv.getCenter());
        double dx = (lvc.getX() - newCenter.x) / 10.0;
        double dy = (lvc.getY() - newCenter.y) / 10.0;
        Runnable animator = () -> {
            for (int i = 0; i < 10; ++i) {
                vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).translate(dx, dy);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        Thread thread = new Thread(animator);
        thread.start();
    }

    public static <V, E> void scrollVertexToCenter(VisualizationServer<V, E> vv, V vertex) {
        Point newCenter;
        if (vertex != null) {
            LayoutModel<V> layoutModel = vv.getVisualizationModel().getLayoutModel();
            newCenter = (Point)layoutModel.apply(vertex);
        } else {
            Point2D center = vv.getCenter();
            newCenter = Point.of((double)center.getX(), (double)center.getY());
        }
        VertexLocationAnimator.scrollPointToCenter(vv, newCenter);
    }

    private static <V, E> Point getPointToCenter(VisualizationServer<V, E> vv, Collection<V> vertices) {
        LayoutModel<V> layoutModel = vv.getVisualizationModel().getLayoutModel();
        Collection points = vertices.stream().map(layoutModel).collect(Collectors.toList());
        if (points.size() > 0) {
            return Point.centroidOf((Collection)points);
        }
        Point2D center = vv.getCenter();
        return Point.of((double)center.getX(), (double)center.getY());
    }

    public static <V, E> void scrollVertexClusterToCenter(VisualizationServer<V, E> vv, Collection<V> vertices) {
        Point newCenter = VertexLocationAnimator.getPointToCenter(vv, vertices);
        VertexLocationAnimator.scrollPointToCenter(vv, newCenter);
    }
}

