/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntBinOpGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntSCarryOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum IntSCarryOpGen implements IntBinOpGen<JitIntSCarryOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return true;
    }

    static JitType.IntJitType generateMpIntSCarry(JitCodeGenerator gen, JitType.MpIntJitType type, String methodName, MethodVisitor mv) {
        JitAllocationModel am = gen.getAllocationModel();
        int legCount = type.legsAlloc();
        try (JitAllocationModel.JvmTempAlloc tmpL = am.allocateTemp(mv, "tmpL", legCount);
             JitAllocationModel.JvmTempAlloc tmpR = am.allocateTemp(mv, "tmpR", legCount);){
            OpGen.generateMpLegsIntoTemp(tmpR, legCount, mv);
            OpGen.generateMpLegsIntoTemp(tmpL, legCount, mv);
            OpGen.generateMpLegsIntoArray(tmpL, legCount, legCount, mv);
            OpGen.generateMpLegsIntoArray(tmpR, legCount, legCount, mv);
            mv.visitLdcInsn((Object)(type.size() % 4 * 8 - 1));
            mv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, methodName, GenConsts.MDESC_JIT_COMPILED_PASSAGE__S_CARRY_MP_INT, true);
        }
        return JitType.IntJitType.I4;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JitType generateBinOpRunCode(JitCodeGenerator gen, JitIntSCarryOp op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniform(gen, rType, lType, this.ext(), rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                int size;
                JitType.IntJitType intJitType = (JitType.IntJitType)jitType2;
                try {
                    int n2;
                    size = n2 = intJitType.size();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, "sCarryIntRaw", GenConsts.MDESC_JIT_COMPILED_PASSAGE__S_CARRY_INT_RAW, true);
                rv.visitLdcInsn((Object)(size * 8 - 1));
                rv.visitInsn(122);
                rv.visitLdcInsn((Object)1);
                rv.visitInsn(126);
                return JitType.IntJitType.I1;
            }
            case 1: {
                int size;
                JitType.LongJitType longJitType = (JitType.LongJitType)jitType2;
                {
                    int n3;
                    size = n3 = longJitType.size();
                }
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, "sCarryLongRaw", GenConsts.MDESC_JIT_COMPILED_PASSAGE__S_CARRY_LONG_RAW, true);
                rv.visitLdcInsn((Object)(size * 8 - 1));
                rv.visitInsn(123);
                rv.visitInsn(136);
                rv.visitLdcInsn((Object)1);
                rv.visitInsn(126);
                return JitType.IntJitType.I1;
            }
            case 2: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                return IntSCarryOpGen.generateMpIntSCarry(gen, t, "sCarryMpInt", rv);
            }
        }
        throw new AssertionError();
    }
}

