/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.client.PostgresFunctionDatabase;
import ghidra.features.bsim.query.elastic.ElasticDatabase;
import ghidra.features.bsim.query.file.H2FileFunctionDatabase;
import ghidra.framework.protocol.ghidra.GhidraURL;
import java.net.MalformedURLException;
import java.net.URL;

public class BSimClientFactory {
    public static URL buildURL(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        BSimClientFactory.checkBSimServerURL(url);
        return url;
    }

    public static void checkBSimServerURL(URL url) throws MalformedURLException {
        String protocol = url.getProtocol();
        if (!(protocol.equals("postgresql") || protocol.equals("https") || protocol.equals("elastic") || protocol.equals("file"))) {
            throw new MalformedURLException("Protocol not permissable for BSim URL");
        }
        String path = url.getPath();
        if (path == null || path.length() == 0 || path.equals("/")) {
            throw new MalformedURLException("BSim URL missing DB name/path");
        }
        if (!"file".equals(protocol) && path.indexOf(47, 1) >= 0) {
            throw new MalformedURLException("BSim URL must specify exactly 1 path element");
        }
    }

    public static URL deriveBSimURL(String urlString) throws IllegalArgumentException, MalformedURLException {
        URL url = new URL(urlString);
        String protocol = url.getProtocol();
        if ("postgresql".equals(protocol) || "https".equals(protocol) || "elastic".equals(protocol) || "file".equals(protocol)) {
            BSimClientFactory.checkBSimServerURL(url);
            return url;
        }
        if (!GhidraURL.isServerRepositoryURL((URL)url)) {
            throw new IllegalArgumentException("Unable to infer BSim URL from: " + String.valueOf(url));
        }
        String path = url.getPath();
        if (path == null || path.length() == 0 || path.equals("/")) {
            throw new MalformedURLException("URL is missing a repository path");
        }
        int endrepos = path.indexOf(47, 1);
        String repositoryURL = url.getProtocol().equals("ghidra") ? "postgresql://" + url.getHost() : url.getProtocol() + "://" + url.getAuthority();
        repositoryURL = endrepos < 0 ? repositoryURL + path : repositoryURL + path.substring(0, endrepos);
        return BSimClientFactory.buildURL(repositoryURL);
    }

    public static FunctionDatabase buildClient(BSimServerInfo bsimServerInfo, boolean async) {
        try {
            return BSimClientFactory.buildClient(bsimServerInfo.toURL(), async);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static FunctionDatabase buildClient(URL bsimURL, boolean async) throws MalformedURLException {
        String protocol = bsimURL.getProtocol();
        if (protocol.equals("postgresql")) {
            return new PostgresFunctionDatabase(bsimURL, async);
        }
        if (protocol.equals("https") || protocol.equals("elastic")) {
            return new ElasticDatabase(bsimURL);
        }
        if ("file".equals(protocol)) {
            return new H2FileFunctionDatabase(bsimURL);
        }
        throw new MalformedURLException("Unsupported protocol: " + protocol);
    }
}

