/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.register;

import ghidra.program.model.address.Address;

class AddressValueRange<T>
implements Comparable<AddressValueRange<T>> {
    private Address start;
    private Address end;
    private T value;

    public AddressValueRange(Address start, Address end, T value) {
        this.start = start;
        this.end = end;
        this.value = value;
    }

    public Address getStart() {
        return this.start;
    }

    public Address getEnd() {
        return this.end;
    }

    public T getValue() {
        return this.value;
    }

    public boolean contains(Address address) {
        return address.compareTo(this.start) >= 0 && address.compareTo(this.end) <= 0;
    }

    @Override
    public int compareTo(AddressValueRange<T> otherRange) {
        return this.start.compareTo(otherRange.start);
    }

    public String toString() {
        return String.valueOf(this.start) + ":" + String.valueOf(this.end) + "[" + String.valueOf(this.value) + "]";
    }
}

