/*
 * Decompiled with CFR 0.152.
 */
package sarif.model;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Map;
import sarif.model.SarifColumnKey;
import sarif.model.SarifDataFrame;

public class SarifResultsTableModelFactory {
    private List<SarifColumnKey> sColumns;

    public SarifResultsTableModelFactory(List<SarifColumnKey> cols) {
        this.sColumns = cols;
    }

    public SarifResultsTableModel createModel(String description, PluginTool tool, Program program, SarifDataFrame df) {
        return new SarifResultsTableModel(description, tool, program, df);
    }

    public class SarifResultsTableModel
    extends AddressBasedTableModel<Map<String, Object>> {
        private SarifDataFrame df;

        public SarifResultsTableModel(String description, PluginTool tool, Program program, SarifDataFrame df) {
            super(description, (ServiceProvider)tool, program, null);
            this.df = df;
        }

        public SarifDataFrame getDataFrame() {
            return this.df;
        }

        public Address getAddress(int row) {
            return (Address)((Map)this.getRowObject(row)).get("Address");
        }

        protected void doLoad(Accumulator<Map<String, Object>> accumulator, TaskMonitor monitor) throws CancelledException {
            for (Map<String, Object> result : this.df.getTableResults()) {
                accumulator.add(result);
            }
        }

        protected TableColumnDescriptor<Map<String, Object>> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            for (SarifColumnKey column : SarifResultsTableModelFactory.this.sColumns) {
                if (column.getName().equals("Address")) {
                    descriptor.addVisibleColumn(new Column<Address>(this, column.getName(), Address.class));
                    continue;
                }
                if (column.isHidden()) {
                    descriptor.addHiddenColumn(new Column<String>(this, column.getName(), String.class));
                    continue;
                }
                descriptor.addVisibleColumn(new Column<String>(this, column.getName(), String.class));
            }
            return descriptor;
        }

        public class Column<T>
        extends AbstractDynamicTableColumn<Map<String, Object>, T, Object> {
            private String name;
            private Class<T> type;

            public Column(SarifResultsTableModel this$1, String name, Class<T> type) {
                this.name = name;
                this.type = type;
            }

            public String getColumnName() {
                return this.name;
            }

            public Class<T> getColumnClass() {
                return this.type;
            }

            public T getValue(Map<String, Object> rowObject, Settings settings, Object data, ServiceProvider serviceProvider) throws IllegalArgumentException {
                Object object = rowObject.get(this.name);
                return (T)object;
            }
        }
    }
}

