/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import docking.wizard.WizardDialog;
import docking.wizard.WizardModel;
import generic.theme.GIcon;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.wizard.session.VTNewSessionWizardModel;
import ghidra.util.HelpLocation;
import java.awt.Component;
import javax.swing.Icon;

public class CreateVersionTrackingSessionAction
extends DockingAction {
    public static Icon NEW_ICON = new GIcon("icon.version.tracking.action.create.session");
    private final VTController controller;

    public CreateVersionTrackingSessionAction(VTController controller) {
        super("Create New Session", VTPlugin.OWNER);
        this.controller = controller;
        String[] menuPath = new String[]{"&File", "New Session..."};
        this.setMenuBarData(new MenuData(menuPath, NEW_ICON, "AAA"));
        this.setToolBarData(new ToolBarData(NEW_ICON, "View"));
        this.setDescription("Creates a new Version Tracking Session");
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Create_Session"));
    }

    public void actionPerformed(ActionContext context) {
        int result;
        if (this.controller.getSession() != null && (result = OptionDialog.showYesNoDialog((Component)this.controller.getTool().getToolFrame(), (String)"Create New Session", (String)"This will close the current session.  Do you want to continue?")) != 1) {
            return;
        }
        if (!this.controller.closeVersionTrackingSession()) {
            return;
        }
        VTNewSessionWizardModel model = new VTNewSessionWizardModel(this.controller);
        WizardDialog wizardDialog = new WizardDialog((WizardModel)model);
        wizardDialog.show(this.controller.getParentComponent());
    }
}

