/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchTableProvider;
import java.util.ArrayList;
import java.util.List;

public class VTMatchContext
extends DefaultActionContext {
    private final List<VTMatch> selectedMatches;
    private final VTSession session;

    public VTMatchContext(VTMatchTableProvider provider, List<VTMatch> selectedMatches, VTSession session) {
        super((ComponentProvider)provider, null);
        this.selectedMatches = selectedMatches;
        this.session = session;
    }

    public List<VTMatch> getSelectedMatches() {
        return this.selectedMatches;
    }

    public int getSelectedRowCount() {
        return this.selectedMatches.size();
    }

    public VTSession getSession() {
        return this.session;
    }

    public List<VTMatch> getFunctionMatches() {
        ArrayList<VTMatch> functionMatches = new ArrayList<VTMatch>();
        for (VTMatch match : this.selectedMatches) {
            VTAssociation association = match.getAssociation();
            if (association.getType() != VTAssociationType.FUNCTION) continue;
            functionMatches.add(match);
        }
        return functionMatches;
    }
}

