/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import ghidra.app.plugin.core.checksums.ComputeChecksumsProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.NumericUtilities;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ChecksumAlgorithm
implements ExtensionPoint {
    protected String name;
    protected byte[] checksum;

    public ChecksumAlgorithm(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public abstract void updateChecksum(Memory var1, AddressSetView var2, TaskMonitor var3, ComputeChecksumsProvider var4) throws MemoryAccessException, CancelledException;

    public final void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        this.updateChecksum(memory, addrSet, monitor, null);
    }

    public boolean supportsDecimal() {
        return false;
    }

    public static byte[] toArray(long l, int numBytes) {
        ByteBuffer buffy = ByteBuffer.allocate(8);
        buffy.putLong(l);
        byte[] checksumArray = new byte[numBytes];
        int n = Math.min(8, numBytes);
        System.arraycopy(buffy.array(), 8 - n, checksumArray, numBytes - n, n);
        ArrayUtils.reverse((byte[])checksumArray);
        return checksumArray;
    }

    public static String format(byte[] checksum, boolean hex) {
        if (checksum == null || checksum.length == 0) {
            return "";
        }
        if (!hex && checksum.length <= 8) {
            ByteBuffer buffy = ByteBuffer.allocate(8);
            buffy.put(new byte[8 - checksum.length]);
            buffy.put(checksum);
            buffy.rewind();
            return Long.toUnsignedString(buffy.getLong());
        }
        return NumericUtilities.convertBytesToString((byte[])checksum);
    }

    public void reset() {
        this.checksum = new byte[0];
    }
}

