/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.action.DockingAction;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public abstract class CompositeEditorTableAction
extends DockingAction {
    static final String MAIN_ACTION_GROUP = "0_MAIN_EDITOR_ACTION";
    static final String UNDOREDO_ACTION_GROUP = "1_UNDOREDO_EDITOR_ACTION";
    static final String BASIC_ACTION_GROUP = "2_BASIC_EDITOR_ACTION";
    static final String DATA_ACTION_GROUP = "3_DATA_EDITOR_ACTION";
    static final String COMPONENT_ACTION_GROUP = "4_COMPONENT_EDITOR_ACTION";
    static final String BITFIELD_ACTION_GROUP = "5_COMPONENT_EDITOR_ACTION";
    protected CompositeEditorProvider<?, ?> provider;
    protected CompositeEditorModel<?> model;
    protected String tooltip;
    protected ImageIcon icon;
    protected ActionListener listener;
    protected String displayString;
    protected String actionCommand;
    protected JButton button;
    protected KeyStroke keystroke;
    protected Plugin plugin;
    protected PluginTool tool;

    protected CompositeEditorTableAction(CompositeEditorProvider<?, ?> provider, String name) {
        super(name, provider.plugin.getName());
        this.init(provider);
    }

    public CompositeEditorTableAction(CompositeEditorProvider<?, ?> provider, String name, String group, String[] popupPath, String[] menuPath, Icon icon) {
        super(name, provider.plugin.getName(), KeyBindingType.SHARED);
        this.init(provider);
        if (menuPath != null) {
            this.setMenuBarData(new MenuData(menuPath, icon, group));
        }
        if (popupPath != null) {
            this.setPopupMenuData(new MenuData(popupPath, icon, group));
        }
        if (icon != null) {
            this.setToolBarData(new ToolBarData(icon, group));
        }
    }

    private void init(CompositeEditorProvider<?, ?> editorProvider) {
        this.provider = editorProvider;
        this.model = this.provider.getModel();
        this.plugin = this.provider.plugin;
        this.tool = this.plugin.getTool();
        String helpAnchor = this.provider.getHelpName() + "_" + this.getHelpName();
        this.setHelpLocation(new HelpLocation(this.provider.getHelpTopic(), helpAnchor));
    }

    public void dispose() {
        super.dispose();
        this.provider = null;
        this.model = null;
        this.plugin = null;
        this.tool = null;
    }

    protected boolean hasIncompleteFieldEntry() {
        return this.provider.editorPanel.hasInvalidEntry() || this.provider.editorPanel.hasUncomittedEntry();
    }

    protected void requestTableFocus() {
        if (this.provider != null) {
            this.provider.requestTableFocus();
        }
    }

    public String getHelpName() {
        return this.getName();
    }
}

