/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.expression;

import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFRegisterMappings;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpression;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionInstruction;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOpCode;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionTerminalDerefException;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionUnsupportedOpException;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionValueException;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DWARFExpressionEvaluator {
    private static final int DEFAULT_MAX_STEP_COUNT = 1000;
    private final DWARFProgram dprog;
    private final DWARFCompilationUnit cu;
    private final Language lang;
    private ValueReader valReader = ValueReader.DUMMY;
    private int maxStepCount = 1000;
    private DWARFRegisterMappings registerMappings;
    private Varnode frameBaseVal;
    private List<Object> stack = new ArrayList<Object>();
    private DWARFExpression expr;
    private DWARFExpressionInstruction instr;
    private int instrIndex = -1;
    private int stepCount = 0;

    public DWARFExpressionEvaluator(DWARFCompilationUnit cu) {
        this.cu = cu;
        this.dprog = cu.getProgram();
        this.registerMappings = Objects.requireNonNullElse(this.dprog.getRegisterMappings(), DWARFRegisterMappings.DUMMY);
        this.lang = this.dprog.getGhidraProgram().getLanguage();
    }

    public DWARFCompilationUnit getDWARFCompilationUnit() {
        return this.cu;
    }

    public DWARFExpression getExpr() {
        return this.expr;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int getPtrSize() {
        return this.cu.getPointerSize();
    }

    public void setFrameBaseStackLocation(int offset) {
        this.frameBaseVal = this.newStackVarnode(offset, 0);
    }

    public void setFrameBaseVal(Varnode frameBaseVal) {
        this.frameBaseVal = frameBaseVal;
    }

    public void setValReader(ValueReader valReader) {
        this.valReader = valReader;
    }

    public ValueReader withStaticStackRegisterValues(final Integer stackOffset, final Integer stackFrameOffset) {
        return new ValueReader(){

            public Varnode getValue(Varnode vn) throws DWARFExpressionValueException {
                Register reg;
                if (vn.isRegister() && (reg = DWARFExpressionEvaluator.this.lang.getRegister(vn.getAddress(), 0)) != null) {
                    if (reg == DWARFExpressionEvaluator.this.registerMappings.getStackFrameRegister() && stackFrameOffset != null) {
                        return DWARFExpressionEvaluator.this.newStackVarnode(stackFrameOffset.intValue(), 0);
                    }
                    if (reg == DWARFExpressionEvaluator.this.registerMappings.getStackRegister() && stackOffset != null) {
                        return DWARFExpressionEvaluator.this.newStackVarnode(stackOffset.intValue(), 0);
                    }
                }
                throw new DWARFExpressionValueException(vn);
            }
        };
    }

    public int getMaxStepCount() {
        return this.maxStepCount;
    }

    public void setMaxStepCount(int maxStepCount) {
        this.maxStepCount = maxStepCount;
    }

    public void push(Address addr) {
        this.push(new Varnode(addr, 0));
    }

    public void push(Register reg) {
        this.push(new Varnode(reg.getAddress(), reg.getMinimumByteSize()));
    }

    public void push(boolean b) {
        this.push(b ? 1L : 0L);
    }

    public void push(long l) {
        this.push(new Scalar(this.getPtrSize() * 8, l));
    }

    public void push(Object val) {
        this.stack.addLast(val);
    }

    public Object peek() throws DWARFExpressionException {
        if (this.stack.isEmpty()) {
            throw new DWARFExpressionException("DWARF expression stack empty");
        }
        return this.stack.getLast();
    }

    public Object pop() throws DWARFExpressionException {
        if (this.stack.isEmpty()) {
            throw new DWARFExpressionException("DWARF expression stack empty");
        }
        return this.stack.removeLast();
    }

    public Scalar popScalar() throws DWARFExpressionException {
        return this.stackValueToScalar(this.pop());
    }

    private Scalar stackValueToScalar(Object val) throws DWARFExpressionException {
        Object object = val;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Scalar.class, Varnode.class}, (Object)object2, n)) {
            case 0: {
                Scalar s = (Scalar)object2;
                return s;
            }
            case 1: {
                Varnode varnode = (Varnode)object2;
                if (varnode.isRegister()) {
                    return this.stackValueToScalar(this.valReader.getValue(varnode));
                }
                if (!DWARFUtil.isConstVarnode(varnode)) break;
                return new Scalar(varnode.getSize() * 8, varnode.getOffset());
            }
        }
        throw new DWARFExpressionException("Unable to convert stack value to scalar: %s".formatted(val));
    }

    public Varnode popVarnode() throws DWARFExpressionException {
        Varnode varnode;
        Object tmp;
        Object object = tmp = this.pop();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Scalar.class, Varnode.class}, (Object)object2, n)) {
                case 0: {
                    Scalar s = (Scalar)object2;
                    if (s.bitLength() != this.cu.getPointerSize() * 8) {
                        n = 1;
                        continue block4;
                    }
                    varnode = this.newAddrVarnode(s.getUnsignedValue());
                    break block4;
                }
                case 1: {
                    Varnode varnode2;
                    varnode = varnode2 = (Varnode)object2;
                    break block4;
                }
                default: {
                    throw new DWARFExpressionException("Unable to convert DWARF expression stack value %s to address".formatted(tmp));
                }
            }
            break;
        }
        return varnode;
    }

    public long popLong() throws DWARFExpressionException {
        Scalar s = this.popScalar();
        return s.getValue();
    }

    public void evaluate(byte[] exprBytes) throws DWARFExpressionException {
        this.evaluate(DWARFExpression.read(exprBytes, this.cu));
    }

    public void evaluate(byte[] exprBytes, long ... stackArgs) throws DWARFExpressionException {
        this.evaluate(DWARFExpression.read(exprBytes, this.cu), stackArgs);
    }

    public void setExpression(DWARFExpression expr) {
        this.expr = expr;
        this.instr = null;
        this.instrIndex = 0;
        this.stepCount = 0;
    }

    public boolean hasNext() {
        return this.instrIndex < this.expr.getInstructionCount();
    }

    public boolean step() throws DWARFExpressionException {
        if (this.hasNext()) {
            try {
                this.evaluateInstruction(this.expr.getInstruction(this.instrIndex));
                ++this.instrIndex;
                ++this.stepCount;
            }
            catch (DWARFExpressionException dee) {
                if (dee.getExpression() == null) {
                    dee.setExpression(this.expr);
                    dee.setInstructionIndex(this.instrIndex);
                }
                throw dee;
            }
        }
        return this.hasNext();
    }

    public void evaluate(DWARFExpression expr, long ... stackArgs) throws DWARFExpressionException {
        for (long l : stackArgs) {
            this.push(l);
        }
        this.evaluate(expr);
    }

    public void evaluate(DWARFExpression expr) throws DWARFExpressionException {
        this.setExpression(expr);
        while (this.hasNext()) {
            if (this.stepCount >= this.maxStepCount) {
                throw new DWARFExpressionException("Excessive expression run length, terminating after %d operations".formatted(this.stepCount));
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new DWARFExpressionException("Thread interrupted while evaluating DWARF expression, terminating after %d operations".formatted(this.stepCount));
            }
            this.step();
        }
    }

    private Register getReg(int dwarfRegNum) throws DWARFExpressionException {
        Register reg = this.registerMappings.getGhidraReg(dwarfRegNum);
        if (reg == null) {
            throw new DWARFExpressionException("Unknown/unmapped DWARF register: %d".formatted(dwarfRegNum));
        }
        return reg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void evaluateInstruction(DWARFExpressionInstruction _instr) throws DWARFExpressionException {
        this.instr = _instr;
        if (DWARFExpressionOpCode.isInRange(this.instr.opcode, DWARFExpressionOpCode.DW_OP_lit0, DWARFExpressionOpCode.DW_OP_lit31)) {
            this.push(this.instr.opcode.getRelativeOpCodeOffset(DWARFExpressionOpCode.DW_OP_lit0));
            return;
        } else if (DWARFExpressionOpCode.isInRange(this.instr.opcode, DWARFExpressionOpCode.DW_OP_breg0, DWARFExpressionOpCode.DW_OP_breg31)) {
            Varnode regVN;
            Register register = this.getReg(this.instr.opcode.getRelativeOpCodeOffset(DWARFExpressionOpCode.DW_OP_breg0));
            long offset = this.instr.getOperandValue(0);
            Object regVal = this.valReader.getValue(this.newRegisterVarnode(register));
            if (regVal instanceof Varnode && (DWARFUtil.isStackVarnode(regVN = (Varnode)regVal) || regVN.isConstant())) {
                this.push(new Varnode(regVN.getAddress().add(offset), 0));
                return;
            } else {
                if (!(regVal instanceof Scalar)) throw new DWARFExpressionException("Unable to deref register value " + String.valueOf(regVal));
                Scalar s = (Scalar)regVal;
                this.push(s.getValue() + offset);
            }
            return;
        } else if (DWARFExpressionOpCode.isInRange(this.instr.opcode, DWARFExpressionOpCode.DW_OP_reg0, DWARFExpressionOpCode.DW_OP_reg31)) {
            Register register = this.getReg(this.instr.opcode.getRelativeOpCodeOffset(DWARFExpressionOpCode.DW_OP_reg0));
            Object regVal = this.valReader.getValue(this.newRegisterVarnode(register));
            this.push(regVal);
            return;
        } else {
            switch (this.instr.opcode) {
                case DW_OP_addr: {
                    this.push(this.dprog.getDataAddress(this.instr.getOperandValue(0)));
                    return;
                }
                case DW_OP_const1u: 
                case DW_OP_const2u: 
                case DW_OP_const4u: 
                case DW_OP_const8u: 
                case DW_OP_const1s: 
                case DW_OP_const2s: 
                case DW_OP_const4s: 
                case DW_OP_const8s: 
                case DW_OP_constu: 
                case DW_OP_consts: {
                    this.push(this.instr.getOperandValue(0));
                    return;
                }
                case DW_OP_regx: {
                    Register register = this.getReg((int)this.instr.getOperandValue(0));
                    this.push(register);
                    return;
                }
                case DW_OP_fbreg: {
                    if (this.frameBaseVal == null) {
                        throw new DWARFExpressionException("Frame base has not been set, DW_OP_fbreg can not be evaluated");
                    }
                    long fbOffset = this.instr.getOperandValue(0);
                    this.push(new Varnode(this.frameBaseVal.getAddress().add(fbOffset), 0));
                }
                case DW_OP_dup: {
                    this.push(this.peek());
                    return;
                }
                case DW_OP_drop: {
                    this.pop();
                    return;
                }
                case DW_OP_pick: {
                    int index = (int)this.instr.getOperandValue(0);
                    if (index >= this.stack.size()) {
                        throw new DWARFExpressionException("Invalid index for DW_OP_pick: " + index);
                    }
                    Object elem = this.stack.get(this.stack.size() - index - 1);
                    this.push(elem);
                    return;
                }
                case DW_OP_over: {
                    if (this.stack.size() < 2) {
                        throw new DWARFExpressionException("Not enough items on stack[size=%d] for DW_OP_over".formatted(this.stack.size()));
                    }
                    this.push(this.stack.get(this.stack.size() - 2));
                    return;
                }
                case DW_OP_swap: {
                    Object firstValue = this.pop();
                    Object secondValue = this.pop();
                    this.push(firstValue);
                    this.push(secondValue);
                    return;
                }
                case DW_OP_rot: {
                    Object firstValue = this.pop();
                    Object secondValue = this.pop();
                    Object thirdValue = this.pop();
                    this.push(firstValue);
                    this.push(thirdValue);
                    this.push(secondValue);
                    return;
                }
                case DW_OP_deref: {
                    if (this.instrIndex != this.expr.getInstructionCount() - 1) throw new DWARFExpressionUnsupportedOpException(this.instr);
                    Varnode location = this.popVarnode();
                    throw new DWARFExpressionTerminalDerefException(this.instr, location);
                }
                case DW_OP_call_frame_cfa: {
                    if (!this.registerMappings.hasStaticCFA()) {
                        throw new DWARFExpressionException("CFA not specified in DWARF register mappings for this arch");
                    }
                    this.push(this.newStackVarnode(this.registerMappings.getCallFrameCFA(), 0));
                    return;
                }
                case DW_OP_abs: {
                    Scalar val = this.popScalar();
                    Scalar absVal = new Scalar(val.bitLength(), Math.abs(val.getSignedValue()));
                    this.push(absVal);
                    return;
                }
                case DW_OP_and: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    long tmp = firstValue.getUnsignedValue() & secondValue.getUnsignedValue();
                    int bitCount = Math.max(firstValue.bitLength(), secondValue.bitLength());
                    this.push(new Scalar(bitCount, tmp));
                    return;
                }
                case DW_OP_div: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    if (firstValue.getValue() == 0L) {
                        throw new DWARFExpressionException("Divide by zero");
                    }
                    long tmp = secondValue.getValue() / firstValue.getValue();
                    this.push(new Scalar(secondValue.bitLength(), tmp));
                    return;
                }
                case DW_OP_minus: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    long tmp = secondValue.getValue() - firstValue.getValue();
                    int bitCount = Math.max(firstValue.bitLength(), secondValue.bitLength());
                    this.push(new Scalar(bitCount, tmp));
                    return;
                }
                case DW_OP_mod: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    if (firstValue.getValue() == 0L) {
                        throw new DWARFExpressionException("Divide by zero");
                    }
                    long tmp = secondValue.getValue() % firstValue.getValue();
                    this.push(new Scalar(secondValue.bitLength(), tmp));
                    return;
                }
                case DW_OP_mul: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    long tmp = secondValue.getValue() * firstValue.getValue();
                    int bitCount = Math.max(firstValue.bitLength(), secondValue.bitLength());
                    this.push(new Scalar(bitCount, tmp));
                    return;
                }
                case DW_OP_neg: {
                    Scalar firstValue = this.popScalar();
                    long tmp = -firstValue.getSignedValue();
                    this.push(new Scalar(firstValue.bitLength(), tmp));
                    return;
                }
                case DW_OP_not: {
                    Scalar firstValue = this.popScalar();
                    long tmp = firstValue.getValue() ^ 0xFFFFFFFFFFFFFFFFL;
                    this.push(new Scalar(firstValue.bitLength(), tmp));
                    return;
                }
                case DW_OP_or: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    long tmp = secondValue.getValue() | firstValue.getValue();
                    int bitCount = Math.max(firstValue.bitLength(), secondValue.bitLength());
                    this.push(new Scalar(bitCount, tmp));
                    return;
                }
                case DW_OP_plus: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    long tmp = secondValue.getValue() + firstValue.getValue();
                    int bitCount = Math.max(firstValue.bitLength(), secondValue.bitLength());
                    this.push(new Scalar(bitCount, tmp));
                    return;
                }
                case DW_OP_plus_uconst: {
                    Scalar firstValue = this.popScalar();
                    long opValue = this.instr.getOperandValue(0);
                    long tmp = firstValue.getValue() + opValue;
                    this.push(new Scalar(firstValue.bitLength(), tmp));
                    return;
                }
                case DW_OP_shl: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    long tmp = secondValue.getValue() << (int)firstValue.getValue();
                    this.push(new Scalar(secondValue.bitLength(), tmp));
                    return;
                }
                case DW_OP_shr: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    long tmp = secondValue.getValue() >>> (int)firstValue.getValue();
                    this.push(new Scalar(secondValue.bitLength(), tmp));
                    return;
                }
                case DW_OP_shra: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    long tmp = secondValue.getValue() >> (int)firstValue.getValue();
                    this.push(new Scalar(secondValue.bitLength(), tmp));
                    return;
                }
                case DW_OP_xor: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    long tmp = secondValue.getValue() ^ firstValue.getValue();
                    int bitCount = Math.max(firstValue.bitLength(), secondValue.bitLength());
                    this.push(new Scalar(bitCount, tmp));
                    return;
                }
                case DW_OP_le: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    this.push(secondValue.getSignedValue() <= firstValue.getSignedValue());
                    return;
                }
                case DW_OP_ge: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    this.push(secondValue.getSignedValue() >= firstValue.getSignedValue());
                    return;
                }
                case DW_OP_eq: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    this.push(secondValue.getValue() == firstValue.getValue());
                    return;
                }
                case DW_OP_lt: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    this.push(secondValue.getSignedValue() < firstValue.getSignedValue());
                    return;
                }
                case DW_OP_gt: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    this.push(secondValue.getSignedValue() > firstValue.getSignedValue());
                    return;
                }
                case DW_OP_ne: {
                    Scalar firstValue = this.popScalar();
                    Scalar secondValue = this.popScalar();
                    this.push(secondValue.getSignedValue() != firstValue.getSignedValue());
                    return;
                }
                case DW_OP_skip: {
                    long destOffset = this.instr.getOperandValue(0) + (long)this.instr.getOffset();
                    int newInstrIndex = this.expr.findInstructionByOffset(destOffset);
                    if (newInstrIndex == -1) {
                        throw new DWARFExpressionException("Invalid skip offset " + destOffset);
                    }
                    this.instrIndex = newInstrIndex - 1;
                    return;
                }
                case DW_OP_bra: {
                    long destOffset = this.instr.getOperandValue(0) + (long)this.instr.getOffset();
                    Scalar firstValue = this.popScalar();
                    if (firstValue.getValue() == 0L) return;
                    int newInstrIndex = this.expr.findInstructionByOffset(destOffset);
                    if (newInstrIndex == -1) {
                        throw new DWARFExpressionException("Invalid bra offset " + destOffset);
                    }
                    this.instrIndex = newInstrIndex - 1;
                    return;
                }
                case DW_OP_nop: {
                    return;
                }
                case DW_OP_stack_value: {
                    throw new DWARFExpressionUnsupportedOpException(this.instr);
                }
                case DW_OP_addrx: {
                    try {
                        long addr = this.dprog.getAddress(DWARFForm.DW_FORM_addrx, this.instr.getOperandValue(0), this.cu);
                        this.push(addr);
                        return;
                    }
                    catch (IOException e) {
                        throw new DWARFExpressionException("Invalid indirect address index: " + this.instr.getOperandValue(0));
                    }
                }
                case DW_OP_constx: {
                    try {
                        long addr = this.dprog.getAddress(DWARFForm.DW_FORM_addrx, this.instr.getOperandValue(0), this.cu);
                        this.push(addr);
                        return;
                    }
                    catch (IOException e) {
                        throw new DWARFExpressionException("Invalid indirect address index: " + this.instr.getOperandValue(0));
                    }
                }
                default: {
                    throw new DWARFExpressionUnsupportedOpException(this.instr);
                }
            }
        }
    }

    private Varnode newStackVarnode(long offset, int size) {
        return new Varnode(this.dprog.getStackSpace().getAddress(offset), size);
    }

    private Varnode newRegisterVarnode(Register reg) {
        return new Varnode(reg.getAddress(), reg.getMinimumByteSize());
    }

    private Varnode newAddrVarnode(long l) {
        return new Varnode(this.dprog.getDataAddress(l), (int)this.cu.getPointerSize());
    }

    public String toString() {
        return "DWARFExpressionEvaluator\n  frameBaseVal = %s\n  stepCount = %d\n  status: %s\n\nStack:\n%s\nInstructions:\n%s\n".formatted(this.frameBaseVal != null ? this.frameBaseVal.toString() : "not set", this.stepCount, this.getStatusString(), this.getStackAsString().indent(2), this.expr != null ? this.expr.toString(this.instrIndex, true, true, this.dprog.getRegisterMappings()).indent(2) : "  no expr");
    }

    private String getStackAsString() {
        StringBuilder sb = new StringBuilder();
        int stackindex = 0;
        for (Object stackVal : this.stack.reversed()) {
            sb.append("%3d: %s\n".formatted(stackindex, stackVal));
            ++stackindex;
        }
        return sb.toString();
    }

    private String getStatusString() {
        if (this.instrIndex == -1) {
            return "Not started";
        }
        if (this.expr != null && this.instrIndex == this.expr.getInstructionCount()) {
            return "Finished";
        }
        return "Running";
    }

    public static interface ValueReader {
        public static final ValueReader DUMMY = new ValueReader(){

            @Override
            public Object getValue(Varnode vn) throws DWARFExpressionValueException {
                throw new DWARFExpressionValueException(vn);
            }
        };

        public Object getValue(Varnode var1) throws DWARFExpressionValueException;
    }
}

