/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.label.GLabel;
import docking.widgets.textfield.IntegerTextField;
import ghidra.bitpatterns.gui.InputDialogComponentProvider;
import ghidra.bitpatterns.info.DataGatheringParams;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataGatheringParamsDialog
extends InputDialogComponentProvider {
    private static final String FIRST_BYTES_TEXT = "Number of first bytes";
    private static final String PRE_BYTES_TEXT = "Number of pre-bytes";
    private static final String RETURN_BYTES_TEXT = "Number of return bytes";
    private static final String FIRST_INSTRUCTIONS_TEXT = "Number of first instructions";
    private static final String PRE_INSTRUCTIONS_TEXT = "Number of pre-instructions";
    private static final String RETURN_INSTRUCTIONS_TEXT = "Number of return instructions";
    private static final String CONTEXT_REGISTER_TEXT = "Context Registers (CSV)";
    private static final int DEFAULT_FIRST_BYTES = 16;
    private static final int DEFAULT_PRE_BYTES = 12;
    private static final int DEFAULT_RETURN_BYTES = 12;
    private static final int DEFAULT_FIRST_INSTRUCTIONS = 4;
    private static final int DEFAULT_PRE_INSTRUCTIONS = 3;
    private static final int DEFAULT_RETURN_INSTRUCTIONS = 3;
    private static final String DEFAULT_CONTEXT_REGISTERS = "";
    private IntegerTextField firstBytesField;
    private IntegerTextField preBytesField;
    private IntegerTextField returnBytesField;
    private IntegerTextField firstInstructionsField;
    private IntegerTextField preInstructionsField;
    private IntegerTextField returnInstructionsField;
    private JTextField contextRegistersField;

    public DataGatheringParamsDialog(String title, Component parent) {
        super(title);
        JPanel panel = this.createPanel();
        this.addWorkPanel(panel);
        this.addOKButton();
        this.okButton.setText("OK");
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Data_Gathering_Parameters");
        this.setHelpLocation(helpLocation);
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    @Override
    protected JPanel createPanel() {
        JPanel mainPanel = new JPanel();
        PairLayout pairLayout = new PairLayout();
        mainPanel.setLayout((LayoutManager)pairLayout);
        mainPanel.add((Component)new GLabel(FIRST_BYTES_TEXT));
        this.firstBytesField = new IntegerTextField();
        this.firstBytesField.setValue(16);
        this.firstBytesField.getComponent().getAccessibleContext().setAccessibleName("First Bytes");
        mainPanel.add(this.firstBytesField.getComponent());
        mainPanel.add((Component)new GLabel(PRE_BYTES_TEXT));
        this.preBytesField = new IntegerTextField();
        this.preBytesField.setValue(12);
        this.preBytesField.getComponent().getAccessibleContext().setAccessibleName("Pre Bytes");
        mainPanel.add(this.preBytesField.getComponent());
        mainPanel.add((Component)new GLabel(RETURN_BYTES_TEXT));
        this.returnBytesField = new IntegerTextField();
        this.returnBytesField.setValue(12);
        this.returnBytesField.getComponent().getAccessibleContext().setAccessibleName("Return Bytes");
        mainPanel.add(this.returnBytesField.getComponent());
        mainPanel.add((Component)new GLabel(FIRST_INSTRUCTIONS_TEXT));
        this.firstInstructionsField = new IntegerTextField();
        this.firstInstructionsField.setValue(4);
        this.firstInstructionsField.getComponent().getAccessibleContext().setAccessibleName("First Instructions");
        mainPanel.add(this.firstInstructionsField.getComponent());
        mainPanel.add((Component)new GLabel(PRE_INSTRUCTIONS_TEXT));
        this.preInstructionsField = new IntegerTextField();
        this.preInstructionsField.setValue(3);
        this.preInstructionsField.getComponent().getAccessibleContext().setAccessibleName("Pre Instructions");
        mainPanel.add(this.preInstructionsField.getComponent());
        mainPanel.add((Component)new GLabel(RETURN_INSTRUCTIONS_TEXT));
        this.returnInstructionsField = new IntegerTextField();
        this.returnInstructionsField.setValue(3);
        this.returnInstructionsField.getComponent().getAccessibleContext().setAccessibleName("Return Instructions");
        mainPanel.add(this.returnInstructionsField.getComponent());
        mainPanel.add((Component)new GLabel(CONTEXT_REGISTER_TEXT));
        this.contextRegistersField = new JTextField(DEFAULT_CONTEXT_REGISTERS);
        this.contextRegistersField.getAccessibleContext().setAccessibleName("Context Registers");
        mainPanel.add(this.contextRegistersField);
        mainPanel.getAccessibleContext().setAccessibleName("Data Gathering Parameters");
        return mainPanel;
    }

    public DataGatheringParams getDataGatheringParams() {
        DataGatheringParams params = new DataGatheringParams();
        params.setNumFirstBytes(this.firstBytesField.getIntValue());
        params.setNumPreBytes(this.preBytesField.getIntValue());
        params.setNumReturnBytes(this.returnBytesField.getIntValue());
        params.setNumFirstInstructions(this.firstInstructionsField.getIntValue());
        params.setNumPreInstructions(this.preInstructionsField.getIntValue());
        params.setNumReturnInstructions(this.returnInstructionsField.getIntValue());
        String cRegsCSV = this.contextRegistersField.getText();
        params.setContextRegisters(DataGatheringParams.getContextRegisterList(cRegsCSV));
        return params;
    }
}

