/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.indexedscrollpane;

import docking.widgets.indexedscrollpane.IndexedScrollable;
import docking.widgets.indexedscrollpane.ViewToIndexMapper;
import java.math.BigInteger;

public class UniformViewToIndexMapper
implements ViewToIndexMapper {
    private int viewHeight;
    private int layoutHeight;
    private final IndexedScrollable scrollable;

    public UniformViewToIndexMapper(IndexedScrollable scrollable) {
        this.scrollable = scrollable;
        this.computeHeights();
    }

    private void computeHeights() {
        this.layoutHeight = this.scrollable.getHeight(BigInteger.ZERO);
        if (this.layoutHeight < 1) {
            this.layoutHeight = 1;
        }
        this.viewHeight = this.scrollable.getIndexCount().intValue() * this.layoutHeight;
    }

    @Override
    public int getViewHeight() {
        return this.viewHeight;
    }

    @Override
    public BigInteger getIndex(int value) {
        return BigInteger.valueOf(value / this.layoutHeight);
    }

    @Override
    public int getVerticalOffset(int value) {
        int index = value / this.layoutHeight;
        return index * this.layoutHeight - value;
    }

    @Override
    public void setVisibleViewHeight(int height) {
    }

    @Override
    public int getScrollValue(BigInteger startIndex, BigInteger endIndex, int startY, int endY) {
        int intValue = startIndex.intValue();
        return intValue * this.layoutHeight - startY;
    }

    @Override
    public void indexModelDataChanged(BigInteger start, BigInteger end) {
        this.computeHeights();
    }
}

