/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.util.AnimationPainter;
import docking.util.AnimationRunner;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.DisplayStringProvider;
import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableHeaderRenderer;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableSortState;
import docking.widgets.table.TableSortStateEditor;
import ghidra.docking.settings.Settings;
import ghidra.util.bean.GGlassPane;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Graphics;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections4.CollectionUtils;
import org.jdesktop.animation.timing.Animator;

public class TableUtils {
    private static AnimationRunner sortEmphasizingAnimationRunner;

    public static <ROW_OBJECT> void setSelectedItems(JTable table, List<ROW_OBJECT> items) {
        if (CollectionUtils.isEmpty(items)) {
            table.clearSelection();
            return;
        }
        TableModel model = table.getModel();
        if (!(model instanceof RowObjectTableModel)) {
            return;
        }
        RowObjectTableModel gModel = (RowObjectTableModel)model;
        ListSelectionModel selectionModel = table.getSelectionModel();
        int mode = selectionModel.getSelectionMode();
        if (mode == 0) {
            ROW_OBJECT item = items.get(items.size() - 1);
            int viewRow = gModel.getRowIndex(item);
            table.setRowSelectionInterval(viewRow, viewRow);
            return;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (ROW_OBJECT item : items) {
            int viewRow = gModel.getRowIndex(item);
            if (viewRow < 0) continue;
            rows.add(viewRow);
        }
        if (rows.isEmpty()) {
            return;
        }
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        Iterator<Object> iterator = rows.iterator();
        while (iterator.hasNext()) {
            int row = (Integer)iterator.next();
            selectionModel.addSelectionInterval(row, row);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public static <ROW_OBJECT> String getTableCellStringValue(RowObjectTableModel<ROW_OBJECT> model, ROW_OBJECT rowObject, int column) {
        Object value = model.getColumnValueForRow(rowObject, column);
        if (value == null) {
            return null;
        }
        String renderedString = TableUtils.getRenderedColumnValue(model, value, column);
        if (renderedString != null) {
            return renderedString;
        }
        if (value instanceof DisplayStringProvider) {
            return ((DisplayStringProvider)value).toString();
        }
        if (value instanceof JLabel) {
            JLabel label = (JLabel)value;
            String valueString = label.getText();
            return valueString == null ? "" : valueString;
        }
        return value.toString();
    }

    private static <ROW_OBJECT> String getRenderedColumnValue(RowObjectTableModel<ROW_OBJECT> model, Object columnValue, int columnIndex) {
        TableModel unwrappedModel = RowObjectTableModel.unwrap(model);
        if (!(unwrappedModel instanceof DynamicColumnTableModel)) {
            return null;
        }
        DynamicColumnTableModel columnBasedModel = (DynamicColumnTableModel)unwrappedModel;
        GColumnRenderer<Object> renderer = TableUtils.getColumnRenderer(columnBasedModel, columnIndex);
        if (renderer == null) {
            return null;
        }
        GColumnRenderer.ColumnConstraintFilterMode mode = renderer.getColumnConstraintFilterMode();
        if (mode == GColumnRenderer.ColumnConstraintFilterMode.ALLOW_CONSTRAINTS_FILTER_ONLY) {
            return null;
        }
        Settings settings = columnBasedModel.getColumnSettings(columnIndex);
        String s = renderer.getFilterString(columnValue, settings);
        return s;
    }

    private static <ROW_OBJECT> GColumnRenderer<Object> getColumnRenderer(DynamicColumnTableModel<ROW_OBJECT> columnBasedModel, int columnIndex) {
        DynamicTableColumn<ROW_OBJECT, ?, ?> column = columnBasedModel.getColumn(columnIndex);
        GColumnRenderer<Object> columnRenderer = column.getColumnRenderer();
        return columnRenderer;
    }

    public static void columnSelected(JTable table, int columnIndex) {
        int n;
        SortedTableModel sortedModel = TableUtils.getSortedTableModel(table);
        if (sortedModel == null) {
            return;
        }
        int modelColumnIndex = TableUtils.getColumnModelIndex(table, columnIndex);
        if (modelColumnIndex < 0) {
            return;
        }
        if (!sortedModel.isSortable(modelColumnIndex)) {
            return;
        }
        TableSortState columnSortStates = sortedModel.getTableSortState();
        TableSortStateEditor editor = new TableSortStateEditor(columnSortStates);
        if (editor.isColumnSorted(modelColumnIndex)) {
            editor.flipColumnSortDirection(modelColumnIndex);
        } else {
            editor.clear();
            editor.addSortedColumn(modelColumnIndex);
        }
        TableSortState newSortState = editor.createTableSortState();
        sortedModel.setTableSortState(newSortState);
        if (sortEmphasizingAnimationRunner != null) {
            sortEmphasizingAnimationRunner.stop();
        }
        if ((n = newSortState.getSortedColumnCount()) >= 2) {
            sortEmphasizingAnimationRunner = new SortEmphasisAnimationRunner(table, newSortState, columnIndex);
            sortEmphasizingAnimationRunner.start();
        }
        TableUtils.repaintTableHeaderForSortChange(table);
    }

    public static void columnAlternativelySelected(JTable table, int columnIndex) {
        int n;
        SortedTableModel sortedModel = TableUtils.getSortedTableModel(table);
        if (sortedModel == null) {
            return;
        }
        int modelColumnIndex = TableUtils.getColumnModelIndex(table, columnIndex);
        if (modelColumnIndex < 0) {
            return;
        }
        if (!sortedModel.isSortable(modelColumnIndex)) {
            return;
        }
        TableSortState columnSortStates = sortedModel.getTableSortState();
        TableSortStateEditor editor = new TableSortStateEditor(columnSortStates);
        if (editor.isColumnSorted(modelColumnIndex)) {
            editor.removeSortedColumn(modelColumnIndex);
        } else {
            editor.addSortedColumn(modelColumnIndex);
        }
        TableSortState newSortState = editor.createTableSortState();
        sortedModel.setTableSortState(newSortState);
        if (sortEmphasizingAnimationRunner != null) {
            sortEmphasizingAnimationRunner.stop();
        }
        if ((n = newSortState.getSortedColumnCount()) >= 2) {
            sortEmphasizingAnimationRunner = new SortEmphasisAnimationRunner(table, newSortState, columnIndex);
            sortEmphasizingAnimationRunner.start();
        }
        TableUtils.repaintTableHeaderForSortChange(table);
    }

    private static SortedTableModel getSortedTableModel(JTable table) {
        TableModel model = table.getModel();
        if (!(model instanceof SortedTableModel)) {
            return null;
        }
        return (SortedTableModel)model;
    }

    private static int getColumnModelIndex(JTable table, int columnIndex) {
        TableColumnModel columnModel = table.getColumnModel();
        return columnModel.getColumn(columnIndex).getModelIndex();
    }

    private static void repaintTableHeaderForSortChange(JTable table) {
        JTableHeader tableHeader = table.getTableHeader();
        if (tableHeader != null) {
            tableHeader.paintImmediately(tableHeader.getBounds());
        }
    }

    private static void resetEmphasis(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        int n = columnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn column = columnModel.getColumn(i);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (!(renderer instanceof GTableHeaderRenderer)) continue;
            GTableHeaderRenderer gRenderer = (GTableHeaderRenderer)renderer;
            gRenderer.setSortEmphasis(-1.0);
        }
    }

    private static class SortEmphasisAnimationRunner
    extends AnimationRunner {
        private JTable table;

        public SortEmphasisAnimationRunner(JTable table, TableSortState tableSortState, int clickedColumn) {
            super(table);
            this.table = table;
            int n = tableSortState.getSortedColumnCount();
            int[] ordinals = new int[n];
            for (int i = 1; i < n + 1; ++i) {
                ordinals[i - 1] = i;
            }
            Double[] values = new Double[n];
            for (int i = 0; i < n; ++i) {
                values[i] = ordinals[i];
            }
            EmphasizingSortPainter painter = new EmphasizingSortPainter(table, tableSortState, clickedColumn, ordinals);
            this.setPainter(painter);
            this.setValues(values);
            this.setDuration(Duration.ofSeconds(1L));
            this.setDoneCallback(this::done);
        }

        @Override
        public void start() {
            Animator animator = this.createAnimator();
            animator.setAcceleration(0.0f);
            animator.setDeceleration(0.0f);
            super.start();
        }

        private void done() {
            TableUtils.resetEmphasis(this.table);
        }
    }

    private static class EmphasizingSortPainter
    implements AnimationPainter {
        private TableSortState tableSortState;
        private JTable table;
        private Map<Integer, Integer> columnsByOrdinal = new HashMap<Integer, Integer>();
        private int clickedColumnIndex;

        public EmphasizingSortPainter(JTable table, TableSortState tableSortState, int clickedColumnIndex, int[] ordinals) {
            this.table = table;
            this.tableSortState = tableSortState;
            this.clickedColumnIndex = clickedColumnIndex;
            this.mapOrdinalsToColumns(ordinals);
        }

        private void mapOrdinalsToColumns(int[] ordinals) {
            block0: for (int i = 0; i < ordinals.length; ++i) {
                List<ColumnSortState> sortStates = this.tableSortState.getAllSortStates();
                for (ColumnSortState ss : sortStates) {
                    int columnOrdinal = ss.getSortOrder();
                    if (columnOrdinal != ordinals[i]) continue;
                    int sortColumnIndex = ss.getColumnModelIndex();
                    this.columnsByOrdinal.put(ordinals[i], sortColumnIndex);
                    continue block0;
                }
            }
        }

        @Override
        public void paint(GGlassPane glassPane, Graphics graphics, double value) {
            int columnViewIndex;
            JTableHeader tableHeader = this.table.getTableHeader();
            if (tableHeader == null) {
                return;
            }
            TableUtils.resetEmphasis(this.table);
            ColumnAndRange columnAndRange = this.getColumnAndRange(value);
            if (columnAndRange == null) {
                return;
            }
            TableColumnModel columnModel = this.table.getColumnModel();
            TableColumn column = columnModel.getColumn(columnViewIndex = this.table.convertColumnIndexToView(columnAndRange.column()));
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (!(renderer instanceof GTableHeaderRenderer)) {
                return;
            }
            GTableHeaderRenderer gRenderer = (GTableHeaderRenderer)renderer;
            double range = columnAndRange.range();
            double emphasis = range < 0.5 ? 1.0 + range : 2.0 - range;
            gRenderer.setSortEmphasis(emphasis);
            tableHeader.repaint();
        }

        private ColumnAndRange getColumnAndRange(double value) {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(value));
            int ordinal = bigDecimal.intValue();
            Integer columnModelIndex = this.columnsByOrdinal.get(ordinal);
            if (columnModelIndex >= this.clickedColumnIndex) {
                int nextOrdinal = ordinal + 1;
                columnModelIndex = this.columnsByOrdinal.get(nextOrdinal);
            }
            BigDecimal bigOrdinal = new BigDecimal(ordinal);
            BigDecimal decimalValue = bigDecimal.subtract(bigOrdinal);
            return new ColumnAndRange(columnModelIndex, decimalValue.doubleValue());
        }

        private record ColumnAndRange(int column, double range) {
        }
    }
}

