/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.babel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import tim.prune.I18nManager;
import tim.prune.gui.IconManager;
import tim.prune.gui.StatusIcon;
import tim.prune.load.babel.AddFilterDialog;

public class BabelFilterPanel
extends JPanel {
    private JTextField _filterField = null;
    private StatusIcon _validIcon = null;
    private AddFilterDialog _addDialog = null;
    private IconManager _iconManager = null;
    private static final Pattern FILTER_PATTERN = Pattern.compile("(-x [a-z,.0-9=]+ *)+");

    public BabelFilterPanel(JFrame jFrame, IconManager iconManager) {
        this._iconManager = iconManager;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.gpsbabel.filters")), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.initPanel();
        this._addDialog = new AddFilterDialog(this, jFrame);
    }

    private void initPanel() {
        this.setLayout(new BorderLayout(4, 4));
        this._filterField = new JTextField(20);
        this._filterField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(() -> BabelFilterPanel.this.checkFilter());
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(3, 3));
        jPanel2.add((Component)this._filterField, "Center");
        this._validIcon = new StatusIcon(this._iconManager);
        jPanel2.add((Component)this._validIcon, "East");
        jPanel.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JButton jButton = new JButton(I18nManager.getText("button.addnew"));
        jButton.addActionListener(actionEvent -> this._addDialog.showDialog());
        jPanel3.add(jButton);
        jPanel3.add(Box.createVerticalStrut(2));
        JButton jButton2 = new JButton(I18nManager.getText("button.delete"));
        jButton2.addActionListener(actionEvent -> {
            this._filterField.setText("");
            this.checkFilter();
        });
        jPanel3.add(jButton2);
        this.add((Component)jPanel3, "East");
    }

    public void setFilterString(String string) {
        if (string != null && this._filterField != null) {
            this._filterField.setText(string.trim());
        }
        this.checkFilter();
    }

    public String getFilterString() {
        String string = this._filterField.getText();
        return string == null ? null : string.trim();
    }

    public boolean hasFilter() {
        String string = this.getFilterString();
        return string != null && string.length() > 0;
    }

    public boolean isFilterValid() {
        String string = this.getFilterString();
        return string != null && FILTER_PATTERN.matcher(string).matches();
    }

    public void addFilter(String string) {
        if (string != null) {
            String string2 = string.trim();
            String string3 = this.getFilterString();
            if (!string2.equals("")) {
                string3 = string3 == null || string3.equals("") ? string2 : String.valueOf(string3) + " " + string2;
            }
            this._filterField.setText(string3);
        }
        this.checkFilter();
    }

    private void checkFilter() {
        if (this.hasFilter()) {
            if (this.isFilterValid()) {
                this._validIcon.setStatusValid();
            } else {
                this._validIcon.setStatusInvalid();
            }
        } else {
            this._validIcon.setStatusBlank();
        }
    }
}

