/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0001*\u00020\u0013\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"dump", "", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "RESERVED_MEMBER_NAME_SUFFIX", "toJsIdentifier", "", "joinTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "findOriginallyContainingModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "calculateJsFunctionSignature", "declaration", "jsFunctionSignature", "nameIfPropertyAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "SYNTHETIC_LOOP_LABEL", "SYNTHETIC_BLOCK_LABEL", "backend.js"})
@SourceDebugExtension(value={"SMAP\nNameTables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameTables.kt\norg/jetbrains/kotlin/ir/backend/js/utils/NameTablesKt\n+ 2 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,295:1\n28#2:296\n29#2:298\n28#2:299\n29#2:301\n28#2:305\n29#2:307\n1#3:297\n1#3:300\n1#3:306\n195#4:302\n1915#5,2:303\n*S KotlinDebug\n*F\n+ 1 NameTables.kt\norg/jetbrains/kotlin/ir/backend/js/utils/NameTablesKt\n*L\n106#1:296\n106#1:298\n110#1:299\n110#1:301\n274#1:305\n274#1:307\n106#1:297\n110#1:300\n274#1:306\n132#1:302\n134#1:303,2\n*E\n"})
public final class NameTablesKt {
    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, "<this>");
        return "Names: \n" + CollectionsKt.joinToString$default(MapsKt.toList($this$dump.getNames()), "\n", null, null, 0, null, NameTablesKt::dump$lambda$0, 30, null);
    }

    @NotNull
    public static final String toJsIdentifier(int $this$toJsIdentifier) {
        String string;
        String first = String.valueOf((char)(97 + $this$toJsIdentifier % 26));
        int other = $this$toJsIdentifier / 26;
        if (other == 0) {
            string = first;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(first);
            String string2 = Integer.toString(other, CharsKt.checkRadix(36));
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            string = stringBuilder.append(string2).toString();
        }
        return string;
    }

    private static final String joinTypes(List<? extends IrType> $this$joinTypes, JsIrBackendContext context2) {
        if ($this$joinTypes.isEmpty()) {
            return "";
        }
        return CollectionsKt.joinToString$default($this$joinTypes, "$", "$", null, 0, null, arg_0 -> NameTablesKt.joinTypes$lambda$0(context2, arg_0), 28, null);
    }

    private static final IrModuleFragment findOriginallyContainingModule(IrFunction $this$findOriginallyContainingModule) {
        if (JsLoweredDeclarationOrigin.INSTANCE.isBridgeDeclarationOrigin($this$findOriginallyContainingModule.getOrigin())) {
            IrSimpleFunction irSimpleFunction = $this$findOriginallyContainingModule instanceof IrSimpleFunction ? (IrSimpleFunction)$this$findOriginallyContainingModule : null;
            if (irSimpleFunction == null) {
                IrExceptionBuilder irExceptionBuilder;
                String message$iv = "Bridge must be IrSimpleFunction";
                boolean $i$f$irError = false;
                IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                boolean bl = false;
                IrExceptionBuilder $this$findOriginallyContainingModule_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
                boolean bl2 = false;
                $this$findOriginallyContainingModule_u24lambda_u240.withIrEntry("this", $this$findOriginallyContainingModule);
                IrExceptionBuilder builder$iv = irExceptionBuilder;
                throw new IllegalStateException(builder$iv.buildString().toString());
            }
            IrSimpleFunction thisSimpleFunction = irSimpleFunction;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = CollectionsKt.firstOrNull(thisSimpleFunction.getOverriddenSymbols());
            if (irSimpleFunctionSymbol == null) {
                IrExceptionBuilder irExceptionBuilder;
                String message$iv = "Couldn't find the overridden function for the bridge";
                boolean $i$f$irError = false;
                IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                boolean bl = false;
                IrExceptionBuilder $this$findOriginallyContainingModule_u24lambda_u241 = $this$irError_u24lambda_u240$iv;
                boolean bl3 = false;
                $this$findOriginallyContainingModule_u24lambda_u241.withIrEntry("thisSimpleFunction", thisSimpleFunction);
                IrExceptionBuilder builder$iv = irExceptionBuilder;
                throw new IllegalStateException(builder$iv.buildString().toString());
            }
            IrSimpleFunctionSymbol bridgeFrom = irSimpleFunctionSymbol;
            return NameTablesKt.findOriginallyContainingModule(bridgeFrom.getOwner());
        }
        IrPackageFragment irPackageFragment = IrUtilsKt.getPackageFragment($this$findOriginallyContainingModule);
        IrFile irFile = irPackageFragment instanceof IrFile ? (IrFile)irPackageFragment : null;
        return irFile != null ? irFile.getModule() : null;
    }

    @NotNull
    public static final String calculateJsFunctionSignature(@NotNull IrFunction declaration, @NotNull JsIrBackendContext context2) {
        IrModuleFragment containingModule;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        String string = NameTablesKt.nameIfPropertyAccessor(declaration);
        if (string == null) {
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        }
        String declarationName = string;
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(declarationName);
        if (declaration.getVisibility() == DescriptorVisibilities.INTERNAL && IrUtilsKt.getParentClassOrNull(declaration) != null && (containingModule = NameTablesKt.findOriginallyContainingModule(declaration)) != null) {
            nameBuilder.append("_$m_").append(containingModule.getName().toString());
        }
        Collection $this$ifNotEmpty$iv = declaration.getTypeParameters();
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$calculateJsFunctionSignature_u24lambda_u240 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            nameBuilder.append("_$t");
            Iterable $this$forEach$iv = $this$calculateJsFunctionSignature_u24lambda_u240;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrTypeParameter typeParam = (IrTypeParameter)element$iv;
                boolean bl2 = false;
                nameBuilder.append("_").append(typeParam.getName().asString()).append(NameTablesKt.joinTypes(typeParam.getSuperTypes(), context2));
            }
        }
        block7: for (IrValueParameter parameter : declaration.getParameters()) {
            switch (WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
                case 1: {
                    continue block7;
                }
                case 2: {
                    StringBuilder stringBuilder = nameBuilder.append("_r$");
                    break;
                }
                case 3: {
                    StringBuilder stringBuilder = nameBuilder.append("_c$");
                    break;
                }
                case 4: {
                    StringBuilder stringBuilder = nameBuilder.append("_");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            nameBuilder.append(IrTypeUtilsKt.asString(parameter.getType(), context2));
            nameBuilder.append(NameTablesKt.joinTypes(org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.superTypes(parameter.getType()), context2));
            if (!Intrinsics.areEqual(parameter.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getJS_SHADOWED_DEFAULT_PARAMETER())) continue;
            nameBuilder.append("?");
        }
        IrType it = declaration.getReturnType();
        boolean bl = false;
        if (context2.getInlineClassesUtils().isTypeInlined(it) || IrTypePredicatesKt.isUnit(it)) {
            nameBuilder.append("_ret$" + IrTypeUtilsKt.asString(it, context2));
        }
        String string3 = Integer.toString(Math.abs(nameBuilder.toString().hashCode()), CharsKt.checkRadix(36));
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        String signature = string3;
        String sanitizedName = IdentifierPolicyKt.makeValidES5Identifier(declarationName, false);
        return context2.getGlobalIrInterner().string(sanitizedName + '_' + signature + "_k$");
    }

    @NotNull
    public static final String jsFunctionSignature(@NotNull IrFunction declaration, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(!IrDeclarationsKt.isStaticMethodOfClass(declaration))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(declaration.getDispatchReceiverParameter() != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (MiscKt.hasStableJsName(declaration, context2)) {
            String string = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            String declarationName = string;
            if (!(!StringsKt.endsWith$default(declarationName, "_k$", false, 2, null))) {
                boolean bl = false;
                String string2 = "Function " + IrUtilsKt.getFqNameWhenAvailable(declaration) + " uses reserved name suffix \"_k$\"";
                throw new IllegalArgumentException(string2.toString());
            }
            return declarationName;
        }
        IrSimpleFunction irSimpleFunction = declaration instanceof IrSimpleFunction ? (IrSimpleFunction)declaration : null;
        IrFunction declarationSignature = irSimpleFunction != null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(irSimpleFunction, null, 1, null)) != null ? (IrFunction)irSimpleFunction : declaration;
        return NameTablesKt.calculateJsFunctionSignature(declarationSignature, context2);
    }

    @Nullable
    public static final String nameIfPropertyAccessor(@NotNull IrDeclarationWithName $this$nameIfPropertyAccessor) {
        Intrinsics.checkNotNullParameter($this$nameIfPropertyAccessor, "<this>");
        if ($this$nameIfPropertyAccessor instanceof IrSimpleFunction) {
            String string;
            if (((IrSimpleFunction)$this$nameIfPropertyAccessor).getCorrespondingPropertySymbol() != null) {
                String string2;
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$nameIfPropertyAccessor).getCorrespondingPropertySymbol();
                Intrinsics.checkNotNull(irPropertySymbol);
                IrProperty property2 = (IrProperty)irPropertySymbol.getOwner();
                String string3 = AnnotationUtilsKt.getJsNameOrKotlinName(property2).asString();
                Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
                String name2 = string3;
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)$this$nameIfPropertyAccessor;
                if (Intrinsics.areEqual(irSimpleFunction, property2.getGetter())) {
                    string2 = "get_";
                } else if (Intrinsics.areEqual(irSimpleFunction, property2.getSetter())) {
                    string2 = "set_";
                } else {
                    IrExceptionBuilder irExceptionBuilder;
                    String message$iv = "";
                    boolean $i$f$irError = false;
                    IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                    boolean bl = false;
                    IrExceptionBuilder $this$nameIfPropertyAccessor_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
                    boolean bl2 = false;
                    $this$nameIfPropertyAccessor_u24lambda_u240.withIrEntry("this", $this$nameIfPropertyAccessor);
                    IrExceptionBuilder builder$iv = irExceptionBuilder;
                    throw new IllegalStateException(builder$iv.buildString().toString());
                }
                String prefix = string2;
                string = prefix + name2;
            } else if (Intrinsics.areEqual($this$nameIfPropertyAccessor.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_PROPERTY_ACCESSOR())) {
                String string4 = AnnotationUtilsKt.getJsNameOrKotlinName($this$nameIfPropertyAccessor).asString();
                Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
                string = StringsKt.replaceFirst$default(StringsKt.replaceFirst$default(StringsKt.removeSuffix(StringsKt.removePrefix(string4, (CharSequence)"<"), (CharSequence)">"), "get-", "get_", false, 4, null), "set-", "set_", false, 4, null);
            } else {
                string = null;
            }
            return string;
        }
        return null;
    }

    private static final CharSequence dump$lambda$0(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        IrDeclaration declaration = (IrDeclaration)pair.component1();
        String name2 = (String)pair.component2();
        Intrinsics.checkNotNull(declaration, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        FqName decl = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)declaration);
        Object object = decl;
        if (object == null) {
            object = declaration;
        }
        FqName declRef = object;
        return "---  " + declRef + " => " + name2;
    }

    private static final CharSequence joinTypes$lambda$0(JsIrBackendContext $context, IrType superType) {
        Intrinsics.checkNotNullParameter(superType, "superType");
        return IrTypeUtilsKt.asString(superType, $context);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrParameterKind.values().length];
            try {
                nArray[IrParameterKind.DispatchReceiver.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.ExtensionReceiver.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Context.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Regular.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

