/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Maps;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyConsoleDebugProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.remote.RemoteProcessControl;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyConsoleDebugProcess
extends PyDebugProcess {
    private final int myLocalPort;
    private final PyConsoleDebugProcessHandler myConsoleDebugProcessHandler;

    public PyConsoleDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @NotNull PyConsoleDebugProcessHandler consoleDebugProcessHandler) {
        if (session == null) {
            PyConsoleDebugProcess.$$$reportNull$$$0(0);
        }
        if (serverSocket == null) {
            PyConsoleDebugProcess.$$$reportNull$$$0(1);
        }
        if (executionConsole == null) {
            PyConsoleDebugProcess.$$$reportNull$$$0(2);
        }
        if (consoleDebugProcessHandler == null) {
            PyConsoleDebugProcess.$$$reportNull$$$0(3);
        }
        super(session, serverSocket, executionConsole, consoleDebugProcessHandler, false);
        this.myLocalPort = serverSocket.getLocalPort();
        this.myConsoleDebugProcessHandler = consoleDebugProcessHandler;
    }

    @Override
    public void sessionInitialized() {
    }

    @Override
    protected String getConnectionMessage() {
        return PyBundle.message("progress.text.connecting.to.console", new Object[0]);
    }

    @Override
    protected String getConnectionTitle() {
        return PyBundle.message("progress.title.debugger.connection", new Object[0]);
    }

    @Override
    protected void detachDebuggedProcess() {
    }

    @Override
    protected void beforeConnect() {
        this.printToConsole(this.getCurrentStateMessage() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @Override
    public int getConnectTimeout() {
        return 0;
    }

    public void connect(PydevConsoleCommunication consoleCommunication) throws Exception {
        Pair<String, Integer> portToConnect = this.myConsoleDebugProcessHandler.getConsoleProcessHandler() instanceof RemoteProcessControl ? PyConsoleDebugProcess.getRemoteHostPortForDebuggerConnection(this.myLocalPort, (RemoteProcessControl)this.myConsoleDebugProcessHandler.getConsoleProcessHandler()) : Pair.create((Object)"localhost", (Object)this.myLocalPort);
        Map<String, Boolean> optionsMap = PyConsoleDebugProcess.makeDebugOptionsMap(this.getSession());
        Map<String, String> envs = PyConsoleDebugProcess.getDebuggerEnvs(this.getSession());
        consoleCommunication.connectToDebugger((Integer)portToConnect.getSecond(), (String)portToConnect.getFirst(), optionsMap, envs);
    }

    public static Map<String, String> getDebuggerEnvs(XDebugSession session) {
        HashMap env = Maps.newHashMap();
        PyDebugRunner.configureDebugEnvironment(session.getProject(), env, session.getRunProfile());
        return env;
    }

    public static Map<String, Boolean> makeDebugOptionsMap(XDebugSession session) {
        Project project = session.getProject();
        PyDebuggerOptionsProvider userOpts = PyDebuggerOptionsProvider.getInstance(project);
        HashMap dbgOpts = Maps.newHashMap();
        dbgOpts.put("save-signatures", userOpts.isSaveCallSignatures());
        dbgOpts.put("qt-support", userOpts.isSupportQtDebugging());
        return dbgOpts;
    }

    public void waitForNextConnection() {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (this.getSession().isSuspended()) {
            this.getSession().resume();
        }
        if (!this.isWaitingForConnection()) {
            this.setWaitingForConnection(true);
            UIUtil.invokeLaterIfNeeded(() -> this.waitForConnection(this.getCurrentStateMessage(), this.getConnectionTitle()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serverSocket";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "executionConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "consoleDebugProcessHandler";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/console/PyConsoleDebugProcess";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

