/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.html.DocumentBlockType;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;

public class L2HVerbatimInput
extends ControlSequence {
    protected String cssClassName;

    public L2HVerbatimInput() {
        this("verbatiminput", null);
    }

    public L2HVerbatimInput(String string, String string2) {
        super(string);
        this.cssClassName = string2;
    }

    @Override
    public Object clone() {
        return new L2HVerbatimInput(this.getName(), this.cssClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        boolean bl = this.popModifier(teXParser, teXObjectList, 42) != -1;
        this.popOptArg(teXParser, teXObjectList);
        TeXPath teXPath = TeXParserUtils.popTeXPath(teXParser, teXObjectList);
        l2HConverter.writeliteral("<pre");
        if (this.cssClassName != null) {
            l2HConverter.writeliteral(" class=\"");
            l2HConverter.writeliteral(this.cssClassName);
            l2HConverter.writeliteral("\"");
        }
        l2HConverter.writeliteral(">");
        l2HConverter.writeliteral("<!-- ");
        l2HConverter.write(this.getName());
        l2HConverter.write(": ");
        l2HConverter.write(teXPath.toString());
        l2HConverter.writeliteralln(" -->");
        Path path = teXPath.getPath();
        Charset charset = teXPath.getEncoding();
        if (charset == null) {
            charset = l2HConverter.getCharSet();
        }
        l2HConverter.setCurrentBlockType(DocumentBlockType.BLOCK);
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = l2HConverter.getTeXApp().createBufferedReader(path, charset);
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    string = string.replaceAll(" ", "\u2423");
                }
                l2HConverter.writeln(string);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            l2HConverter.setCurrentBlockType(DocumentBlockType.BODY);
            l2HConverter.writeliteralln("</pre>");
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

