﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-runtime/BedrockRuntimeRequest.h>
#include <aws/bedrock-runtime/BedrockRuntime_EXPORTS.h>
#include <aws/bedrock-runtime/model/CountTokensInput.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace BedrockRuntime {
namespace Model {

/**
 */
class CountTokensRequest : public BedrockRuntimeRequest {
 public:
  AWS_BEDROCKRUNTIME_API CountTokensRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CountTokens"; }

  AWS_BEDROCKRUNTIME_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier or ARN of the foundation model to use for token
   * counting. Each model processes tokens differently, so the token count is
   * specific to the model you specify.</p>
   */
  inline const Aws::String& GetModelId() const { return m_modelId; }
  inline bool ModelIdHasBeenSet() const { return m_modelIdHasBeenSet; }
  template <typename ModelIdT = Aws::String>
  void SetModelId(ModelIdT&& value) {
    m_modelIdHasBeenSet = true;
    m_modelId = std::forward<ModelIdT>(value);
  }
  template <typename ModelIdT = Aws::String>
  CountTokensRequest& WithModelId(ModelIdT&& value) {
    SetModelId(std::forward<ModelIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The input for which to count tokens. The structure of this parameter depends
   * on whether you're counting tokens for an <code>InvokeModel</code> or
   * <code>Converse</code> request:</p> <ul> <li> <p>For <code>InvokeModel</code>
   * requests, provide the request body in the <code>invokeModel</code> field</p>
   * </li> <li> <p>For <code>Converse</code> requests, provide the messages and
   * system content in the <code>converse</code> field</p> </li> </ul> <p>The input
   * format must be compatible with the model specified in the <code>modelId</code>
   * parameter.</p>
   */
  inline const CountTokensInput& GetInput() const { return m_input; }
  inline bool InputHasBeenSet() const { return m_inputHasBeenSet; }
  template <typename InputT = CountTokensInput>
  void SetInput(InputT&& value) {
    m_inputHasBeenSet = true;
    m_input = std::forward<InputT>(value);
  }
  template <typename InputT = CountTokensInput>
  CountTokensRequest& WithInput(InputT&& value) {
    SetInput(std::forward<InputT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_modelId;

  CountTokensInput m_input;
  bool m_modelIdHasBeenSet = false;
  bool m_inputHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockRuntime
}  // namespace Aws
