/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.util.ArrayList;
import java.util.Objects;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.outline.MapAwareOutlinePane;
import org.freeplane.view.swing.map.outline.MapTreeNode;
import org.freeplane.view.swing.map.outline.OutlineTreeViewState;
import org.freeplane.view.swing.map.outline.TreeNode;

class NodeTreeBuilder {
    private final MapView mapView;
    private final MapAwareOutlinePane pane;
    private final OutlineTreeViewState saved;
    private NodeModel rootModel;
    private Filter filter;
    private NodeModel overrideRootModel;
    private Filter overrideFilter;
    private TreeNode root;
    private OutlineTreeViewState applicableState;

    NodeTreeBuilder(MapView mapView, MapAwareOutlinePane pane, OutlineTreeViewState saved) {
        this.mapView = mapView;
        this.pane = pane;
        this.saved = saved;
    }

    NodeTreeBuilder build() {
        this.initializeRootModel();
        if (this.rootModel == null) {
            return this;
        }
        this.initializeFilter();
        boolean canApply = false;
        if (this.saved != null) {
            String currentRootId = this.rootModel.getID();
            Filter savedFilter = this.saved.getSavedFilter() != null ? (Filter)this.saved.getSavedFilter().get() : null;
            canApply = Objects.equals(this.saved.getRootNodeId(), currentRootId) && Objects.equals(savedFilter, this.filter);
        }
        this.applicableState = canApply ? this.saved : null;
        MapTreeNode outRoot = new MapTreeNode(this.rootModel, this.pane, this.mapView.getModeController().getExtension(NodeStyleController.class), this.mapView.getBackground());
        this.rootModel.addViewer(outRoot);
        this.root = outRoot;
        this.rebuildDescendants(outRoot, this.rootModel);
        return this;
    }

    NodeTreeBuilder withRootModel(NodeModel rootModel) {
        this.overrideRootModel = rootModel;
        return this;
    }

    NodeTreeBuilder withFilter(Filter filter) {
        this.overrideFilter = filter;
        return this;
    }

    NodeTreeBuilder rebuildSubtree(MapTreeNode existingSubtreeRoot) {
        if (existingSubtreeRoot == null) {
            return this;
        }
        NodeModel subtreeRootModel = existingSubtreeRoot.getNodeModel();
        if (subtreeRootModel == null) {
            return this;
        }
        this.rootModel = subtreeRootModel;
        this.initializeFilter();
        this.rebuildDescendants(existingSubtreeRoot, subtreeRootModel);
        this.root = existingSubtreeRoot;
        this.applicableState = null;
        return this;
    }

    private void initializeRootModel() {
        if (this.overrideRootModel != null) {
            this.rootModel = this.overrideRootModel;
            return;
        }
        this.rootModel = this.mapView.getRoot().getNode();
    }

    private void initializeFilter() {
        if (this.overrideFilter != null) {
            this.filter = this.overrideFilter;
            return;
        }
        this.filter = this.mapView != null ? this.mapView.getFilter() : null;
    }

    private void rebuildDescendants(MapTreeNode parentOut, NodeModel parentModel) {
        this.clearOutlineChildren(parentOut);
        this.visitChildren(parentModel, parentOut);
    }

    private void clearOutlineChildren(MapTreeNode parentOut) {
        ArrayList<TreeNode> currentChildren = new ArrayList<TreeNode>(parentOut.getChildren());
        for (TreeNode child : currentChildren) {
            if (!(child instanceof MapTreeNode)) continue;
            MapTreeNode mapChild = (MapTreeNode)child;
            parentOut.remove(mapChild);
            mapChild.setParent(null);
            mapChild.cleanupListeners();
        }
    }

    private void visitChildren(NodeModel model, MapTreeNode parentOut) {
        for (NodeModel child : model.getChildren()) {
            boolean visible = !SummaryNode.isSummaryNode(child) && !SummaryNode.isFirstGroupNode(child) && (this.filter == null || this.filter.isVisible(child));
            MapTreeNode nextParent = parentOut;
            if (visible) {
                MapTreeNode out = new MapTreeNode(parentOut, child);
                child.addViewer(out);
                nextParent = out;
            }
            this.visitChildren(child, nextParent);
        }
    }

    TreeNode getRoot() {
        return this.root;
    }

    OutlineTreeViewState getApplicableState() {
        return this.applicableState;
    }
}

