/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing.inference.mutability;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundType;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypeEnhancer;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypesKt;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.InferenceContext;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.State;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.mutability.MutabilityStateUpdater;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/mutability/MutabilityBoundTypeEnhancer;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundTypeEnhancer;", "<init>", "()V", "enhance", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "boundType", "inferenceContext", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/InferenceContext;", "enhanceKotlinType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "allowLowerEnhancement", "", "kotlin.j2k.k1.new.post-processing"})
public final class MutabilityBoundTypeEnhancer
extends BoundTypeEnhancer {
    @Override
    @NotNull
    public BoundType enhance(@NotNull KtExpression expression, @NotNull BoundType boundType, @NotNull InferenceContext inferenceContext) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)boundType, (String)"boundType");
        Intrinsics.checkNotNullParameter((Object)inferenceContext, (String)"inferenceContext");
        return boundType;
    }

    @Override
    @NotNull
    public BoundType enhanceKotlinType(@NotNull KotlinType type2, @NotNull BoundType boundType, boolean allowLowerEnhancement, @NotNull InferenceContext inferenceContext) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)boundType, (String)"boundType");
        Intrinsics.checkNotNullParameter((Object)inferenceContext, (String)"inferenceContext");
        if (FlexibleTypesKt.isFlexible((KotlinType)type2)) {
            return boundType;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        FqName fqName2 = classifierDescriptor != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor)) : null;
        State enhancement = MutabilityStateUpdater.Companion.getMutableToImmutable().containsKey(fqName2) && allowLowerEnhancement ? State.LOWER : (MutabilityStateUpdater.Companion.getImmutableToMutable().containsKey(fqName2) ? State.UPPER : null);
        return BoundTypesKt.enhanceWith(boundType, enhancement);
    }
}

