"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultipleAuthentication = void 0;
var _authentication_type = require("../authentication_type");
var _common = require("../../../../common");
var _next_url = require("../../../utils/next_url");
var _routes = require("./routes");
var _types = require("../../types");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          *   Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   Licensed under the Apache License, Version 2.0 (the "License").
                                                                                                                                                                                                                                                                                                                          *   You may not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                          *   A copy of the License is located at
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *       http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   or in the "license" file accompanying this file. This file is distributed
                                                                                                                                                                                                                                                                                                                          *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
                                                                                                                                                                                                                                                                                                                          *   express or implied. See the License for the specific language governing
                                                                                                                                                                                                                                                                                                                          *   permissions and limitations under the License.
                                                                                                                                                                                                                                                                                                                          */
class MultipleAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, coreSetup, logger) {
    super(config, sessionStorageFactory, router, esClient, coreSetup, logger);
    _defineProperty(this, "authTypes", void 0);
    _defineProperty(this, "authHandlers", void 0);
    this.authTypes = this.config.auth.type;
    this.authHandlers = new Map();
  }
  async init() {
    const routes = new _routes.MultiAuthRoutes(this.router, this.sessionStorageFactory);
    routes.setupRoutes();
    for (let i = 0; i < this.authTypes.length; i++) {
      switch (this.authTypes[i].toLowerCase()) {
        case _common.AuthType.BASIC:
          {
            const BasicAuth = new _types.BasicAuthentication(this.config, this.sessionStorageFactory, this.router, this.esClient, this.coreSetup, this.logger);
            await BasicAuth.init();
            this.authHandlers.set(_common.AuthType.BASIC, BasicAuth);
            break;
          }
        case _common.AuthType.OPEN_ID:
          {
            const OidcAuth = new _types.OpenIdAuthentication(this.config, this.sessionStorageFactory, this.router, this.esClient, this.coreSetup, this.logger);
            await OidcAuth.init();
            this.authHandlers.set(_common.AuthType.OPEN_ID, OidcAuth);
            break;
          }
        case _common.AuthType.SAML:
          {
            const SamlAuth = new _types.SamlAuthentication(this.config, this.sessionStorageFactory, this.router, this.esClient, this.coreSetup, this.logger);
            await SamlAuth.init();
            this.authHandlers.set(_common.AuthType.SAML, SamlAuth);
            break;
          }
        case _common.AuthType.PROXY:
          {
            const ProxyAuth = new _types.ProxyAuthentication(this.config, this.sessionStorageFactory, this.router, this.esClient, this.coreSetup, this.logger);
            await ProxyAuth.init();
            this.authHandlers.set(_common.AuthType.PROXY, ProxyAuth);
            break;
          }
        case _common.AuthType.JWT:
          {
            const JwtAuth = new _types.JwtAuthentication(this.config, this.sessionStorageFactory, this.router, this.esClient, this.coreSetup, this.logger);
            await JwtAuth.init();
            this.authHandlers.set(_common.AuthType.JWT, JwtAuth);
            break;
          }
        default:
          {
            throw new Error(`Unsupported authentication type: ${this.authTypes[i]}`);
          }
      }
    }
  }

  // override functions inherited from AuthenticationType
  requestIncludesAuthInfo(request) {
    for (const key of this.authHandlers.keys()) {
      if (this.authHandlers.get(key).requestIncludesAuthInfo(request)) {
        return true;
      }
    }
    return false;
  }
  async getAdditionalAuthHeader(request) {
    var _cookie$authType;
    // To Do: refactor this method to improve the efficiency to get cookie, get cookie from input parameter
    const cookie = await this.sessionStorageFactory.asScoped(request).get();
    const reqAuthType = cookie === null || cookie === void 0 || (_cookie$authType = cookie.authType) === null || _cookie$authType === void 0 ? void 0 : _cookie$authType.toLowerCase();
    if (reqAuthType && this.authHandlers.has(reqAuthType)) {
      return await this.authHandlers.get(reqAuthType).getAdditionalAuthHeader(request);
    } else {
      const authHeaders = {};
      for (const handler of this.authHandlers.values()) {
        Object.assign(authHeaders, await handler.getAdditionalAuthHeader(request));
      }
      return authHeaders;
    }
  }
  getCookie(request, authInfo) {
    // TODO: This logic is only applicable for JWT auth type
    for (const handler of this.authHandlers.values()) {
      if (handler.requestIncludesAuthInfo(request)) {
        return handler.getCookie(request, authInfo);
      }
    }
    return {};
  }
  getKeepAliveExpiry(cookie, request) {
    var _cookie$authType2;
    const reqAuthType = cookie === null || cookie === void 0 || (_cookie$authType2 = cookie.authType) === null || _cookie$authType2 === void 0 ? void 0 : _cookie$authType2.toLowerCase();
    if (reqAuthType && this.authHandlers.has(reqAuthType)) {
      return this.authHandlers.get(reqAuthType).getKeepAliveExpiry(cookie, request);
    } else {
      // default to TTL setting
      return Date.now() + this.config.session.ttl;
    }
  }
  async isValidCookie(cookie, request) {
    var _cookie$authType3;
    const reqAuthType = cookie === null || cookie === void 0 || (_cookie$authType3 = cookie.authType) === null || _cookie$authType3 === void 0 ? void 0 : _cookie$authType3.toLowerCase();
    if (reqAuthType && this.authHandlers.has(reqAuthType)) {
      return this.authHandlers.get(reqAuthType).isValidCookie(cookie, request);
    } else {
      return false;
    }
  }
  handleUnauthedRequest(request, response, toolkit) {
    if (this.isPageRequest(request)) {
      const nextUrlParam = (0, _next_url.composeNextUrlQueryParam)(request, this.coreSetup.http.basePath.serverBasePath);
      return response.redirected({
        headers: {
          location: `${this.coreSetup.http.basePath.serverBasePath}${_common.LOGIN_PAGE_URI}?${nextUrlParam}`
        }
      });
    } else {
      return response.unauthorized();
    }
  }
  buildAuthHeaderFromCookie(cookie, request) {
    var _cookie$authType4;
    const reqAuthType = cookie === null || cookie === void 0 || (_cookie$authType4 = cookie.authType) === null || _cookie$authType4 === void 0 ? void 0 : _cookie$authType4.toLowerCase();
    if (reqAuthType && this.authHandlers.has(reqAuthType)) {
      return this.authHandlers.get(reqAuthType).buildAuthHeaderFromCookie(cookie, request);
    } else {
      return {};
    }
  }
}
exports.MultipleAuthentication = MultipleAuthentication;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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