/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class AcrFullFmt
extends AbstractGlsCommand {
    protected boolean isPlural;
    protected CaseChange caseChange;

    public AcrFullFmt(GlossariesSty glossariesSty) {
        this("acrfullfmt", CaseChange.NO_CHANGE, false, glossariesSty);
    }

    public AcrFullFmt(String string, boolean bl, GlossariesSty glossariesSty) {
        this(string, CaseChange.NO_CHANGE, bl, glossariesSty);
    }

    public AcrFullFmt(String string, CaseChange caseChange, GlossariesSty glossariesSty) {
        this(string, caseChange, false, glossariesSty);
    }

    public AcrFullFmt(String string, CaseChange caseChange, boolean bl, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.caseChange = caseChange;
        this.isPlural = bl;
    }

    @Override
    public Object clone() {
        return new AcrFullFmt(this.getName(), this.getCaseChange(), this.isPlural(), this.getSty());
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        KeyValList keyValList = this.popKeyValList(teXParser, teXObjectList);
        if (keyValList == null) {
            keyValList = new KeyValList();
        }
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        if (glossaryEntry == null) {
            this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
        } else {
            TeXObjectList teXObjectList2;
            Group group;
            Group group2 = group = laTeXParserListener.createGroup();
            switch (this.caseChange) {
                case SENTENCE: {
                    if (this.isPlural) {
                        group.add(laTeXParserListener.getControlSequence("Genplacrfullformat"));
                        break;
                    }
                    group.add(laTeXParserListener.getControlSequence("Genacrfullformat"));
                    break;
                }
                case TO_UPPER: {
                    group.add(laTeXParserListener.getControlSequence("mfirstucMakeUppercase"));
                    teXObjectList2 = laTeXParserListener.createGroup();
                    group.add(teXObjectList2);
                    group = teXObjectList2;
                }
                default: {
                    if (this.isPlural) {
                        group.add(laTeXParserListener.getControlSequence("genplacrfullformat"));
                        break;
                    }
                    group.add(laTeXParserListener.getControlSequence("genacrfullformat"));
                }
            }
            group.add(glsLabel);
            group.add(teXObject);
            teXObjectList2 = laTeXParserListener.createStack();
            teXObjectList2.add(laTeXParserListener.getControlSequence("glslink"));
            teXObjectList2.add(keyValList);
            teXObjectList2.add(glsLabel);
            teXObjectList2.add(group2);
            TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public boolean isPlural() {
        return this.isPlural;
    }

    public CaseChange getCaseChange() {
        return this.caseChange;
    }
}

