/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.data.loading;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.Util;
import net.minecraft.client.ClientBootstrap;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.server.Bootstrap;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModWorkManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatagenModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ExistingFileHelper existingFileHelper;
    private static boolean runningDataGen;
    private final OptionParser parser;
    private final OptionSpec<Void> client;
    private final OptionSpec<String> existing;
    private final OptionSpec<String> existingMod;
    private final OptionSpec<String> mod;
    private final OptionSpec<String> assetIndex;
    private final OptionSpec<File> gameDir;
    private final OptionSpec<File> assetsDir;
    private final OptionSpec<Void> flat;

    public static boolean isRunningDataGen() {
        return runningDataGen;
    }

    public static DatagenModLoader setup(OptionParser parser, boolean client) {
        return new DatagenModLoader(parser, client);
    }

    private DatagenModLoader(OptionParser parser, boolean client) {
        this.gameDir = parser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]).required();
        this.parser = parser;
        this.client = !client ? null : parser.accepts("client", "Include client generators");
        this.existing = parser.accepts("existing", "Existing resource packs that generated resources can reference").withRequiredArg();
        this.existingMod = parser.accepts("existing-mod", "Existing mods that generated resources can reference the resource packs of").withRequiredArg();
        this.mod = parser.accepts("mod", "A modid to dump").withRequiredArg().withValuesSeparatedBy(",");
        this.flat = parser.accepts("flat", "Do not append modid prefix to output directory when generating for multiple mods");
        this.assetIndex = parser.accepts("assetIndex").withRequiredArg();
        this.assetsDir = parser.accepts("assetsDir").withRequiredArg().ofType(File.class);
    }

    public boolean hasArgs(OptionSet options) {
        return options.specs().size() != 1 || !options.has(this.gameDir);
    }

    public boolean run(OptionSet options, Path output, Collection<Path> inputs, boolean genServer, boolean genClient, boolean genDev, boolean genReports, boolean validate) {
        List<Path> existingPacks = options.valuesOf(this.existing).stream().map(x$0 -> Paths.get(x$0, new String[0])).toList();
        HashSet<String> existingMods = new HashSet<String>(options.valuesOf(this.existingMod));
        HashSet patterns = new HashSet(options.valuesOf(this.mod));
        boolean flat = patterns.isEmpty() || options.has(this.flat);
        String assetIndex = (String)options.valueOf(this.assetIndex);
        File assetsDir = (File)options.valueOf(this.assetsDir);
        if (patterns.contains("minecraft") && patterns.size() == 1) {
            return true;
        }
        if (!genClient && this.client != null) {
            genClient = options.has(this.client);
        }
        runningDataGen = true;
        Bootstrap.bootStrap();
        if (genClient) {
            ClientBootstrap.bootstrap();
        }
        ModLoader.get().gatherAndInitializeMods(ModWorkManager.syncExecutor(), ModWorkManager.parallelExecutor(), () -> {});
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, (Executor)Util.backgroundExecutor());
        HashSet<String> mods = new HashSet<String>();
        for (String pattern : patterns) {
            if (pattern.indexOf(46) == -1) {
                mods.add(pattern);
            }
            Pattern m = Pattern.compile("^" + pattern + "$");
            ModList.get().forEachModInOrder(mc -> {
                String id = mc.getModId();
                if (!"forge".equals(id) && !"minecraft".equals(id) && m.matcher(id).matches()) {
                    mods.add(id);
                }
            });
        }
        LOGGER.info("Initializing Data Gatherer for mods {}", mods);
        GatherDataEvent.DataGeneratorConfig config = new GatherDataEvent.DataGeneratorConfig(mods, output, inputs, lookupProvider, genServer, genClient, genDev, genReports, validate, flat);
        if (!mods.contains("forge")) {
            existingMods.add("forge");
        }
        existingFileHelper = new ExistingFileHelper(existingPacks, existingMods, validate, assetIndex, assetsDir);
        ModLoader.get().runEventGenerator(mc -> new GatherDataEvent((ModContainer)mc, config.makeGenerator(p -> config.isFlat() ? p : p.resolve(mc.getModId()), config.getMods().contains(mc.getModId())), config, existingFileHelper));
        config.runAll();
        return false;
    }
}

