/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class ScreenEffectRenderer {
    private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/underwater.png");
    private final Minecraft minecraft;
    private final MaterialSet materials;
    private final MultiBufferSource bufferSource;
    public static final int ITEM_ACTIVATION_ANIMATION_LENGTH = 40;
    @Nullable
    private ItemStack itemActivationItem;
    private int itemActivationTicks;
    private float itemActivationOffX;
    private float itemActivationOffY;

    public ScreenEffectRenderer(Minecraft p_408767_, MaterialSet p_428240_, MultiBufferSource p_405885_) {
        this.minecraft = p_408767_;
        this.materials = p_428240_;
        this.bufferSource = p_405885_;
    }

    public void tick() {
        if (this.itemActivationTicks > 0) {
            --this.itemActivationTicks;
            if (this.itemActivationTicks == 0) {
                this.itemActivationItem = null;
            }
        }
    }

    public void renderScreenEffect(boolean p_409640_, float p_408951_, SubmitNodeCollector p_429619_) {
        PoseStack posestack = new PoseStack();
        LocalPlayer player = this.minecraft.player;
        if (this.minecraft.options.getCameraType().isFirstPerson() && !p_409640_) {
            if (!player.noPhysics) {
                BlockState blockstate;
                Pair<BlockState, BlockPos> overlay = ScreenEffectRenderer.getOverlayBlock(player);
                BlockState blockState = blockstate = overlay == null ? null : (BlockState)overlay.getLeft();
                if (blockstate != null && !ForgeHooksClient.renderBlockOverlay((Player)player, (PoseStack)posestack, (RenderBlockScreenEffectEvent.OverlayType)RenderBlockScreenEffectEvent.OverlayType.BLOCK, (BlockState)((BlockState)overlay.getLeft()), (BlockPos)((BlockPos)overlay.getRight()))) {
                    ScreenEffectRenderer.renderTex(this.minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(blockstate), posestack, this.bufferSource);
                }
            }
            if (!this.minecraft.player.isSpectator()) {
                if (this.minecraft.player.isEyeInFluid(FluidTags.WATER)) {
                    if (!ForgeHooksClient.renderWaterOverlay((Player)player, (PoseStack)posestack)) {
                        ScreenEffectRenderer.renderWater(this.minecraft, posestack, this.bufferSource);
                    }
                } else if (!player.getEyeInFluidType().isAir()) {
                    IClientFluidTypeExtensions.of((FluidType)player.getEyeInFluidType()).renderOverlay(this.minecraft, posestack, this.bufferSource);
                }
                if (this.minecraft.player.isOnFire()) {
                    TextureAtlasSprite textureatlassprite = this.materials.get(ModelBakery.FIRE_1);
                    if (!ForgeHooksClient.renderFireOverlay((Player)player, (PoseStack)posestack)) {
                        ScreenEffectRenderer.renderFire(posestack, this.bufferSource, textureatlassprite);
                    }
                }
            }
        }
        if (!this.minecraft.options.hideGui) {
            this.renderItemActivationAnimation(posestack, p_408951_, p_429619_);
        }
    }

    private void renderItemActivationAnimation(PoseStack p_408146_, float p_408750_, SubmitNodeCollector p_425832_) {
        if (this.itemActivationItem != null && this.itemActivationTicks > 0) {
            int i = 40 - this.itemActivationTicks;
            float f = ((float)i + p_408750_) / 40.0f;
            float f1 = f * f;
            float f2 = f * f1;
            float f3 = 10.25f * f2 * f1 - 24.95f * f1 * f1 + 25.5f * f2 - 13.8f * f1 + 4.0f * f;
            float f4 = f3 * (float)Math.PI;
            float f5 = (float)this.minecraft.getWindow().getWidth() / (float)this.minecraft.getWindow().getHeight();
            float f6 = this.itemActivationOffX * 0.3f * f5;
            float f7 = this.itemActivationOffY * 0.3f;
            p_408146_.pushPose();
            p_408146_.translate(f6 * Mth.abs(Mth.sin(f4 * 2.0f)), f7 * Mth.abs(Mth.sin(f4 * 2.0f)), -10.0f + 9.0f * Mth.sin(f4));
            float f8 = 0.8f;
            p_408146_.scale(0.8f, 0.8f, 0.8f);
            p_408146_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(900.0f * Mth.abs(Mth.sin(f4))));
            p_408146_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(6.0f * Mth.cos(f * 8.0f)));
            p_408146_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(6.0f * Mth.cos(f * 8.0f)));
            this.minecraft.gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
            ItemStackRenderState itemstackrenderstate = new ItemStackRenderState();
            this.minecraft.getItemModelResolver().updateForTopItem(itemstackrenderstate, this.itemActivationItem, ItemDisplayContext.FIXED, (Level)this.minecraft.level, null, 0);
            itemstackrenderstate.submit(p_408146_, p_425832_, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
            p_408146_.popPose();
        }
    }

    public void resetItemActivation() {
        this.itemActivationItem = null;
    }

    public void displayItemActivation(ItemStack p_407673_, RandomSource p_406761_) {
        this.itemActivationItem = p_407673_;
        this.itemActivationTicks = 40;
        this.itemActivationOffX = p_406761_.nextFloat() * 2.0f - 1.0f;
        this.itemActivationOffY = p_406761_.nextFloat() * 2.0f - 1.0f;
    }

    @Nullable
    private static BlockState getViewBlockingState(Player p_110717_) {
        Pair<BlockState, BlockPos> ret = ScreenEffectRenderer.getOverlayBlock(p_110717_);
        return ret == null ? null : (BlockState)ret.getLeft();
    }

    @Nullable
    private static Pair<BlockState, BlockPos> getOverlayBlock(Player p_110717_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d0 = p_110717_.getX() + (double)(((float)((i >> 0) % 2) - 0.5f) * p_110717_.getBbWidth() * 0.8f);
            double d1 = p_110717_.getEyeY() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f * p_110717_.getScale());
            double d2 = p_110717_.getZ() + (double)(((float)((i >> 2) % 2) - 0.5f) * p_110717_.getBbWidth() * 0.8f);
            blockpos$mutableblockpos.set(d0, d1, d2);
            BlockState blockstate = p_110717_.level().getBlockState(blockpos$mutableblockpos);
            if (blockstate.getRenderShape() == RenderShape.INVISIBLE || !blockstate.isViewBlocking(p_110717_.level(), blockpos$mutableblockpos)) continue;
            return Pair.of((Object)blockstate, (Object)blockpos$mutableblockpos.immutable());
        }
        return null;
    }

    private static void renderTex(TextureAtlasSprite p_173297_, PoseStack p_173298_, MultiBufferSource p_376984_) {
        float f = 0.1f;
        int i = ARGB.colorFromFloat(1.0f, 0.1f, 0.1f, 0.1f);
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = p_173297_.getU0();
        float f7 = p_173297_.getU1();
        float f8 = p_173297_.getV0();
        float f9 = p_173297_.getV1();
        Matrix4f matrix4f = p_173298_.last().pose();
        VertexConsumer vertexconsumer = p_376984_.getBuffer(RenderType.blockScreenEffect(p_173297_.atlasLocation()));
        vertexconsumer.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(f7, f9).setColor(i);
        vertexconsumer.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(f6, f9).setColor(i);
        vertexconsumer.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(f6, f8).setColor(i);
        vertexconsumer.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(f7, f8).setColor(i);
    }

    private static void renderWater(Minecraft p_110726_, PoseStack p_110727_, MultiBufferSource p_376402_) {
        ScreenEffectRenderer.renderFluid(p_110726_, p_110727_, p_376402_, UNDERWATER_LOCATION);
    }

    public static void renderFluid(Minecraft p_110726_, PoseStack p_110727_, MultiBufferSource p_376402_, ResourceLocation texture) {
        BlockPos blockpos = BlockPos.containing(p_110726_.player.getX(), p_110726_.player.getEyeY(), p_110726_.player.getZ());
        float f = LightTexture.getBrightness(p_110726_.player.level().dimensionType(), p_110726_.player.level().getMaxLocalRawBrightness(blockpos));
        int i = ARGB.colorFromFloat(0.1f, f, f, f);
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -p_110726_.player.getYRot() / 64.0f;
        float f8 = p_110726_.player.getXRot() / 64.0f;
        Matrix4f matrix4f = p_110727_.last().pose();
        VertexConsumer vertexconsumer = p_376402_.getBuffer(RenderType.blockScreenEffect(texture));
        vertexconsumer.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(4.0f + f7, 4.0f + f8).setColor(i);
        vertexconsumer.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(0.0f + f7, 4.0f + f8).setColor(i);
        vertexconsumer.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(0.0f + f7, 0.0f + f8).setColor(i);
        vertexconsumer.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(4.0f + f7, 0.0f + f8).setColor(i);
    }

    private static void renderFire(PoseStack p_110730_, MultiBufferSource p_376973_, TextureAtlasSprite p_422518_) {
        VertexConsumer vertexconsumer = p_376973_.getBuffer(RenderType.fireScreenEffect(p_422518_.atlasLocation()));
        float f = p_422518_.getU0();
        float f1 = p_422518_.getU1();
        float f2 = (f + f1) / 2.0f;
        float f3 = p_422518_.getV0();
        float f4 = p_422518_.getV1();
        float f5 = (f3 + f4) / 2.0f;
        float f6 = p_422518_.uvShrinkRatio();
        float f7 = Mth.lerp(f6, f, f2);
        float f8 = Mth.lerp(f6, f1, f2);
        float f9 = Mth.lerp(f6, f3, f5);
        float f10 = Mth.lerp(f6, f4, f5);
        float f11 = 1.0f;
        for (int i = 0; i < 2; ++i) {
            p_110730_.pushPose();
            float f12 = -0.5f;
            float f13 = 0.5f;
            float f14 = -0.5f;
            float f15 = 0.5f;
            float f16 = -0.5f;
            p_110730_.translate((float)(-(i * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            p_110730_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(i * 2 - 1) * 10.0f));
            Matrix4f matrix4f = p_110730_.last().pose();
            vertexconsumer.addVertex(matrix4f, -0.5f, -0.5f, -0.5f).setUv(f8, f10).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            vertexconsumer.addVertex(matrix4f, 0.5f, -0.5f, -0.5f).setUv(f7, f10).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            vertexconsumer.addVertex(matrix4f, 0.5f, 0.5f, -0.5f).setUv(f7, f9).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            vertexconsumer.addVertex(matrix4f, -0.5f, 0.5f, -0.5f).setUv(f8, f9).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            p_110730_.popPose();
        }
    }
}

