/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.gui.widget.ModListWidget;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.common.util.Size2i;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.slf4j.Logger;

public class ModListScreen
extends Screen {
    private static final ResourceLocation LOGO = ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"mod_logo");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PADDING = 6;
    private static final int BUTTON_MARGIN = 1;
    private static final int NUM_BUTTONS = SortType.values().length;
    private static final int BUTTON_HEIGHT = 20;
    private final Screen parentScreen;
    private ModListWidget modList;
    private InfoPanel modInfo;
    private ModListWidget.ModEntry selected = null;
    private int listWidth;
    private List<IModInfo> mods;
    private final List<IModInfo> unsortedMods;
    private Button configButton;
    private Button openModsFolderButton;
    private Button doneButton;
    private String lastFilterText = "";
    private StringWidget searchText;
    private EditBox search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;
    private static final Logo NONE = new Logo(null, new Size2i(0, 0));

    private static String stripControlCodes(String value) {
        return StringUtil.stripColor((String)value);
    }

    public ModListScreen(Screen parentScreen) {
        super((Component)Component.translatable((String)"fml.menu.mods.title"));
        this.parentScreen = parentScreen;
        this.mods = ModList.get().getMods();
        this.unsortedMods = List.copyOf(this.mods);
    }

    public void init() {
        Font font = this.getFontRenderer();
        for (IModInfo mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, font.width(mod.getDisplayName()) + 10);
            this.listWidth = Math.max(this.listWidth, font.width(MavenVersionStringHelper.artifactVersionToString(mod.getVersion())) + 5);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.width / 3), 100);
        this.listWidth += this.listWidth % NUM_BUTTONS != 0 ? NUM_BUTTONS - this.listWidth % NUM_BUTTONS : 0;
        int fullButtonHeight = 32;
        int modInfoWidth = this.width - this.listWidth - 18;
        int doneButtonWidth = Math.min(modInfoWidth, 200);
        int y = this.height - 20 - 6;
        this.doneButton = Button.builder((Component)Component.translatable((String)"gui.done"), b -> this.onClose()).bounds((this.listWidth + 6 + this.width - doneButtonWidth) / 2, y, doneButtonWidth, 20).build();
        this.openModsFolderButton = Button.builder((Component)Component.translatable((String)"fml.menu.mods.openmodsfolder"), b -> Util.getPlatform().openFile(FMLPaths.MODSDIR.get().toFile())).bounds(6, y, this.listWidth, 20).build();
        this.configButton = Button.builder((Component)Component.translatable((String)"fml.menu.mods.config"), b -> this.displayModConfig()).bounds(6, y -= 26, this.listWidth, 20).build();
        this.search = new EditBox(this.getFontRenderer(), 7, y -= 20, this.listWidth - 2, 14, (Component)Component.translatable((String)"fml.menu.mods.search"));
        Objects.requireNonNull(font);
        int width = font.width(this.search.getMessage().getVisualOrderText());
        int n = this.search.getX() + this.search.getWidth() / 2 - width / 2;
        Objects.requireNonNull(font);
        this.searchText = new StringWidget(n, y -= 9, width, 9, this.search.getMessage(), font);
        int height = y - 32 - 6;
        this.modList = new ModListWidget(this, this.listWidth, 32, height);
        this.modList.setX(6);
        this.modInfo = new InfoPanel(this.minecraft, modInfoWidth, this.height - 6 - 32, 6);
        this.addRenderableWidget((GuiEventListener)this.modList);
        this.addRenderableWidget((GuiEventListener)this.modInfo);
        this.addRenderableWidget((GuiEventListener)this.searchText);
        this.addRenderableWidget((GuiEventListener)this.search);
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.addRenderableWidget((GuiEventListener)this.configButton);
        this.addRenderableWidget((GuiEventListener)this.openModsFolderButton);
        this.search.setFocused(false);
        this.search.setCanLoseFocus(true);
        this.configButton.active = false;
        width = this.listWidth / NUM_BUTTONS;
        int x = 6;
        SortType.NORMAL.button = Button.builder((Component)SortType.NORMAL.getButtonText(), b -> this.resortMods(SortType.NORMAL)).bounds(x, 6, width - 1, 20).build();
        this.addRenderableWidget((GuiEventListener)SortType.NORMAL.button);
        SortType.A_TO_Z.button = Button.builder((Component)SortType.A_TO_Z.getButtonText(), b -> this.resortMods(SortType.A_TO_Z)).bounds(x += width + 1, 6, width - 1, 20).build();
        this.addRenderableWidget((GuiEventListener)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = Button.builder((Component)SortType.Z_TO_A.getButtonText(), b -> this.resortMods(SortType.Z_TO_A)).bounds(x += width + 1, 6, width - 1, 20).build();
        this.addRenderableWidget((GuiEventListener)SortType.Z_TO_A.button);
        this.resortMods(SortType.NORMAL);
        this.updateCache();
    }

    private void displayModConfig() {
        if (this.selected == null) {
            return;
        }
        try {
            ConfigScreenHandler.getScreenFactoryFor(this.selected.getInfo()).map(f -> (Screen)f.apply(this.minecraft, this)).ifPresent(newScreen -> this.minecraft.setScreen(newScreen));
        }
        catch (Exception e) {
            LOGGER.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selected.getInfo().getModId(), (Object)e);
        }
    }

    public void tick() {
        this.modList.setSelected((AbstractSelectionList.Entry)this.selected);
        if (!this.search.getValue().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            this.mods.sort(this.sortType);
            this.modList.refreshList();
            if (this.selected != null) {
                this.selected = this.modList.children().stream().filter(e -> e.getInfo() == this.selected.getInfo()).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildModList(Consumer<T> modListViewConsumer, Function<IModInfo, T> newEntry) {
        for (IModInfo mod : this.mods) {
            modListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply(mod));
        }
    }

    private void reloadMods() {
        this.mods = this.unsortedMods.stream().filter(mi -> StringUtils.toLowerCase((String)ModListScreen.stripControlCodes(mi.getDisplayName())).contains(StringUtils.toLowerCase((String)this.search.getValue()))).collect(Collectors.toList());
        this.lastFilterText = this.search.getValue();
    }

    private void resortMods(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.active = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.modInfo != null) {
            this.modInfo.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public Minecraft getMinecraftInstance() {
        return this.minecraft;
    }

    public Font getFontRenderer() {
        return this.font;
    }

    public void setSelected(ModListWidget.ModEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        if (this.selected == null) {
            this.configButton.active = false;
            this.modInfo.clearInfo();
            return;
        }
        IModInfo selectedMod = this.selected.getInfo();
        this.configButton.active = ConfigScreenHandler.getScreenFactoryFor(selectedMod).isPresent();
        ArrayList<String> lines = new ArrayList<String>();
        VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)selectedMod);
        Logo logoData = NONE;
        String logoFile = selectedMod.getLogoFile().orElse(null);
        if (logoFile != null) {
            TextureManager tm = this.minecraft.getTextureManager();
            try {
                Path path;
                NativeImage logo = null;
                IModFileInfo modfile = ModList.get().getModFileById(selectedMod.getModId());
                if (modfile != null && Files.exists(path = modfile.getFile().findResource(new String[]{logoFile}), new LinkOption[0])) {
                    logo = NativeImage.read((InputStream)Files.newInputStream(path, new OpenOption[0]));
                }
                if (logo != null) {
                    DynamicTexture texture = new DynamicTexture(() -> logoFile, logo);
                    tm.register(LOGO, (AbstractTexture)texture);
                    Size2i size = new Size2i(logo.getWidth(), logo.getHeight());
                    logoData = new Logo(LOGO, size);
                }
            }
            catch (IOException logo) {
                // empty catch block
            }
        }
        lines.add(selectedMod.getDisplayName());
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.version", MavenVersionStringHelper.artifactVersionToString(selectedMod.getVersion())));
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.idstate", selectedMod.getModId(), ModList.get().getModContainerById(selectedMod.getModId()).map(ModContainer::getCurrentState).map(Object::toString).orElse("NONE")));
        selectedMod.getConfig().getConfigElement("credits").ifPresent(credits -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.credits", credits)));
        selectedMod.getConfig().getConfigElement("authors").ifPresent(authors -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.authors", authors)));
        selectedMod.getConfig().getConfigElement("displayURL").ifPresent(displayURL -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.displayurl", displayURL)));
        if (selectedMod.getOwningFile() == null || selectedMod.getOwningFile().getMods().size() == 1) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.nochildmods", new Object[0]));
        } else {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.childmods", selectedMod.getOwningFile().getMods().stream().map(IModInfo::getDisplayName).collect(Collectors.joining(","))));
        }
        if (vercheck.status().isOutdated()) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.updateavailable", vercheck.url() == null ? "" : vercheck.url()));
        }
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.license", ((ModFileInfo)selectedMod.getOwningFile()).getLicense()));
        lines.add(null);
        lines.add(selectedMod.getDescription());
        if (vercheck.status().isOutdated() && !vercheck.changes().isEmpty()) {
            lines.add(null);
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.changelogheader", new Object[0]));
            for (Map.Entry entry : vercheck.changes().entrySet()) {
                lines.add("  " + String.valueOf(entry.getKey()) + ":");
                lines.add((String)entry.getValue());
                lines.add(null);
            }
        }
        this.modInfo.setInfo(lines, logoData.texture(), logoData.size());
    }

    public void resize(Minecraft mc, int width, int height) {
        String s = this.search.getValue();
        SortType sort = this.sortType;
        ModListWidget.ModEntry selected = this.selected;
        this.init(mc, width, height);
        this.search.setValue(s);
        this.selected = selected;
        if (!this.search.getValue().isEmpty()) {
            this.reloadMods();
        }
        if (sort != SortType.NORMAL) {
            this.resortMods(sort);
        }
        this.updateCache();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    protected void handleClickEvent(Minecraft mc, ClickEvent event) {
        if (mc.player == null) {
            ModListScreen.defaultHandleClickEvent((ClickEvent)event, (Minecraft)mc, (Screen)this);
        } else {
            ModListScreen.defaultHandleGameClickEvent((ClickEvent)event, (Minecraft)mc, (Screen)this);
        }
    }

    private static enum SortType implements Comparator<IModInfo>
    {
        NORMAL,
        A_TO_Z{

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A{

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        Button button;

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(IModInfo o1, IModInfo o2) {
            String name1 = StringUtils.toLowerCase((String)ModListScreen.stripControlCodes(o1.getDisplayName()));
            String name2 = StringUtils.toLowerCase((String)ModListScreen.stripControlCodes(o2.getDisplayName()));
            return this.compare(name1, name2);
        }

        Component getButtonText() {
            return Component.translatable((String)("fml.menu.mods." + StringUtils.toLowerCase((String)this.name())));
        }
    }

    class InfoPanel
    extends ScrollPanel {
        private ResourceLocation logoPath;
        private Size2i logoDims;
        private List<FormattedCharSequence> lines;

        InfoPanel(Minecraft mcIn, int widthIn, int heightIn, int topIn) {
            super(mcIn, widthIn, heightIn, topIn, ModListScreen.this.modList.getRight() + 6);
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        void setInfo(List<String> lines, ResourceLocation logoPath, Size2i logoDims) {
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.lines = this.resizeContent(lines);
        }

        void clearInfo() {
            this.logoPath = null;
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        private List<FormattedCharSequence> resizeContent(List<String> lines) {
            ArrayList<FormattedCharSequence> ret = new ArrayList<FormattedCharSequence>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                Component chat = ForgeHooks.newChatWithLinks(line, false);
                int maxTextLength = this.width - 12;
                if (maxTextLength < 0) continue;
                ret.addAll(Language.getInstance().getVisualOrder(ModListScreen.this.font.getSplitter().splitLines((FormattedText)chat, maxTextLength, Style.EMPTY)));
            }
            return ret;
        }

        @Override
        public int getContentHeight() {
            int height = 50;
            int n = this.lines.size();
            Objects.requireNonNull(ModListScreen.this.font);
            if ((height += n * 9) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        protected int getScrollAmount() {
            Objects.requireNonNull(ModListScreen.this.font);
            return 9 * 3;
        }

        @Override
        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, int mouseX, int mouseY) {
            if (this.logoPath != null) {
                int headerHeight = 50;
                guiGraphics.blitInscribed(this.logoPath, this.left + 6, relativeY, this.width - 12, headerHeight, this.logoDims.width(), this.logoDims.height(), false, true);
                relativeY += headerHeight + 6;
            }
            for (FormattedCharSequence line : this.lines) {
                if (line != null) {
                    guiGraphics.drawString(ModListScreen.this.font, line, this.left + 6, relativeY, ARGB.white((float)1.0f));
                }
                Objects.requireNonNull(ModListScreen.this.font);
                relativeY += 9;
            }
            Style component = this.findTextLine(mouseX, mouseY);
            if (component != null) {
                guiGraphics.renderComponentHoverEffect(ModListScreen.this.font, component, mouseX, mouseY);
            }
        }

        private Style findTextLine(int mouseX, int mouseY) {
            if (!this.isMouseOver(mouseX, mouseY)) {
                return null;
            }
            double offset = (float)(mouseY - this.top - 6 - this.border) + this.scrollDistance;
            if (this.logoPath != null) {
                offset -= 50.0;
            }
            if (offset <= 0.0) {
                return null;
            }
            Objects.requireNonNull(ModListScreen.this.font);
            int lineIdx = (int)(offset / 9.0);
            if (lineIdx >= this.lines.size() || lineIdx < 0) {
                return null;
            }
            FormattedCharSequence line = this.lines.get(lineIdx);
            if (line != null) {
                return ModListScreen.this.font.getSplitter().componentStyleAtWidth(line, mouseX - this.left - this.border);
            }
            return null;
        }

        @Override
        public boolean mouseClicked(MouseButtonEvent info, boolean recent) {
            Style component = this.findTextLine((int)info.x(), (int)info.y());
            if (component != null) {
                ModListScreen.this.handleComponentClicked(component);
                return true;
            }
            return super.mouseClicked(info, recent);
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput p_169152_) {
        }
    }

    record Logo(ResourceLocation texture, Size2i size) {
    }
}

