// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"errors"
	"sync"

	"go.opentelemetry.io/otel/metric"
	"go.opentelemetry.io/otel/trace"

	"go.opentelemetry.io/collector/component"
)

func Meter(settings component.TelemetrySettings) metric.Meter {
	return settings.MeterProvider.Meter("github.com/open-telemetry/opentelemetry-collector-contrib/receiver/kafkareceiver")
}

func Tracer(settings component.TelemetrySettings) trace.Tracer {
	return settings.TracerProvider.Tracer("github.com/open-telemetry/opentelemetry-collector-contrib/receiver/kafkareceiver")
}

// TelemetryBuilder provides an interface for components to report telemetry
// as defined in metadata and user config.
type TelemetryBuilder struct {
	meter                                    metric.Meter
	mu                                       sync.Mutex
	registrations                            []metric.Registration
	KafkaBrokerClosed                        metric.Int64Counter
	KafkaBrokerConnects                      metric.Int64Counter
	KafkaBrokerThrottlingDuration            metric.Int64Histogram
	KafkaBrokerThrottlingLatency             metric.Float64Histogram
	KafkaReceiverBytes                       metric.Int64Counter
	KafkaReceiverBytesUncompressed           metric.Int64Counter
	KafkaReceiverCurrentOffset               metric.Int64Gauge
	KafkaReceiverLatency                     metric.Int64Histogram
	KafkaReceiverMessages                    metric.Int64Counter
	KafkaReceiverOffsetLag                   metric.Int64Gauge
	KafkaReceiverPartitionClose              metric.Int64Counter
	KafkaReceiverPartitionStart              metric.Int64Counter
	KafkaReceiverReadLatency                 metric.Float64Histogram
	KafkaReceiverRecords                     metric.Int64Counter
	KafkaReceiverRecordsDelay                metric.Float64Histogram
	KafkaReceiverUnmarshalFailedLogRecords   metric.Int64Counter
	KafkaReceiverUnmarshalFailedMetricPoints metric.Int64Counter
	KafkaReceiverUnmarshalFailedProfiles     metric.Int64Counter
	KafkaReceiverUnmarshalFailedSpans        metric.Int64Counter
}

// TelemetryBuilderOption applies changes to default builder.
type TelemetryBuilderOption interface {
	apply(*TelemetryBuilder)
}

type telemetryBuilderOptionFunc func(mb *TelemetryBuilder)

func (tbof telemetryBuilderOptionFunc) apply(mb *TelemetryBuilder) {
	tbof(mb)
}

// Shutdown unregister all registered callbacks for async instruments.
func (builder *TelemetryBuilder) Shutdown() {
	builder.mu.Lock()
	defer builder.mu.Unlock()
	for _, reg := range builder.registrations {
		reg.Unregister()
	}
}

// NewTelemetryBuilder provides a struct with methods to update all internal telemetry
// for a component
func NewTelemetryBuilder(settings component.TelemetrySettings, options ...TelemetryBuilderOption) (*TelemetryBuilder, error) {
	builder := TelemetryBuilder{}
	for _, op := range options {
		op.apply(&builder)
	}
	builder.meter = Meter(settings)
	var err, errs error
	builder.KafkaBrokerClosed, err = builder.meter.Int64Counter(
		"otelcol_kafka_broker_closed",
		metric.WithDescription("The total number of connections closed. [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaBrokerConnects, err = builder.meter.Int64Counter(
		"otelcol_kafka_broker_connects",
		metric.WithDescription("The total number of connections opened. [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaBrokerThrottlingDuration, err = builder.meter.Int64Histogram(
		"otelcol_kafka_broker_throttling_duration",
		metric.WithDescription("The throttling duration in ms imposed by the broker when receiving messages. [Deprecated]"),
		metric.WithUnit("ms"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaBrokerThrottlingLatency, err = builder.meter.Float64Histogram(
		"otelcol_kafka_broker_throttling_latency",
		metric.WithDescription("The throttling latency in seconds imposed by the broker when receiving records. [Development]"),
		metric.WithUnit("s"),
		metric.WithExplicitBucketBoundaries([]float64{0, 0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1, 2.5, 5, 7.5, 10, 25, 50, 75, 100}...),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverBytes, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_bytes",
		metric.WithDescription("The size in bytes of received records seen by the broker. [Development]"),
		metric.WithUnit("By"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverBytesUncompressed, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_bytes_uncompressed",
		metric.WithDescription("The uncompressed size in bytes of received records seen by the client. [Development]"),
		metric.WithUnit("By"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverCurrentOffset, err = builder.meter.Int64Gauge(
		"otelcol_kafka_receiver_current_offset",
		metric.WithDescription("Current message offset [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverLatency, err = builder.meter.Int64Histogram(
		"otelcol_kafka_receiver_latency",
		metric.WithDescription("The time it took in ms to receive a batch of messages. [Deprecated]"),
		metric.WithUnit("ms"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverMessages, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_messages",
		metric.WithDescription("The number of received messages. [Deprecated]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverOffsetLag, err = builder.meter.Int64Gauge(
		"otelcol_kafka_receiver_offset_lag",
		metric.WithDescription("Current offset lag [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverPartitionClose, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_partition_close",
		metric.WithDescription("Number of finished partitions [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverPartitionStart, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_partition_start",
		metric.WithDescription("Number of started partitions [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverReadLatency, err = builder.meter.Float64Histogram(
		"otelcol_kafka_receiver_read_latency",
		metric.WithDescription("The time it took in seconds to receive a batch of records. [Development]"),
		metric.WithUnit("s"),
		metric.WithExplicitBucketBoundaries([]float64{0, 0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1, 2.5, 5, 7.5, 10, 25, 50, 75, 100}...),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverRecords, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_records",
		metric.WithDescription("The number of received records. [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverRecordsDelay, err = builder.meter.Float64Histogram(
		"otelcol_kafka_receiver_records_delay",
		metric.WithDescription("The time in seconds between producing and receiving a batch of records. [Development]"),
		metric.WithUnit("s"),
		metric.WithExplicitBucketBoundaries([]float64{0, 0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1, 2.5, 5, 7.5, 10, 25, 50, 75, 100, 250, 500, 750, 1000, 2500, 5000, 7500, 10000}...),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverUnmarshalFailedLogRecords, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_unmarshal_failed_log_records",
		metric.WithDescription("Number of log records failed to be unmarshaled [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverUnmarshalFailedMetricPoints, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_unmarshal_failed_metric_points",
		metric.WithDescription("Number of metric points failed to be unmarshaled [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverUnmarshalFailedProfiles, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_unmarshal_failed_profiles",
		metric.WithDescription("Number of profiles failed to be unmarshaled [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.KafkaReceiverUnmarshalFailedSpans, err = builder.meter.Int64Counter(
		"otelcol_kafka_receiver_unmarshal_failed_spans",
		metric.WithDescription("Number of spans failed to be unmarshaled [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	return &builder, errs
}
