// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// ConfigResourceConditionApplyConfiguration represents a declarative configuration of the ConfigResourceCondition type for use
// with apply.
type ConfigResourceConditionApplyConfiguration struct {
	Type               *monitoringv1.ConditionType   `json:"type,omitempty"`
	Status             *monitoringv1.ConditionStatus `json:"status,omitempty"`
	LastTransitionTime *metav1.Time                  `json:"lastTransitionTime,omitempty"`
	Reason             *string                       `json:"reason,omitempty"`
	Message            *string                       `json:"message,omitempty"`
	ObservedGeneration *int64                        `json:"observedGeneration,omitempty"`
}

// ConfigResourceConditionApplyConfiguration constructs a declarative configuration of the ConfigResourceCondition type for use with
// apply.
func ConfigResourceCondition() *ConfigResourceConditionApplyConfiguration {
	return &ConfigResourceConditionApplyConfiguration{}
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *ConfigResourceConditionApplyConfiguration) WithType(value monitoringv1.ConditionType) *ConfigResourceConditionApplyConfiguration {
	b.Type = &value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *ConfigResourceConditionApplyConfiguration) WithStatus(value monitoringv1.ConditionStatus) *ConfigResourceConditionApplyConfiguration {
	b.Status = &value
	return b
}

// WithLastTransitionTime sets the LastTransitionTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LastTransitionTime field is set to the value of the last call.
func (b *ConfigResourceConditionApplyConfiguration) WithLastTransitionTime(value metav1.Time) *ConfigResourceConditionApplyConfiguration {
	b.LastTransitionTime = &value
	return b
}

// WithReason sets the Reason field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Reason field is set to the value of the last call.
func (b *ConfigResourceConditionApplyConfiguration) WithReason(value string) *ConfigResourceConditionApplyConfiguration {
	b.Reason = &value
	return b
}

// WithMessage sets the Message field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Message field is set to the value of the last call.
func (b *ConfigResourceConditionApplyConfiguration) WithMessage(value string) *ConfigResourceConditionApplyConfiguration {
	b.Message = &value
	return b
}

// WithObservedGeneration sets the ObservedGeneration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ObservedGeneration field is set to the value of the last call.
func (b *ConfigResourceConditionApplyConfiguration) WithObservedGeneration(value int64) *ConfigResourceConditionApplyConfiguration {
	b.ObservedGeneration = &value
	return b
}
