// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExportResponse represents the response for gRPC/HTTP client/server.
type ExportTraceServiceResponse struct {
	PartialSuccess ExportTracePartialSuccess
}

var (
	protoPoolExportTraceServiceResponse = sync.Pool{
		New: func() any {
			return &ExportTraceServiceResponse{}
		},
	}
)

func NewExportTraceServiceResponse() *ExportTraceServiceResponse {
	if !UseProtoPooling.IsEnabled() {
		return &ExportTraceServiceResponse{}
	}
	return protoPoolExportTraceServiceResponse.Get().(*ExportTraceServiceResponse)
}

func DeleteExportTraceServiceResponse(orig *ExportTraceServiceResponse, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteExportTracePartialSuccess(&orig.PartialSuccess, false)

	orig.Reset()
	if nullable {
		protoPoolExportTraceServiceResponse.Put(orig)
	}
}

func CopyExportTraceServiceResponse(dest, src *ExportTraceServiceResponse) *ExportTraceServiceResponse {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExportTraceServiceResponse()
	}
	CopyExportTracePartialSuccess(&dest.PartialSuccess, &src.PartialSuccess)

	return dest
}

func CopyExportTraceServiceResponseSlice(dest, src []ExportTraceServiceResponse) []ExportTraceServiceResponse {
	var newDest []ExportTraceServiceResponse
	if cap(dest) < len(src) {
		newDest = make([]ExportTraceServiceResponse, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportTraceServiceResponse(&dest[i], false)
		}
	}
	for i := range src {
		CopyExportTraceServiceResponse(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExportTraceServiceResponsePtrSlice(dest, src []*ExportTraceServiceResponse) []*ExportTraceServiceResponse {
	var newDest []*ExportTraceServiceResponse
	if cap(dest) < len(src) {
		newDest = make([]*ExportTraceServiceResponse, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportTraceServiceResponse()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportTraceServiceResponse(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportTraceServiceResponse()
		}
	}
	for i := range src {
		CopyExportTraceServiceResponse(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExportTraceServiceResponse) Reset() {
	*orig = ExportTraceServiceResponse{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExportTraceServiceResponse) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("partialSuccess")
	orig.PartialSuccess.MarshalJSON(dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExportTraceServiceResponse) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "partialSuccess", "partial_success":

			orig.PartialSuccess.UnmarshalJSON(iter)
		default:
			iter.Skip()
		}
	}
}

func (orig *ExportTraceServiceResponse) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.PartialSuccess.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func (orig *ExportTraceServiceResponse) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.PartialSuccess.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	return len(buf) - pos
}

func (orig *ExportTraceServiceResponse) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialSuccess", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.PartialSuccess.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExportTraceServiceResponse() *ExportTraceServiceResponse {
	orig := NewExportTraceServiceResponse()
	orig.PartialSuccess = *GenTestExportTracePartialSuccess()
	return orig
}

func GenTestExportTraceServiceResponsePtrSlice() []*ExportTraceServiceResponse {
	orig := make([]*ExportTraceServiceResponse, 5)
	orig[0] = NewExportTraceServiceResponse()
	orig[1] = GenTestExportTraceServiceResponse()
	orig[2] = NewExportTraceServiceResponse()
	orig[3] = GenTestExportTraceServiceResponse()
	orig[4] = NewExportTraceServiceResponse()
	return orig
}

func GenTestExportTraceServiceResponseSlice() []ExportTraceServiceResponse {
	orig := make([]ExportTraceServiceResponse, 5)
	orig[1] = *GenTestExportTraceServiceResponse()
	orig[3] = *GenTestExportTraceServiceResponse()
	return orig
}
