/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingleinfo;

import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.jingleinfo.JingleInfoQueryIQ;
import org.jitsi.xmpp.extensions.jingleinfo.RelayProvider;
import org.jitsi.xmpp.extensions.jingleinfo.ServerPacketExtension;
import org.jitsi.xmpp.extensions.jingleinfo.StunProvider;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;

public class JingleInfoQueryIQProvider
extends SafeParseIqProvider<JingleInfoQueryIQ> {
    private final StunProvider stunProvider = new StunProvider();
    private final RelayProvider relayProvider = new RelayProvider();

    public JingleInfoQueryIQProvider() {
        ProviderManager.addExtensionProvider((String)"server", (String)"google:jingleinfo", new DefaultPacketExtensionProvider<ServerPacketExtension>(ServerPacketExtension.class));
    }

    @Override
    protected JingleInfoQueryIQ doParse(XmlPullParser parser) throws Exception {
        boolean done = false;
        JingleInfoQueryIQ iq = new JingleInfoQueryIQ();
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            String elementName = parser.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (elementName.equals("stun")) {
                    iq.addExtension((ExtensionElement)this.stunProvider.parse(parser));
                } else if (elementName.equals("relay")) {
                    iq.addExtension((ExtensionElement)this.relayProvider.parse(parser));
                }
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("query")) continue;
            done = true;
        }
        return iq;
    }
}

