/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.StreamFeatureProviderInfo;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public class ProviderFileLoader
implements ProviderLoader {
    private static final Logger LOGGER = Logger.getLogger(ProviderFileLoader.class.getName());
    private final Collection<IQProviderInfo> iqProviders = new LinkedList<IQProviderInfo>();
    private final Collection<ExtensionProviderInfo> extProviders = new LinkedList<ExtensionProviderInfo>();
    private final Collection<StreamFeatureProviderInfo> sfProviders = new LinkedList<StreamFeatureProviderInfo>();
    private List<Exception> exceptions = new LinkedList<Exception>();

    public ProviderFileLoader(InputStream providerStream) {
        this(providerStream, ProviderFileLoader.class.getClassLoader());
    }

    public ProviderFileLoader(InputStream providerStream, ClassLoader classLoader) {
        try (InputStream is = providerStream;){
            XmlPullParser parser = PacketParserUtils.getParserFor(is);
            XmlPullParser.Event eventType = parser.getEventType();
            do {
                if (eventType != XmlPullParser.Event.START_ELEMENT) continue;
                String typeName = parser.getName();
                try {
                    if ("smackProviders".equals(typeName)) continue;
                    parser.next();
                    parser.next();
                    String elementName = parser.nextText();
                    parser.next();
                    parser.next();
                    String namespace = parser.nextText();
                    parser.next();
                    parser.next();
                    String className = parser.nextText();
                    try {
                        Class<?> provider = classLoader.loadClass(className);
                        switch (typeName) {
                            case "iqProvider": {
                                if (IqProvider.class.isAssignableFrom(provider)) {
                                    IqProvider iqProvider = (IqProvider)provider.getConstructor(new Class[0]).newInstance(new Object[0]);
                                    this.iqProviders.add(new IQProviderInfo(elementName, namespace, iqProvider));
                                    break;
                                }
                                this.exceptions.add(new IllegalArgumentException(className + " is not a IQProvider"));
                                break;
                            }
                            case "extensionProvider": {
                                if (ExtensionElementProvider.class.isAssignableFrom(provider)) {
                                    ExtensionElementProvider extensionElementProvider = (ExtensionElementProvider)provider.getConstructor(new Class[0]).newInstance(new Object[0]);
                                    this.extProviders.add(new ExtensionProviderInfo(elementName, namespace, extensionElementProvider));
                                    break;
                                }
                                this.exceptions.add(new IllegalArgumentException(className + " is not a PacketExtensionProvider"));
                                break;
                            }
                            case "streamFeatureProvider": {
                                ExtensionElementProvider streamFeatureProvider = (ExtensionElementProvider)provider.getConstructor(new Class[0]).newInstance(new Object[0]);
                                this.sfProviders.add(new StreamFeatureProviderInfo(elementName, namespace, streamFeatureProvider));
                                break;
                            }
                            default: {
                                LOGGER.warning("Unknown provider type: " + typeName);
                                break;
                            }
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        LOGGER.log(Level.SEVERE, "Could not find provider class", cnfe);
                        this.exceptions.add(cnfe);
                    }
                    catch (InstantiationException ie) {
                        LOGGER.log(Level.SEVERE, "Could not instanciate " + className, ie);
                        this.exceptions.add(ie);
                    }
                }
                catch (IllegalArgumentException illExc) {
                    LOGGER.log(Level.SEVERE, "Invalid provider type found [" + typeName + "] when expecting iqProvider or extensionProvider", illExc);
                    this.exceptions.add(illExc);
                }
            } while ((eventType = parser.next()) != XmlPullParser.Event.END_DOCUMENT);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unknown error occurred while parsing provider file", e);
            this.exceptions.add(e);
        }
    }

    @Override
    public Collection<IQProviderInfo> getIQProviderInfo() {
        return this.iqProviders;
    }

    @Override
    public Collection<ExtensionProviderInfo> getExtensionProviderInfo() {
        return this.extProviders;
    }

    @Override
    public Collection<StreamFeatureProviderInfo> getStreamFeatureProviderInfo() {
        return this.sfProviders;
    }

    public List<Exception> getLoadingExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }
}

