/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.format.AudioRedPayloadType;
import org.jitsi.nlj.format.Av1PayloadType;
import org.jitsi.nlj.format.H264PayloadType;
import org.jitsi.nlj.format.OpusPayloadType;
import org.jitsi.nlj.format.OtherAudioPayloadType;
import org.jitsi.nlj.format.OtherVideoPayloadType;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.PayloadTypeEncoding;
import org.jitsi.nlj.format.RtxPayloadType;
import org.jitsi.nlj.format.TelephoneEventPayloadType;
import org.jitsi.nlj.format.VideoRedPayloadType;
import org.jitsi.nlj.format.Vp8PayloadType;
import org.jitsi.nlj.format.Vp9PayloadType;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/videobridge/util/PayloadTypeUtil;", "", "<init>", "()V", "Companion", "jitsi-videobridge"})
public final class PayloadTypeUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger = (Logger)new LoggerImpl(PayloadTypeUtil.class.getName());

    @JvmStatic
    @Nullable
    public static final PayloadType create(@NotNull PayloadTypePacketExtension ext, @NotNull MediaType mediaType) {
        return Companion.create(ext, mediaType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jitsi/videobridge/util/PayloadTypeUtil$Companion;", "", "<init>", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "create", "Lorg/jitsi/nlj/format/PayloadType;", "ext", "Lorg/jitsi/xmpp/extensions/jingle/PayloadTypePacketExtension;", "mediaType", "Lorg/jitsi/utils/MediaType;", "jitsi-videobridge"})
    @SourceDebugExtension(value={"SMAP\nPayloadTypeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PayloadTypeUtil.kt\norg/jitsi/videobridge/util/PayloadTypeUtil$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1869#2,2:118\n1563#2:120\n1634#2,3:121\n*S KotlinDebug\n*F\n+ 1 PayloadTypeUtil.kt\norg/jitsi/videobridge/util/PayloadTypeUtil$Companion\n*L\n69#1:118,2\n82#1:120\n82#1:121,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final PayloadType create(@NotNull PayloadTypePacketExtension ext, @NotNull MediaType mediaType) {
            PayloadType payloadType;
            void $this$mapTo$iv$iv;
            Object element$iv2;
            Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            Map parameters = new ConcurrentHashMap();
            List list = ext.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                ParameterPacketExtension parameter = (ParameterPacketExtension)element$iv2;
                boolean bl = false;
                if (parameter.getName() != null) {
                    parameters.put(parameter.getName(), parameter.getValue());
                    continue;
                }
                logger.warn((Object)("Ignoring a format parameter with no name: " + parameter.toXML()));
            }
            List list2 = ext.getRtcpFeedbackTypeList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRtcpFeedbackTypeList(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void rtcpExtension;
                StringBuilder stringBuilder;
                RtcpFbPacketExtension rtcpFbPacketExtension = (RtcpFbPacketExtension)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                StringBuilder $this$create_u24lambda_u241_u240 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                $this$create_u24lambda_u241_u240.append(rtcpExtension.getFeedbackType());
                CharSequence charSequence = rtcpExtension.getFeedbackSubtype();
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    $this$create_u24lambda_u241_u240.append(" " + rtcpExtension.getFeedbackSubtype());
                }
                collection.add(stringBuilder.toString());
            }
            Set rtcpFeedbackSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            byte id = (byte)ext.getID();
            String string = ext.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            PayloadTypeEncoding encoding = PayloadTypeEncoding.Companion.createFrom(string);
            int clockRate = ext.getClockrate();
            block0 : switch (WhenMappings.$EnumSwitchMapping$1[encoding.ordinal()]) {
                case 1: {
                    payloadType = (PayloadType)new Vp8PayloadType(id, parameters, rtcpFeedbackSet);
                    break;
                }
                case 2: {
                    payloadType = (PayloadType)new Vp9PayloadType(id, parameters, rtcpFeedbackSet);
                    break;
                }
                case 3: {
                    payloadType = (PayloadType)new Av1PayloadType(id, parameters, rtcpFeedbackSet);
                    break;
                }
                case 4: {
                    payloadType = (PayloadType)new H264PayloadType(id, parameters, rtcpFeedbackSet);
                    break;
                }
                case 5: {
                    payloadType = (PayloadType)new RtxPayloadType(id, parameters);
                    break;
                }
                case 6: {
                    payloadType = (PayloadType)new OpusPayloadType(id, parameters);
                    break;
                }
                case 7: {
                    payloadType = (PayloadType)new TelephoneEventPayloadType(id, clockRate, parameters);
                    break;
                }
                case 8: {
                    switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
                        case 1: {
                            payloadType = (PayloadType)new AudioRedPayloadType(id, clockRate, parameters);
                            break block0;
                        }
                        case 2: {
                            payloadType = (PayloadType)new VideoRedPayloadType(id, clockRate, parameters, rtcpFeedbackSet);
                            break block0;
                        }
                    }
                    payloadType = null;
                    break;
                }
                case 9: {
                    switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
                        case 1: {
                            payloadType = (PayloadType)new OtherAudioPayloadType(id, clockRate, parameters);
                            break block0;
                        }
                        case 2: {
                            payloadType = (PayloadType)new OtherVideoPayloadType(id, clockRate, parameters);
                            break block0;
                        }
                    }
                    payloadType = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return payloadType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[MediaType.values().length];
                try {
                    nArray[MediaType.AUDIO.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MediaType.VIDEO.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[PayloadTypeEncoding.values().length];
                try {
                    nArray[PayloadTypeEncoding.VP8.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PayloadTypeEncoding.VP9.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PayloadTypeEncoding.AV1.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PayloadTypeEncoding.H264.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PayloadTypeEncoding.RTX.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PayloadTypeEncoding.OPUS.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PayloadTypeEncoding.TELEPHONE_EVENT.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PayloadTypeEncoding.RED.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PayloadTypeEncoding.OTHER.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

