/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.RtpEncodingDescKt;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.utils.OrderedJsonObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0012J\u001b\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0006J\u000e\u0010&\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0012J%\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010-\u001a\u00020.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@@X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010#\u001a\u0004\b \u0010!\"\u0004\b\"\u0010\u001d\u00a8\u00060"}, d2={"Lorg/jitsi/nlj/RtpEncodingDesc;", "", "primarySSRC", "", "initialLayers", "", "Lorg/jitsi/nlj/RtpLayerDesc;", "eid", "", "<init>", "(J[Lorg/jitsi/nlj/RtpLayerDesc;I)V", "(JI)V", "getPrimarySSRC", "()J", "getEid", "()I", "secondarySsrcs", "", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "addSecondarySsrc", "", "ssrc", "type", "ssrcs", "", "getSsrcs", "()Ljava/util/Collection;", "validateLayerEids", "layers", "([Lorg/jitsi/nlj/RtpLayerDesc;)V", "nominalHeight", "newLayers", "getLayers$jitsi_media_transform", "()[Lorg/jitsi/nlj/RtpLayerDesc;", "setLayers$jitsi_media_transform", "[Lorg/jitsi/nlj/RtpLayerDesc;", "encodingId", "layer", "getSecondarySsrc", "copy", "(J[Lorg/jitsi/nlj/RtpLayerDesc;)Lorg/jitsi/nlj/RtpEncodingDesc;", "toString", "", "hasSsrc", "", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRtpEncodingDesc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtpEncodingDesc.kt\norg/jitsi/nlj/RtpEncodingDesc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,209:1\n1#2:210\n12767#3,2:211\n12767#3,2:213\n9037#3,2:215\n9297#3,4:217\n216#4,2:221\n*S KotlinDebug\n*F\n+ 1 RtpEncodingDesc.kt\norg/jitsi/nlj/RtpEncodingDesc\n*L\n86#1:211,2\n87#1:213,2\n96#1:215,2\n96#1:217,4\n146#1:221,2\n*E\n"})
public final class RtpEncodingDesc {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long primarySSRC;
    private final int eid;
    @NotNull
    private final Map<Long, SsrcAssociationType> secondarySsrcs;
    private int nominalHeight;
    @NotNull
    private RtpLayerDesc[] layers;

    @JvmOverloads
    public RtpEncodingDesc(long primarySSRC, @NotNull RtpLayerDesc[] initialLayers, int eid) {
        Intrinsics.checkNotNullParameter((Object)initialLayers, (String)"initialLayers");
        this.primarySSRC = primarySSRC;
        this.eid = eid;
        this.secondarySsrcs = new HashMap();
        this.validateLayerEids(initialLayers);
        this.nominalHeight = RtpEncodingDescKt.access$getNominalHeight(initialLayers);
        this.layers = initialLayers;
    }

    public /* synthetic */ RtpEncodingDesc(long l, RtpLayerDesc[] rtpLayerDescArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            RtpLayerDesc rtpLayerDesc = (RtpLayerDesc)ArraysKt.getOrNull((Object[])rtpLayerDescArray, (int)0);
            Integer n3 = rtpLayerDesc != null ? Integer.valueOf(rtpLayerDesc.getEid()) : null;
            if (n3 == null) {
                boolean bl = false;
                String string = "initialLayers may not be empty if no explicit EID is provided";
                throw new IllegalArgumentException(string.toString());
            }
            n = ((Number)n3).intValue();
        }
        this(l, rtpLayerDescArray, n);
    }

    public final long getPrimarySSRC() {
        return this.primarySSRC;
    }

    public final int getEid() {
        return this.eid;
    }

    public RtpEncodingDesc(long primarySSRC, int eid) {
        this(primarySSRC, new RtpLayerDesc[0], eid);
    }

    public final void addSecondarySsrc(long ssrc, @NotNull SsrcAssociationType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.secondarySsrcs.put(ssrc, type);
    }

    @NotNull
    public final Collection<Long> getSsrcs() {
        HashSet<Long> hashSet;
        HashSet<Long> set = hashSet = new HashSet<Long>();
        boolean bl = false;
        set.add(this.primarySSRC);
        set.addAll((Collection)this.secondarySsrcs.keySet());
        return hashSet;
    }

    private final void validateLayerEids(RtpLayerDesc[] layers) {
        for (RtpLayerDesc layer : layers) {
            if (layer.getEid() == this.eid) continue;
            boolean bl = false;
            String string = "Cannot add layer with EID " + layer.getEid() + " to encoding with EID " + this.eid;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final RtpLayerDesc[] getLayers$jitsi_media_transform() {
        return this.layers;
    }

    /*
     * Unable to fully structure code
     */
    public final void setLayers$jitsi_media_transform(@NotNull RtpLayerDesc[] newLayers) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)newLayers, (String)"newLayers");
                this.validateLayerEids(newLayers);
                if (this.nominalHeight == -1) ** GOTO lbl-1000
                $this$all$iv = newLayers;
                $i$f$all = false;
                var6_7 = $this$all$iv.length;
                for (var5_6 = 0; var5_6 < var6_7; ++var5_6) {
                    it = element$iv = $this$all$iv[var5_6];
                    $i$a$-all-RtpEncodingDesc$layers$useNominalHeight$1 = false;
                    if (it.getSid() == 0) continue;
                    v0 = false;
                    break block8;
                }
                v0 = true;
            }
            if (!v0) ** GOTO lbl-1000
            $this$all$iv = newLayers;
            $i$f$all = false;
            var6_7 = $this$all$iv.length;
            for (var5_6 = 0; var5_6 < var6_7; ++var5_6) {
                it = element$iv = $this$all$iv[var5_6];
                $i$a$-all-RtpEncodingDesc$layers$useNominalHeight$2 = false;
                if (it.getHeight() == -1) continue;
                v1 = false;
                break block9;
            }
            v1 = true;
        }
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 3 sources

        {
            v2 = false;
        }
        useNominalHeight = v2;
        $this$associateBy$iv = this.layers;
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        element$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        $i$f$associateByTo = false;
        var11_15 = ((void)$this$associateByTo$iv$iv).length;
        for (var10_14 = 0; var10_14 < var11_15; ++var10_14) {
            var13_17 = element$iv$iv = $this$associateByTo$iv$iv[var10_14];
            var15_19 = destination$iv$iv;
            $i$a$-associateBy-RtpEncodingDesc$layers$oldLayerMap$1 = false;
            var15_19.put(it.getLayerId(), element$iv$iv);
        }
        oldLayerMap = destination$iv$iv;
        var5_6 = newLayers.length;
        for ($this$associateBy$iv = 0; $this$associateBy$iv < var5_6; ++$this$associateBy$iv) {
            newLayer = newLayers[$this$associateBy$iv];
            if ((RtpLayerDesc)oldLayerMap.get(newLayer.getLayerId()) != null) {
                $i$a$-let-RtpEncodingDesc$layers$1 = false;
                newLayer.inheritFrom$jitsi_media_transform(it);
            }
            if (!useNominalHeight) continue;
            newLayer.setHeight(this.nominalHeight);
        }
        if (!useNominalHeight && (newNominalHeight = RtpEncodingDescKt.access$getNominalHeight(newLayers)) != -1) {
            this.nominalHeight = newNominalHeight;
        }
        this.layers = newLayers;
    }

    public final long encodingId(@NotNull RtpLayerDesc layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        return Companion.calcEncodingId(this.primarySSRC, layer.getLayerId());
    }

    public final long getSecondarySsrc(@NotNull SsrcAssociationType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        for (Map.Entry<Long, SsrcAssociationType> entry : this.secondarySsrcs.entrySet()) {
            long key = ((Number)entry.getKey()).longValue();
            SsrcAssociationType value = entry.getValue();
            if (value != type) continue;
            return key;
        }
        return -1L;
    }

    @NotNull
    public final RtpEncodingDesc copy(long primarySSRC, @NotNull RtpLayerDesc[] layers) {
        RtpEncodingDesc rtpEncodingDesc;
        Intrinsics.checkNotNullParameter((Object)layers, (String)"layers");
        RtpEncodingDesc it = rtpEncodingDesc = new RtpEncodingDesc(primarySSRC, layers, this.eid);
        boolean bl = false;
        Map<Long, SsrcAssociationType> $this$forEach$iv = this.secondarySsrcs;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, SsrcAssociationType>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, SsrcAssociationType> element$iv;
            Map.Entry<Long, SsrcAssociationType> entry = element$iv = iterator.next();
            boolean bl2 = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            SsrcAssociationType type = entry.getValue();
            it.addSecondarySsrc(ssrc, type);
        }
        return rtpEncodingDesc;
    }

    public static /* synthetic */ RtpEncodingDesc copy$default(RtpEncodingDesc rtpEncodingDesc, long l, RtpLayerDesc[] rtpLayerDescArray, int n, Object object) {
        if ((n & 1) != 0) {
            l = rtpEncodingDesc.primarySSRC;
        }
        if ((n & 2) != 0) {
            int n2 = 0;
            int n3 = rtpEncodingDesc.layers.length;
            RtpLayerDesc[] rtpLayerDescArray2 = new RtpLayerDesc[n3];
            while (n2 < n3) {
                int n4 = n2++;
                rtpLayerDescArray2[n4] = RtpLayerDesc.copy$default(rtpEncodingDesc.layers[n4], 0, 0, false, 7, null);
            }
            rtpLayerDescArray = rtpLayerDescArray2;
        }
        return rtpEncodingDesc.copy(l, rtpLayerDescArray);
    }

    @NotNull
    public String toString() {
        return "primary_ssrc=" + this.primarySSRC + ",secondary_ssrcs=" + this.secondarySsrcs + ",layers=\n    " + ArraysKt.joinToString$default((Object[])this.layers, (CharSequence)"\n    ", null, null, (int)0, null, null, (int)62, null);
    }

    public final boolean hasSsrc(long ssrc) {
        return this.primarySSRC == ssrc ? true : this.secondarySsrcs.containsKey(ssrc);
    }

    @NotNull
    public final OrderedJsonObject debugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$debugState_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$debugState_u24lambda_u240).put("rtx_ssrc", this.getSecondarySsrc(SsrcAssociationType.RTX));
        ((Map)$this$debugState_u24lambda_u240).put("fec_ssrc", this.getSecondarySsrc(SsrcAssociationType.FEC));
        ((Map)$this$debugState_u24lambda_u240).put("eid", this.eid);
        ((Map)$this$debugState_u24lambda_u240).put("nominal_height", this.nominalHeight);
        for (RtpLayerDesc layer : this.layers) {
            ((Map)$this$debugState_u24lambda_u240).put(layer.indexString(), layer.debugState());
        }
        return orderedJsonObject;
    }

    @JvmOverloads
    public RtpEncodingDesc(long primarySSRC, @NotNull RtpLayerDesc[] initialLayers) {
        Intrinsics.checkNotNullParameter((Object)initialLayers, (String)"initialLayers");
        this(primarySSRC, initialLayers, 0, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jitsi/nlj/RtpEncodingDesc$Companion;", "", "<init>", "()V", "calcEncodingId", "", "ssrc", "layerId", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final long calcEncodingId(long ssrc, int layerId) {
            return ssrc | (long)layerId << 32;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

