/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacerConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProbeClusterConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.TargetTransferRate;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.logging.DiagnosticContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B;\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkControlUpdate;", "", "congestionWindow", "Lorg/jitsi/nlj/util/DataSize;", "pacerConfig", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacerConfig;", "probeClusterConfigs", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeClusterConfig;", "targetRate", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TargetTransferRate;", "<init>", "(Lorg/jitsi/nlj/util/DataSize;Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacerConfig;Ljava/util/List;Lorg/jitsi/nlj/rtp/bandwidthestimation2/TargetTransferRate;)V", "getCongestionWindow", "()Lorg/jitsi/nlj/util/DataSize;", "getPacerConfig", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacerConfig;", "getProbeClusterConfigs", "()Ljava/util/List;", "getTargetRate", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/TargetTransferRate;", "isEmpty", "", "isNotEmpty", "atTime", "Ljava/time/Instant;", "getAtTime", "()Ljava/time/Instant;", "addToTimeSeriesPoint", "", "point", "Lorg/jitsi/utils/logging/DiagnosticContext$TimeSeriesPoint;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nNetworkTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkTypes.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/NetworkControlUpdate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,340:1\n1878#2,3:341\n*S KotlinDebug\n*F\n+ 1 NetworkTypes.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/NetworkControlUpdate\n*L\n318#1:341,3\n*E\n"})
public class NetworkControlUpdate {
    @Nullable
    private final DataSize congestionWindow;
    @Nullable
    private final PacerConfig pacerConfig;
    @NotNull
    private final List<ProbeClusterConfig> probeClusterConfigs;
    @Nullable
    private final TargetTransferRate targetRate;

    public NetworkControlUpdate(@Nullable DataSize congestionWindow, @Nullable PacerConfig pacerConfig, @NotNull List<ProbeClusterConfig> probeClusterConfigs, @Nullable TargetTransferRate targetRate) {
        Intrinsics.checkNotNullParameter(probeClusterConfigs, (String)"probeClusterConfigs");
        this.congestionWindow = congestionWindow;
        this.pacerConfig = pacerConfig;
        this.probeClusterConfigs = probeClusterConfigs;
        this.targetRate = targetRate;
    }

    public /* synthetic */ NetworkControlUpdate(DataSize dataSize, PacerConfig pacerConfig, List list, TargetTransferRate targetTransferRate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dataSize = null;
        }
        if ((n & 2) != 0) {
            pacerConfig = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            targetTransferRate = null;
        }
        this(dataSize, pacerConfig, list, targetTransferRate);
    }

    @Nullable
    public DataSize getCongestionWindow() {
        return this.congestionWindow;
    }

    @Nullable
    public PacerConfig getPacerConfig() {
        return this.pacerConfig;
    }

    @NotNull
    public List<ProbeClusterConfig> getProbeClusterConfigs() {
        return this.probeClusterConfigs;
    }

    @Nullable
    public TargetTransferRate getTargetRate() {
        return this.targetRate;
    }

    public final boolean isEmpty() {
        return this.getCongestionWindow() == null && this.getPacerConfig() == null && this.getProbeClusterConfigs().isEmpty() && this.getTargetRate() == null;
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Nullable
    public final Instant getAtTime() {
        Object object = this.getTargetRate();
        if (object == null || (object = ((TargetTransferRate)object).getAtTime()) == null) {
            ProbeClusterConfig probeClusterConfig = (ProbeClusterConfig)CollectionsKt.firstOrNull(this.getProbeClusterConfigs());
            if (probeClusterConfig != null) {
                object = probeClusterConfig.getAtTime();
            } else {
                PacerConfig pacerConfig = this.getPacerConfig();
                object = pacerConfig != null ? pacerConfig.getAtTime() : null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final void addToTimeSeriesPoint(@NotNull DiagnosticContext.TimeSeriesPoint point) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        TargetTransferRate targetTransferRate = this.getTargetRate();
        if (targetTransferRate != null) {
            it = targetTransferRate;
            boolean bl = false;
            point.addField("target_rate_bps", (Object)((TargetTransferRate)it).getTargetRate-rlWvAKk());
            point.addField("stable_target_rate_bps", (Object)((TargetTransferRate)it).getStableTargetRate-rlWvAKk());
            point.addField("cwnd_reduce_ratio", (Object)((TargetTransferRate)it).getCwndReduceRatio());
            point.addField("rtt_ms", (Object)DurationKt.toDoubleMillis((Duration)((TargetTransferRate)it).getNetworkEstimate().getRoundTripTime()));
            point.addField("bwe_period_ms", (Object)DurationKt.toDoubleMillis((Duration)((TargetTransferRate)it).getNetworkEstimate().getBwePeriod()));
            point.addField("loss_rate_ratio", (Object)Float.valueOf(((TargetTransferRate)it).getNetworkEstimate().getLossRateRatio()));
        }
        DataSize dataSize = this.getCongestionWindow();
        if (dataSize != null) {
            it = dataSize;
            boolean bl = false;
            point.addField("congestion_window_bytes", (Object)((DataSize)it).getBytes());
        }
        PacerConfig pacerConfig = this.getPacerConfig();
        if (pacerConfig != null) {
            it = pacerConfig;
            boolean bl = false;
            point.addField("pacer_data_rate_bps", (Object)((PacerConfig)it).dataRate-rlWvAKk());
            point.addField("pacer_pad_rate_bps", (Object)((PacerConfig)it).padRate-rlWvAKk());
        }
        Iterable $this$forEachIndexed$iv = this.getProbeClusterConfigs();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProbeClusterConfig probeClusterConfig = (ProbeClusterConfig)item$iv;
            int i = n;
            boolean bl = false;
            point.addField("probe_cluster_" + i + "_id", (Object)it2.getId());
            point.addField("probe_cluster_" + i + "_data_rate_bps", (Object)it2.getTargetDataRate-rlWvAKk());
            point.addField("probe_cluster_" + i + "_duration_ms", (Object)DurationKt.toDoubleMillis((Duration)it2.getTargetDuration()));
            point.addField("probe_cluster_" + i + "_delta_ms", (Object)DurationKt.toDoubleMillis((Duration)it2.getMinProbeDelta()));
            point.addField("probe_cluster_" + i + "_count", (Object)it2.getTargetProbeCount());
        }
    }

    public NetworkControlUpdate() {
        this(null, null, null, null, 15, null);
    }
}

