/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.impl.neomedia.rtp.sendsidebandwidthestimation;

import java.time.Duration;
import java.util.Deque;
import java.util.IntSummaryStatistics;
import java.util.LinkedList;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi_modified.impl.neomedia.rtp.sendsidebandwidthestimation.config.SendSideBandwidthEstimationConfig;

public class SendSideBandwidthEstimation {
    private static final int kBweIncreaseIntervalMs = 1000;
    private static final long kBweDecreaseIntervalMs = 300L;
    private static final int kDefaultMinBitrateBps = 10000;
    private static final int kDefaultMaxBitrateBps = 1000000000;
    private static final int kStartPhaseMs = 2000;
    private static final int kLimitNumPackets = 20;
    private static final long kFeedbackIntervalMs = 1500L;
    private static final double kPacketReportTimeoutIntervals = 1.2;
    private static final long kFeedbackTimeoutIntervals = 3L;
    private static final long kTimeoutIntervalMs = 1000L;
    private static final Random kRandom = new Random();
    private final Logger logger;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(SendSideBandwidthEstimation.class);
    private final double low_loss_threshold_;
    private final double high_loss_threshold_;
    private final int bitrate_threshold_bps_;
    private long first_report_time_ms_ = -1L;
    private int lost_packets_since_last_loss_update_Q8_ = 0;
    private int expected_packets_since_last_loss_update_ = 0;
    private boolean has_decreased_since_last_fraction_loss_ = false;
    private int last_fraction_loss_ = 0;
    private long last_feedback_ms_ = -1L;
    private long last_packet_report_ms_ = -1L;
    private long last_timeout_ms_ = -1L;
    private final boolean in_timeout_experiment_;
    private int min_bitrate_configured_ = 10000;
    private int max_bitrate_configured_ = 1000000000;
    private long time_last_decrease_ms_ = 0L;
    private long bwe_incoming_ = 0L;
    private long bitrate_;
    private Deque<BitrateHistoryRecord> min_bitrate_history_ = new LinkedList<BitrateHistoryRecord>();
    private final DiagnosticContext diagnosticContext;
    private long rttMs;
    private final Statistics statistics = new Statistics();

    public SendSideBandwidthEstimation(DiagnosticContext diagnosticContext, long startBitrate, @NotNull Logger parentLogger) {
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.diagnosticContext = diagnosticContext;
        double lossExperimentProbability = SendSideBandwidthEstimationConfig.lossExperimentProbability();
        if ((double)kRandom.nextFloat() < lossExperimentProbability) {
            this.low_loss_threshold_ = SendSideBandwidthEstimationConfig.experimentalLowLossThreshold();
            this.high_loss_threshold_ = SendSideBandwidthEstimationConfig.experimentalHighLossThreshold();
            this.bitrate_threshold_bps_ = (int)SendSideBandwidthEstimationConfig.experimentalBitrateThresholdBps();
        } else {
            this.low_loss_threshold_ = SendSideBandwidthEstimationConfig.defaultLowLossThreshold();
            this.high_loss_threshold_ = SendSideBandwidthEstimationConfig.defaultHighLossThreshold();
            this.bitrate_threshold_bps_ = (int)SendSideBandwidthEstimationConfig.defaultBitrateThresholdBps();
        }
        double timeoutExperimentProbability = SendSideBandwidthEstimationConfig.timeoutExperimentProbability();
        this.in_timeout_experiment_ = (double)kRandom.nextFloat() < timeoutExperimentProbability;
        this.setBitrate(startBitrate);
    }

    public synchronized void reset(long startBitrate) {
        this.first_report_time_ms_ = -1L;
        this.lost_packets_since_last_loss_update_Q8_ = 0;
        this.expected_packets_since_last_loss_update_ = 0;
        this.has_decreased_since_last_fraction_loss_ = false;
        this.last_fraction_loss_ = 0;
        this.last_feedback_ms_ = -1L;
        this.last_packet_report_ms_ = -1L;
        this.last_timeout_ms_ = -1L;
        this.time_last_decrease_ms_ = 0L;
        this.bwe_incoming_ = 0L;
        this.min_bitrate_history_.clear();
        this.setBitrate(startBitrate);
        this.statistics.reset();
    }

    private synchronized boolean isInStartPhase(long now) {
        return this.first_report_time_ms_ == -1L || now - this.first_report_time_ms_ < 2000L;
    }

    private synchronized long capBitrateToThresholds(long bitrate) {
        if (this.bwe_incoming_ > 0L && bitrate > this.bwe_incoming_) {
            bitrate = this.bwe_incoming_;
        }
        if (bitrate > (long)this.max_bitrate_configured_) {
            bitrate = this.max_bitrate_configured_;
        }
        if (bitrate < (long)this.min_bitrate_configured_) {
            bitrate = this.min_bitrate_configured_;
        }
        return bitrate;
    }

    public synchronized void updateEstimate(long now) {
        long bitrate = this.bitrate_;
        if (this.last_fraction_loss_ == 0 && this.isInStartPhase(now) && this.bwe_incoming_ > bitrate) {
            this.setBitrate(this.capBitrateToThresholds(this.bwe_incoming_));
            this.min_bitrate_history_.clear();
            this.min_bitrate_history_.addLast(new BitrateHistoryRecord(now, this.bitrate_));
            return;
        }
        this.updateMinHistory(now);
        if (this.last_packet_report_ms_ == -1L) {
            this.bitrate_ = this.capBitrateToThresholds(this.bitrate_);
            return;
        }
        long time_since_packet_report_ms = now - this.last_packet_report_ms_;
        long time_since_feedback_ms = now - this.last_feedback_ms_;
        if ((double)time_since_packet_report_ms < 1800.0) {
            float loss = (float)this.last_fraction_loss_ / 256.0f;
            if (this.bitrate_ < (long)this.bitrate_threshold_bps_ || (double)loss <= this.low_loss_threshold_) {
                bitrate = (long)((double)this.min_bitrate_history_.getFirst().bitrate * 1.08 + 0.5);
                bitrate += 1000L;
                this.statistics.update(now, false, LossRegion.LossFree);
            } else if (this.bitrate_ > (long)this.bitrate_threshold_bps_) {
                if ((double)loss <= this.high_loss_threshold_) {
                    this.statistics.update(now, false, LossRegion.LossLimited);
                } else if (!this.has_decreased_since_last_fraction_loss_ && now - this.time_last_decrease_ms_ >= 300L + this.getRttMs()) {
                    this.time_last_decrease_ms_ = now;
                    bitrate = (long)((double)(bitrate * (long)(512 - this.last_fraction_loss_)) / 512.0);
                    this.has_decreased_since_last_fraction_loss_ = true;
                    this.statistics.update(now, false, LossRegion.LossDegraded);
                }
            }
        } else {
            this.statistics.update(now, true, null);
            if (time_since_feedback_ms > 4500L && (this.last_timeout_ms_ == -1L || now - this.last_timeout_ms_ > 1000L) && this.in_timeout_experiment_) {
                this.bitrate_ = (long)((double)this.bitrate_ * 0.8);
                this.lost_packets_since_last_loss_update_Q8_ = 0;
                this.expected_packets_since_last_loss_update_ = 0;
                this.last_timeout_ms_ = now;
            }
        }
        this.setBitrate(this.capBitrateToThresholds(bitrate));
    }

    public void reportPacketArrived(long now, boolean previouslyReportedLost) {
        if (previouslyReportedLost) {
            this.lostPacketArrived();
        } else {
            this.updateReceiverBlock(0L, 1L, now);
        }
    }

    public void reportPacketLost(long now) {
        this.updateReceiverBlock(256L, 1L, now);
    }

    private synchronized void updateReceiverBlock(long fraction_lost, long number_of_packets, long now) {
        this.last_feedback_ms_ = now;
        if (this.first_report_time_ms_ == -1L) {
            this.first_report_time_ms_ = now;
        }
        if (number_of_packets > 0L) {
            long num_lost_packets_Q8 = fraction_lost * number_of_packets;
            this.lost_packets_since_last_loss_update_Q8_ = (int)((long)this.lost_packets_since_last_loss_update_Q8_ + num_lost_packets_Q8);
            this.expected_packets_since_last_loss_update_ = (int)((long)this.expected_packets_since_last_loss_update_ + number_of_packets);
            if (this.expected_packets_since_last_loss_update_ < 20) {
                return;
            }
            this.has_decreased_since_last_fraction_loss_ = false;
            this.last_fraction_loss_ = this.lost_packets_since_last_loss_update_Q8_ / this.expected_packets_since_last_loss_update_;
            this.lost_packets_since_last_loss_update_Q8_ = 0;
            this.expected_packets_since_last_loss_update_ = 0;
            this.last_packet_report_ms_ = now;
        }
    }

    private synchronized void lostPacketArrived() {
        if (this.lost_packets_since_last_loss_update_Q8_ >= 256) {
            this.lost_packets_since_last_loss_update_Q8_ -= 256;
        }
    }

    private synchronized void updateMinHistory(long now_ms) {
        while (!this.min_bitrate_history_.isEmpty() && now_ms - this.min_bitrate_history_.getFirst().timestampMs + 1L > 1000L) {
            this.min_bitrate_history_.removeFirst();
        }
        while (!this.min_bitrate_history_.isEmpty() && this.bitrate_ <= this.min_bitrate_history_.getLast().bitrate) {
            this.min_bitrate_history_.removeLast();
        }
        this.min_bitrate_history_.addLast(new BitrateHistoryRecord(now_ms, this.bitrate_));
    }

    public synchronized void updateReceiverEstimate(long bandwidth) {
        if (timeSeriesLogger.isTraceEnabled()) {
            timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("bwe_incoming").addField("bitrate_bps", (Object)bandwidth));
        }
        this.bwe_incoming_ = bandwidth;
        this.setBitrate(this.capBitrateToThresholds(this.bitrate_));
    }

    public synchronized void setMinMaxBitrate(int min_bitrate, int max_bitrate) {
        this.min_bitrate_configured_ = Math.max(min_bitrate, 10000);
        this.max_bitrate_configured_ = max_bitrate > 0 ? Math.max(this.min_bitrate_configured_, max_bitrate) : 1000000000;
    }

    private synchronized void setBitrate(long newValue) {
        this.bitrate_ = newValue;
    }

    public long getLatestEstimate() {
        return this.bitrate_;
    }

    public long getLatestREMB() {
        return this.bwe_incoming_;
    }

    public int getLatestFractionLoss() {
        return this.last_fraction_loss_;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public synchronized void onRttUpdate(Duration newRtt) {
        this.rttMs = newRtt.toMillis();
    }

    private synchronized long getRttMs() {
        if (this.rttMs < 0L) {
            this.logger.warn((Object)"RTT not calculated, using the default of 100ms.");
            this.rttMs = 100L;
        } else if (this.rttMs > 1000L) {
            this.logger.warn((Object)("RTT suspiciously high (" + this.rttMs + "ms), capping to 1000ms."));
            this.rttMs = 1000L;
        }
        return this.rttMs;
    }

    private static enum LossRegion {
        LossLimited,
        LossDegraded,
        LossFree;

    }

    public class Statistics {
        private LossRegion currentState = null;
        private long lastTransitionTimestampMs = -1L;
        private long currentStateCumulativeDurationMs;
        private int currentStateConsecutiveVisits;
        private long currentStateStartBitrateBps;
        private LongSummaryStatistics currentStateBitrateStatistics = new LongSummaryStatistics();
        private IntSummaryStatistics currentStateLossStatistics = new IntSummaryStatistics();
        private boolean isDirty = false;
        private LongSummaryStatistics lossFreeMsStats = new LongSummaryStatistics();
        private LongSummaryStatistics lossDegradedMsStats = new LongSummaryStatistics();
        private LongSummaryStatistics lossLimitedMsStats = new LongSummaryStatistics();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(long nowMs) {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                long time_since_packet_report_ms = nowMs - SendSideBandwidthEstimation.this.last_packet_report_ms_;
                boolean currentStateHasTimedOut = (double)time_since_packet_report_ms < 1800.0;
                this.update(nowMs, currentStateHasTimedOut, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(long nowMs, boolean currentStateHasTimedOut, LossRegion nextState) {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                if (this.lastTransitionTimestampMs > -1L && !currentStateHasTimedOut) {
                    this.isDirty = true;
                    this.currentStateCumulativeDurationMs += nowMs - this.lastTransitionTimestampMs;
                }
                this.lastTransitionTimestampMs = nowMs;
                if (!currentStateHasTimedOut) {
                    this.isDirty = true;
                    this.currentStateLossStatistics.accept(SendSideBandwidthEstimation.this.last_fraction_loss_);
                    ++this.currentStateConsecutiveVisits;
                    if (this.currentState == nextState) {
                        this.currentStateBitrateStatistics.accept(SendSideBandwidthEstimation.this.bitrate_);
                        return;
                    }
                }
                if (this.currentState != null) {
                    switch (this.currentState) {
                        case LossDegraded: {
                            this.lossDegradedMsStats.accept(this.currentStateCumulativeDurationMs);
                            break;
                        }
                        case LossFree: {
                            this.lossFreeMsStats.accept(this.currentStateCumulativeDurationMs);
                            break;
                        }
                        case LossLimited: {
                            this.lossLimitedMsStats.accept(this.currentStateCumulativeDurationMs);
                        }
                    }
                    if (timeSeriesLogger.isTraceEnabled()) {
                        timeSeriesLogger.trace((Map)SendSideBandwidthEstimation.this.diagnosticContext.makeTimeSeriesPoint("loss_estimate").addField("state", (Object)this.currentState.name()).addField("max_loss", (Object)Float.valueOf((float)this.currentStateLossStatistics.getMax() / 256.0f)).addField("min_loss", (Object)Float.valueOf((float)this.currentStateLossStatistics.getMin() / 256.0f)).addField("avg_loss", (Object)(this.currentStateLossStatistics.getAverage() / 256.0)).addField("max_bps", (Object)this.currentStateBitrateStatistics.getMax()).addField("min_bps", (Object)this.currentStateBitrateStatistics.getMin()).addField("avg_bps", (Object)this.currentStateBitrateStatistics.getAverage()).addField("duration_ms", (Object)this.currentStateCumulativeDurationMs).addField("consecutive_visits", (Object)this.currentStateConsecutiveVisits).addField("bitrate_threshold", (Object)SendSideBandwidthEstimation.this.bitrate_threshold_bps_).addField("low_loss_threshold", (Object)SendSideBandwidthEstimation.this.low_loss_threshold_).addField("high_loss_threshold", (Object)SendSideBandwidthEstimation.this.high_loss_threshold_).addField("delta_bps", (Object)(SendSideBandwidthEstimation.this.bitrate_ - this.currentStateStartBitrateBps)).addField("bitrate", (Object)SendSideBandwidthEstimation.this.bitrate_).addField("bwe_incoming", (Object)SendSideBandwidthEstimation.this.bwe_incoming_).addField("rtt_ms", (Object)SendSideBandwidthEstimation.this.rttMs));
                    }
                }
                this.currentState = nextState;
                this.currentStateStartBitrateBps = SendSideBandwidthEstimation.this.bitrate_;
                if (this.isDirty) {
                    this.currentStateLossStatistics = new IntSummaryStatistics();
                    this.currentStateBitrateStatistics = new LongSummaryStatistics();
                    this.currentStateConsecutiveVisits = 0;
                    this.currentStateCumulativeDurationMs = 0L;
                    this.isDirty = false;
                }
                this.currentStateBitrateStatistics.accept(SendSideBandwidthEstimation.this.bitrate_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                this.currentState = null;
                this.lastTransitionTimestampMs = -1L;
                this.lossFreeMsStats = new LongSummaryStatistics();
                this.lossDegradedMsStats = new LongSummaryStatistics();
                this.lossLimitedMsStats = new LongSummaryStatistics();
                if (this.isDirty) {
                    this.currentStateLossStatistics = new IntSummaryStatistics();
                    this.currentStateBitrateStatistics = new LongSummaryStatistics();
                    this.currentStateConsecutiveVisits = 0;
                    this.currentStateCumulativeDurationMs = 0L;
                    this.isDirty = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLossLimitedMs() {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                return this.lossLimitedMsStats.getSum();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLossDegradedMs() {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                return this.lossDegradedMsStats.getSum();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLossFreeMs() {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                return this.lossFreeMsStats.getSum();
            }
        }
    }

    private static final class BitrateHistoryRecord {
        final long timestampMs;
        final long bitrate;

        BitrateHistoryRecord(long now, long br) {
            this.timestampMs = now;
            this.bitrate = br;
        }
    }
}

