/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketFeedback;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.utils.InstantKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/InFlightBytesTracker;", "", "<init>", "()V", "addInFlightPacketBytes", "", "packet", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketFeedback;", "removeInFlightPacketBytes", "getOutstandingData", "Lorg/jitsi/nlj/util/DataSize;", "inFlightData", "getInFlightData", "()Lorg/jitsi/nlj/util/DataSize;", "setInFlightData", "(Lorg/jitsi/nlj/util/DataSize;)V", "jitsi-media-transform"})
final class InFlightBytesTracker {
    @NotNull
    private DataSize inFlightData = DataSize.Companion.getZERO();

    public final void addInFlightPacketBytes(@NotNull PacketFeedback packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (!InstantKt.isFinite((Instant)packet.getSent().getSendTime())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.inFlightData = this.inFlightData.plus(packet.getSent().getSize());
    }

    public final void removeInFlightPacketBytes(@NotNull PacketFeedback packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (InstantKt.isInfinite((Instant)packet.getSent().getSendTime())) {
            return;
        }
        if (!(packet.getSent().getSize().compareTo(this.inFlightData) <= 0)) {
            throw new IllegalStateException("Check failed.");
        }
        this.inFlightData = this.inFlightData.minus(packet.getSent().getSize());
    }

    @NotNull
    public final DataSize getOutstandingData() {
        return this.inFlightData;
    }

    @NotNull
    public final DataSize getInFlightData() {
        return this.inFlightData;
    }

    public final void setInFlightData(@NotNull DataSize dataSize) {
        Intrinsics.checkNotNullParameter((Object)dataSize, (String)"<set-?>");
        this.inFlightData = dataSize;
    }
}

