/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.DateField;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.license.License;
import org.tinymediamanager.thirdparty.trakttv.TraktTv;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.toast.TmmToastManager;

class ExternalServicesSettingsPanel
extends JPanel {
    private final Settings settings = Settings.getInstance();
    private JButton btnGetTraktPin;
    private JButton btnTestTraktConnection;
    private JLabel lblTraktStatus;
    private JTextField tfMdbListApiKey;
    private JComboBox cbTraktDate;
    private AutoBinding autobinding_1;

    ExternalServicesSettingsPanel() {
        this.initComponents();
        if (License.getInstance().isValidLicense() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Settings.getInstance().getTraktAccessToken(), Settings.getInstance().getTraktRefreshToken()})) {
            this.lblTraktStatus.setText(TmmResourceBundle.getString("Settings.trakt.status.good"));
        } else {
            this.lblTraktStatus.setText(TmmResourceBundle.getString("Settings.trakt.status.bad"));
        }
        this.btnGetTraktPin.addActionListener(e -> this.getTraktPin());
        this.btnGetTraktPin.setEnabled(License.getInstance().isValidLicense());
        this.btnTestTraktConnection.addActionListener(e -> {
            try {
                TraktTv.getInstance().refreshAccessToken();
                TmmToastManager.showSuccessToast(this, TmmResourceBundle.getString("Settings.trakttv"), TmmResourceBundle.getString("Settings.trakt.testconnection.good"));
            }
            catch (Exception e1) {
                TmmToastManager.showErrorToast(this, TmmResourceBundle.getString("Settings.trakttv"), TmmResourceBundle.getString("Settings.trakt.testconnection.bad"));
            }
        });
        this.btnTestTraktConnection.setEnabled(License.getInstance().isValidLicense());
    }

    private void getTraktPin() {
        try {
            TmmUIHelper.browseUrl("https://trakt.tv/pin/799");
        }
        catch (Exception e1) {
            TmmToastManager.showErrorToast(this, TmmResourceBundle.getString("Settings.trakttv"), TmmResourceBundle.getString("Settings.trakt.getpin.fallback"));
        }
        String pin = JOptionPane.showInputDialog(MainWindow.getFrame(), (Object)TmmResourceBundle.getString("Settings.trakt.getpin.entercode"));
        if (pin == null || pin.isEmpty()) {
            return;
        }
        String accessToken = "";
        String refreshToken = "";
        try {
            Map<String, String> tokens = TraktTv.getInstance().authenticateViaPin(pin);
            accessToken = tokens.get("accessToken") == null ? "" : tokens.get("accessToken");
            refreshToken = tokens.get("refreshToken") == null ? "" : tokens.get("refreshToken");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken, refreshToken})) {
            Settings.getInstance().setTraktAccessToken(accessToken);
            Settings.getInstance().setTraktRefreshToken(refreshToken);
            this.lblTraktStatus.setText(TmmResourceBundle.getString("Settings.trakt.status.good"));
        } else {
            JOptionPane.showMessageDialog(MainWindow.getFrame(), TmmResourceBundle.getString("Settings.trakt.getpin.problem"), TmmResourceBundle.getString("Settings.trakt.getpin"), 0);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Settings.getInstance().getTraktAccessToken(), Settings.getInstance().getTraktRefreshToken()})) {
                this.lblTraktStatus.setText(TmmResourceBundle.getString("Settings.trakt.status.good"));
            } else {
                this.lblTraktStatus.setText(TmmResourceBundle.getString("Settings.trakt.status.bad"));
            }
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][]"));
        JPanel panelTrakt = new JPanel();
        panelTrakt.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][10lp!][]"));
        TmmLabel lblTraktT = new TmmLabel(TmmResourceBundle.getString("Settings.trakt"), 1.16667);
        if (!License.getInstance().isValidLicense()) {
            lblTraktT.setText("*PRO* " + lblTraktT.getText());
        }
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelTrakt, lblTraktT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#trakttv"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.lblTraktStatus = new JLabel("");
        panelTrakt.add((Component)this.lblTraktStatus, "cell 1 0 2 1");
        this.btnGetTraktPin = new JButton(TmmResourceBundle.getString("Settings.trakt.getpin"));
        panelTrakt.add((Component)this.btnGetTraktPin, "cell 1 1 2 1");
        this.btnTestTraktConnection = new JButton(TmmResourceBundle.getString("Settings.trakt.testconnection"));
        panelTrakt.add((Component)this.btnTestTraktConnection, "cell 1 1 2 1");
        TmmLabel lblTraktDateT = new TmmLabel(TmmResourceBundle.getString("Settings.trakt.date"));
        panelTrakt.add((Component)lblTraktDateT, "flowx,cell 1 3 2 1");
        this.cbTraktDate = new JComboBox<DateField>(DateField.values());
        panelTrakt.add((Component)this.cbTraktDate, "cell 1 3 2 1");
        JPanel panelMdbList = new JPanel();
        panelMdbList.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[]"));
        TmmLabel lblMdbListT = new TmmLabel(TmmResourceBundle.getString("Settings.external.rating.mdblist"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMdbList, lblMdbListT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        JLabel lblMdbListApiKeyT = new JLabel(TmmResourceBundle.getString("Settings.api.key"));
        panelMdbList.add((Component)lblMdbListApiKeyT, "cell 1 0 2 1");
        this.tfMdbListApiKey = new JTextField();
        panelMdbList.add((Component)this.tfMdbListApiKey, "cell 1 0 2 1");
        this.tfMdbListApiKey.setColumns(30);
        ReadOnlyTextArea tpMediaPlayer = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.external.rating.mdblist.hint"));
        panelMdbList.add((Component)tpMediaPlayer, "cell 1 1 2 1,growx, wmin 0");
        TmmFontHelper.changeFont((JComponent)tpMediaPlayer, 0.83333);
        this.initDataBindings();
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"traktDateField");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.cbTraktDate, (Property)jComboBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"mdbListApiKey");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autobinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.tfMdbListApiKey, (Property)jTextFieldBeanProperty);
        autobinding_1.bind();
    }
}

