/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import io.jenetics.internal.math.DoubleAdder;
import java.io.Serializable;
import java.util.DoubleSummaryStatistics;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collector;

public final class DoubleSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long _count;
    private final double _min;
    private final double _max;
    private final double _sum;
    private final double _mean;

    private DoubleSummary(long count, double min, double max, double sum, double mean) {
        this._count = count;
        this._min = min;
        this._max = max;
        this._sum = sum;
        this._mean = mean;
    }

    public long getCount() {
        return this._count;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getSum() {
        return this._sum;
    }

    public double getMean() {
        return this._mean;
    }

    public int hashCode() {
        int hash = 17;
        hash = (int)((long)hash + (33L * this._count + 37L));
        hash += 33 * Double.hashCode(this._sum) + 37;
        hash += 33 * Double.hashCode(this._min) + 37;
        hash += 33 * Double.hashCode(this._max) + 37;
        return hash += 33 * Double.hashCode(this._mean) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DoubleSummary && this._count == ((DoubleSummary)obj)._count && Double.compare(this._sum, ((DoubleSummary)obj)._sum) == 0 && Double.compare(this._min, ((DoubleSummary)obj)._min) == 0 && Double.compare(this._max, ((DoubleSummary)obj)._max) == 0 && Double.compare(this._mean, ((DoubleSummary)obj)._mean) == 0;
    }

    public String toString() {
        return String.format("DoubleSummary[N=%d, \u2227=%s, \u2228=%s, \u03a3=%s, \u03bc=%s]", this.getCount(), this.getMin(), this.getMax(), this.getSum(), this.getMean());
    }

    public static DoubleSummary of(long count, double min, double max, double sum, double mean) {
        return new DoubleSummary(count, min, max, sum, mean);
    }

    public static DoubleSummary of(DoubleSummaryStatistics statistics) {
        return new DoubleSummary(statistics.getCount(), statistics.getMin(), statistics.getMax(), statistics.getSum(), statistics.getAverage());
    }

    public static <T> Collector<T, ?, DoubleSummary> toDoubleSummary(ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(DoubleSummaryStatistics::new, (a, b) -> a.accept(mapper.applyAsDouble(b)), (a, b) -> {
            a.combine((DoubleSummaryStatistics)b);
            return a;
        }, DoubleSummary::of, new Collector.Characteristics[0]);
    }

    public static double min(double[] values) {
        double min = Double.NaN;
        if (values.length > 0) {
            min = values[0];
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] < min)) continue;
                min = values[i];
            }
        }
        return min;
    }

    public static double max(double[] values) {
        double max = Double.NaN;
        if (values.length > 0) {
            max = values[0];
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] > max)) continue;
                max = values[i];
            }
        }
        return max;
    }

    public static double sum(double[] values) {
        return DoubleAdder.sum(values);
    }

    public static double mean(double[] values) {
        return values.length > 0 ? DoubleSummary.sum(values) / (double)values.length : Double.NaN;
    }
}

