/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wan.loadbalancing;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.OOoO.return;
import com.ubnt.model.api.wan.WanNetworkGroup;
import com.ubnt.model.api.wan.loadbalancing.ImmutableWanInterfaceConfigurationDto;
import com.ubnt.model.api.wan.loadbalancing.WanLoadBalancingMode;
import com.ubnt.service.wan.loadbalancing.K;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableWanInterfaceConfigurationDto.class)
@JsonDeserialize(builder=ImmutableWanInterfaceConfigurationDto.Builder.class)
@Value.Immutable
@return
public interface WanInterfaceConfigurationDto {
    @JsonProperty(value="name")
    public String name();

    @JsonProperty(value="wan_networkgroup")
    public WanNetworkGroup wanNetworkGroup();

    @JsonProperty(value="mode")
    public WanLoadBalancingMode mode();

    @JsonProperty(value="weight")
    public Optional<@Min(value=1L) @Max(value=99L) Integer> weight();

    @JsonProperty(value="wan_sla")
    public Optional<String> wanSlaProfile();

    @JsonProperty(value="priority")
    public Optional<@Min(value=1L) Integer> priority();

    public static WanInterfaceConfigurationDto of(K k2) {
        return ImmutableWanInterfaceConfigurationDto.builder().name(k2.\u00d500000()).wanNetworkGroup(k2.return()).mode(WanLoadBalancingMode.fromWanLoadBalanceType(k2.\u00d800000())).weight(k2.\u00f400000()).wanSlaProfile(k2.\u00d300000()).priority(k2.\u00d400000()).build();
    }

    default public K toWanInterfaceConfiguration() {
        return K.new().\u00d800000(this.name()).super(this.wanNetworkGroup()).\u00d400000(this.mode().toWanLoadBalanceType()).\u00f600000(this.weight()).int(this.wanSlaProfile()).class(this.priority().orElse(this.wanNetworkGroup().index())).\u00d200000();
    }
}

