/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.sslinspection.certificate;

import com.google.common.base.Splitter;
import com.ubnt.service.sslinspection.certificate.SslCertificateDetailsDocumentPart;
import com.ubnt.service.sslinspection.certificate.SslCertificateDistinguishedNameDocumentPart;
import com.ubnt.service.sslinspection.certificate.SslCertificateOverviewDocumentPart;
import com.ubnt.service.system.jA;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

class F {
    private static final Logger o00000 = jA.\u00f4\u00d20000;

    F() {
    }

    Optional<SslCertificateDetailsDocumentPart> String(X509Certificate x509Certificate) {
        try {
            return Optional.of(this.\u00d500000(x509Certificate));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            o00000.warn("Cannot parse certificate: {}", (Object)certificateEncodingException.getMessage(), (Object)certificateEncodingException);
            return Optional.empty();
        }
    }

    private SslCertificateDetailsDocumentPart \u00d500000(X509Certificate x509Certificate) throws CertificateEncodingException {
        JcaX509CertificateHolder jcaX509CertificateHolder = new JcaX509CertificateHolder(x509Certificate);
        X500Name x500Name = jcaX509CertificateHolder.getIssuer();
        X500Name x500Name2 = jcaX509CertificateHolder.getSubject();
        String string = jcaX509CertificateHolder.getSerialNumber().toString();
        long l2 = jcaX509CertificateHolder.getNotBefore().toInstant().toEpochMilli();
        long l3 = jcaX509CertificateHolder.getNotAfter().toInstant().toEpochMilli();
        return SslCertificateDetailsDocumentPart.builder().new(SslCertificateDistinguishedNameDocumentPart.builder().String(this.\u00d200000(x500Name, BCStyle.CN).orElse(null)).o00000(this.\u00d200000(x500Name, BCStyle.C).orElse(null)).null(this.\u00d200000(x500Name, BCStyle.E).orElse(null)).\u00d300000(this.\u00d200000(x500Name, BCStyle.L).orElse(null)).\u00d200000(this.\u00d200000(x500Name, BCStyle.ST).orElse(null)).\u00d500000(this.\u00d200000(x500Name, BCStyle.O).orElse(null)).\u00d600000(this.\u00d200000(x500Name, BCStyle.OU).orElse(null)).\u00d800000()).\u00d400000(SslCertificateDistinguishedNameDocumentPart.builder().String(this.\u00d200000(x500Name2, BCStyle.CN).orElse(null)).o00000(this.\u00d200000(x500Name2, BCStyle.C).orElse(null)).null(this.\u00d200000(x500Name2, BCStyle.E).orElse(null)).\u00d300000(this.\u00d200000(x500Name2, BCStyle.L).orElse(null)).\u00d200000(this.\u00d200000(x500Name2, BCStyle.ST).orElse(null)).\u00d500000(this.\u00d200000(x500Name2, BCStyle.O).orElse(null)).\u00d600000(this.\u00d200000(x500Name2, BCStyle.OU).orElse(null)).\u00d800000()).o00000(SslCertificateOverviewDocumentPart.builder().\u00d600000(l2).\u00d300000(l3).\u00d800000(this.o00000(x509Certificate).orElse(null)).o00000(string).\u00d200000(jcaX509CertificateHolder.getVersionNumber()).String()).\u00d300000();
    }

    private Optional<String> \u00d200000(X500Name x500Name, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        RDN[] rDNArray = x500Name.getRDNs(aSN1ObjectIdentifier);
        if (rDNArray.length != 1) {
            return Optional.empty();
        }
        RDN rDN = rDNArray[0];
        try {
            return Optional.of(IETFUtils.valueToString((ASN1Encodable)rDN.getFirst().getValue()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private Optional<String> o00000(X509Certificate x509Certificate) {
        try {
            String string = Hex.toHexString((byte[])MessageDigest.getInstance("SHA-1").digest(x509Certificate.getEncoded()));
            return Optional.of(this.\u00d300000(string));
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            o00000.warn("Cannot calculate certificate fingerprint: {}", (Object)generalSecurityException.getMessage());
            return Optional.empty();
        }
    }

    private String \u00d300000(String string) {
        Splitter splitter = Splitter.fixedLength((int)2);
        return splitter.splitToStream((CharSequence)string).map(String::toUpperCase).collect(Collectors.joining(":"));
    }
}

