/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.ubnt.data.Site;
import com.ubnt.data.User;
import com.ubnt.data.X;
import com.ubnt.model.api.FingerprintOverride;
import com.ubnt.model.api.MissingFingerprint;
import com.ubnt.model.api.PaginatedResponse;
import com.ubnt.model.api.fingerprint.FingerprintOverrideDto;
import com.ubnt.model.api.fingerprint.FingerprintOverridesListDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.RequireUCoreLocal;
import com.ubnt.net.v2.exception.RequestValidationException;
import com.ubnt.net.v2.exception.ResourceNotFoundException;
import com.ubnt.service.devmgr.newString;
import com.ubnt.service.fingerprint.F;
import com.ubnt.service.fingerprint.L;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Fingerprint Override")
public class FingerprintOverrideController {
    private final newString o00000;
    private final L \u00d300000;
    private final F new;

    public FingerprintOverrideController(newString newString2, L l2, F f2) {
        this.o00000 = newString2;
        this.\u00d300000 = l2;
        this.new = f2;
    }

    @GetMapping(value={"/api/ai-fingerprint/site/{siteName}/station/{mac}/fingerprint_override"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    public FingerprintOverride getFingerprintOverrideForAi(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string) {
        String string2 = site.getId();
        return new FingerprintOverride().setDevIdOverride(this.\u00d300000.\u00d200000(string2, string)).setMac(string).setMachineLearningEngineVersion(this.super());
    }

    @GetMapping(value={"/api/site/{siteName}/ai-fingerprint/fingerprint_overrides"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    public FingerprintOverridesListDto getAllFingerprintOverridesForAi(@PathVariable(value="siteName") Site site) {
        return FingerprintOverridesListDto.of(this.super(), this.\u00d300000.\u00d800000(site.getId()).stream().map(FingerprintOverrideDto::of).collect(Collectors.toList()));
    }

    private int super() {
        return this.new.o00000() ? 1 : 0;
    }

    @PutMapping(value={"/api/site/{siteName}/station/{mac}/fingerprint_override"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public FingerprintOverride overrideFingerprint(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string, @RequestBody FingerprintOverride fingerprintOverride) {
        this.\u00d300000(fingerprintOverride.getDevIdOverride(), string, site.getId());
        this.\u00d300000.null(site, string, fingerprintOverride.getDevIdOverride());
        return new FingerprintOverride().setSearchQuery(fingerprintOverride.getSearchQuery()).setDevIdOverride(fingerprintOverride.getDevIdOverride()).setMac(string);
    }

    @PostMapping(value={"/api/site/{siteName}/fingerprint_override"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PaginatedResponse<FingerprintOverride> overrideFingerprintBatch(@PathVariable(value="siteName") Site site, @RequestBody PaginatedResponse<FingerprintOverride> paginatedResponse) {
        ArrayList<PaginatedResponse.Error> arrayList = new ArrayList<PaginatedResponse.Error>();
        List list = paginatedResponse.getData().stream().map(fingerprintOverride -> {
            try {
                this.\u00d300000(fingerprintOverride.getDevIdOverride(), fingerprintOverride.getMac(), site.getId());
                this.\u00d300000.null(site, fingerprintOverride.getMac(), fingerprintOverride.getDevIdOverride());
                return fingerprintOverride;
            }
            catch (RequestValidationException requestValidationException) {
                arrayList.add(new PaginatedResponse.Error(fingerprintOverride.getMac(), 400, requestValidationException.getMessage()));
                return null;
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                arrayList.add(new PaginatedResponse.Error(fingerprintOverride.getMac(), 404, resourceNotFoundException.getMessage()));
                return null;
            }
            catch (Exception exception) {
                arrayList.add(new PaginatedResponse.Error(fingerprintOverride.getMac(), 500, exception.getMessage()));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return PaginatedResponse.of(list).setErrors(arrayList);
    }

    @PutMapping(value={"/api/site/{siteName}/station/{mac}/missing_fingerprint"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public MissingFingerprint missingFingerprint(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string, @RequestBody MissingFingerprint missingFingerprint) {
        this.\u00d400000(string, site.getId());
        this.\u00d300000.o00000(site, string, missingFingerprint);
        return missingFingerprint;
    }

    @PostMapping(value={"/api/site/{siteName}/missing_fingerprint"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PaginatedResponse<MissingFingerprint> missingFingerprintBatch(@PathVariable(value="siteName") Site site, @RequestBody PaginatedResponse<MissingFingerprint> paginatedResponse) {
        ArrayList<PaginatedResponse.Error> arrayList = new ArrayList<PaginatedResponse.Error>();
        List list = paginatedResponse.getData().stream().map(missingFingerprint -> {
            try {
                this.\u00d400000(missingFingerprint.getMac(), site.getId());
                this.\u00d300000.o00000(site, missingFingerprint.getMac(), (MissingFingerprint)missingFingerprint);
                return missingFingerprint;
            }
            catch (RequestValidationException requestValidationException) {
                arrayList.add(new PaginatedResponse.Error(missingFingerprint.getMac(), 400, requestValidationException.getMessage()));
                return null;
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                arrayList.add(new PaginatedResponse.Error(missingFingerprint.getMac(), 404, resourceNotFoundException.getMessage()));
                return null;
            }
            catch (Exception exception) {
                arrayList.add(new PaginatedResponse.Error(missingFingerprint.getMac(), 500, exception.getMessage()));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return PaginatedResponse.of(list).setErrors(arrayList);
    }

    @DeleteMapping(value={"/api/site/{siteName}/station/{mac}/fingerprint_override"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteOverride(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string) {
        String string2 = site.getId();
        this.\u00d400000(string, string2);
        this.\u00d300000.\u00d600000(string2, string);
    }

    private void \u00d300000(Integer n2, String string, String string2) {
        if (n2 == null) {
            throw new RequestValidationException("dev_id_override is required");
        }
        this.\u00d400000(string, string2);
    }

    private void \u00d400000(String string, String string2) {
        User user;
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new RequestValidationException("mac address cannot be blank");
        }
        X x2 = this.o00000.\u00d5O0O00(string2, string);
        if (x2 == null && (user = this.o00000.returnreturnreturn(string2, string)) == null) {
            throw new ResourceNotFoundException("sta/user for mac " + string + " could not be found");
        }
    }
}

